/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.server.storage.SLStorage;
import top.seraphjack.simplelogin.utils.SHA256;

public class MessageChangePassword {
    private final String original;
    private final String to;

    public MessageChangePassword(String original, String to) {
        this.original = SHA256.getSHA256(original);
        this.to = SHA256.getSHA256(to);
    }

    public static void encode(MessageChangePassword msg, PacketBuffer buf) {
        buf.func_211400_a(msg.original, 200);
        buf.func_211400_a(msg.to, 200);
    }

    public static MessageChangePassword decode(PacketBuffer buf) {
        return new MessageChangePassword(buf.func_150789_c(200), buf.func_150789_c(200));
    }

    public static void handle(MessageChangePassword msg, Supplier<NetworkEvent.Context> ctx) {
        String username = Objects.requireNonNull(ctx.get().getSender()).func_146103_bH().getName();
        if (SLStorage.instance().storageProvider.checkPassword(username, msg.original)) {
            SLStorage.instance().storageProvider.changePassword(username, msg.to);
            Objects.requireNonNull(ctx.get().getSender()).func_146105_b((ITextComponent)new StringTextComponent("Password changed successfully."), false);
        } else {
            Objects.requireNonNull(ctx.get().getSender()).func_146105_b((ITextComponent)new StringTextComponent("Wrong original password."), false);
            SimpleLogin.logger.warn("Player " + username + " tried to change password with a wrong password.");
        }
        ctx.get().setPacketHandled(true);
    }
}

