/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SLConstants;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.capability.CapabilityLoader;
import top.seraphjack.simplelogin.server.capability.ILastPos;
import top.seraphjack.simplelogin.server.storage.Position;
import top.seraphjack.simplelogin.server.storage.SLStorage;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public final class PlayerLoginHandler {
    private static Thread PLAYER_HANDLER_THREAD;
    private static PlayerLoginHandler INSTANCE;
    private boolean alive;
    private final ConcurrentLinkedQueue<Login> loginList = new ConcurrentLinkedQueue();
    private long lastEntriesSaved;

    private PlayerLoginHandler() {
        PLAYER_HANDLER_THREAD = new Thread(() -> {
            this.lastEntriesSaved = System.currentTimeMillis();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            while (this.alive) {
                try {
                    for (Login login : this.loginList) {
                        ServerPlayerEntity player = server.func_184103_al().func_152612_a(login.name);
                        if (player == null) {
                            SimpleLogin.logger.debug("Can't find player " + login.name + ", ignoring...");
                            this.loginList.remove(login);
                            continue;
                        }
                        if (System.currentTimeMillis() - login.lastRequested >= 1000L) {
                            SimpleLogin.logger.debug("Resending login request to {}...", (Object)login.name);
                            NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageRequestLogin());
                            login.lastRequested = System.currentTimeMillis();
                        }
                        server.func_213165_a(() -> player.field_71135_a.func_147364_a(login.posX, login.posY, login.posZ, login.yaw, login.pitch));
                        if (System.currentTimeMillis() - login.time < (long)((Integer)SLConfig.SERVER.secs.get() * 1000)) continue;
                        player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Login timed out."));
                        this.loginList.removeIf(i -> i.name.equals(player.func_146103_bH().getName()));
                        SimpleLogin.logger.warn("Player " + login.name + " haven't login after a long time.");
                        this.loginList.remove(login);
                    }
                    if (System.currentTimeMillis() - this.lastEntriesSaved >= 300000L) {
                        this.lastEntriesSaved = System.currentTimeMillis();
                        if (SLStorage.instance().storageProvider.dirty()) {
                            SimpleLogin.logger.info("Auto saving entries");
                            long start = System.currentTimeMillis();
                            SLStorage.instance().storageProvider.save();
                            SimpleLogin.logger.info("Done! Took " + (System.currentTimeMillis() - start) + "ms.");
                        }
                    }
                    if (this.loginList.isEmpty()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    Thread.sleep(400L);
                }
                catch (Throwable e) {
                    SimpleLogin.logger.error("Exception caught in PlayerLoginHandler thread", e);
                }
            }
        }, "Simple-Login-Handler-Thread");
        this.alive = true;
        PLAYER_HANDLER_THREAD.start();
    }

    public static PlayerLoginHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerLoginHandler();
        }
        return INSTANCE;
    }

    @Nullable
    private Login getLoginByName(String name) {
        return this.loginList.stream().filter(l -> l.name.equals(name)).findAny().orElse(null);
    }

    public void login(String id, String pwd) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Login login = this.getLoginByName(id);
        this.loginList.remove(login);
        ServerPlayerEntity player = server.func_184103_al().func_152612_a(id);
        if (login == null || player == null) {
            return;
        }
        if (pwd.length() >= 100) {
            player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Password too long."));
            SimpleLogin.logger.warn("Player " + id + " tried to login with a invalid password(too long).");
        } else if (!SLStorage.instance().storageProvider.registered(id)) {
            SLStorage.instance().storageProvider.register(id, pwd);
            this.afterPlayerLogin(login, player);
            SimpleLogin.logger.info("Player " + id + " has successfully registered.");
        } else if (SLStorage.instance().storageProvider.checkPassword(id, pwd)) {
            this.afterPlayerLogin(login, player);
            SimpleLogin.logger.info("Player " + id + " has successfully logged in.");
        } else {
            SimpleLogin.logger.warn("Player " + id + " tried to login with a wrong password.");
            player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Wrong Password."));
        }
    }

    public void playerJoin(ServerPlayerEntity player) {
        this.loginList.add(new Login(player));
        player.func_71033_a(GameType.SPECTATOR);
    }

    public void playerLeave(ServerPlayerEntity player) {
        String username = player.func_146103_bH().getName();
        Position pos = new Position(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        if (!this.isPlayerInLoginList(username)) {
            player.getCapability(CapabilityLoader.CAPABILITY_LAST_POS).ifPresent(c -> c.setLastPos(pos));
        }
        if (((Boolean)SLConfig.SERVER.protectPlayerCoord.get()).booleanValue()) {
            try {
                IWorldInfo info = player.func_71121_q().func_72912_H();
                player.func_70107_b((double)info.func_76079_c(), (double)info.func_76075_d(), (double)info.func_76074_e());
            }
            catch (Exception ex) {
                SimpleLogin.logger.error("Fail to set player position to spawn point when logging out.", (Throwable)ex);
            }
        }
    }

    public boolean isPlayerInLoginList(String id) {
        return this.loginList.stream().anyMatch(e -> e.name.equals(id));
    }

    private void afterPlayerLogin(Login login, ServerPlayerEntity player) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        server.func_213165_a(() -> {
            player.func_71033_a(SLStorage.instance().storageProvider.gameType(login.name));
            if (((Boolean)SLConfig.SERVER.protectPlayerCoord.get()).booleanValue()) {
                Position lastPos = ((ILastPos)player.getCapability(CapabilityLoader.CAPABILITY_LAST_POS).orElseThrow(RuntimeException::new)).getLastPos();
                if (lastPos.equals(SLConstants.defaultPosition)) {
                    player.func_70107_b(login.posX, login.posY, login.posZ);
                } else {
                    player.func_70634_a(lastPos.getX(), lastPos.getY(), lastPos.getZ());
                }
            }
        });
    }

    void stop() {
        SimpleLogin.logger.info("Shutting down player login handler");
        this.alive = false;
        try {
            PLAYER_HANDLER_THREAD.join();
        }
        catch (InterruptedException e) {
            SimpleLogin.logger.error("Fail to shutdown login handler", (Throwable)e);
        }
    }

    private static class Login {
        String name;
        long time;
        double posX;
        double posY;
        double posZ;
        float yaw;
        float pitch;
        long lastRequested;

        Login(ServerPlayerEntity player) {
            this.name = player.func_146103_bH().getName();
            this.time = System.currentTimeMillis();
            this.posX = player.func_226277_ct_();
            this.posY = player.func_226278_cu_();
            this.posZ = player.func_226281_cx_();
            this.yaw = player.field_70177_z;
            this.pitch = player.field_70125_A;
            this.lastRequested = System.currentTimeMillis();
        }
    }
}

