/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server;

import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import top.seraphjack.simplelogin.SLConfig;
import top.seraphjack.simplelogin.SimpleLogin;
import top.seraphjack.simplelogin.network.MessageRequestLogin;
import top.seraphjack.simplelogin.network.NetworkLoader;
import top.seraphjack.simplelogin.server.PlayerLoginHandler;

@OnlyIn(value=Dist.DEDICATED_SERVER)
@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, modid="simplelogin")
public class ServerSideEventHandler {
    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerLoginHandler.instance().playerJoin((ServerPlayerEntity)event.getPlayer());
        NetworkLoader.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageRequestLogin());
    }

    @SubscribeEvent
    public static void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerLoginHandler.instance().playerLeave((ServerPlayerEntity)event.getEntity());
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        String command = event.getParseResults().getReader().getString();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        SimpleLogin.logger.debug("Checking command {}", (Object)command);
        if (!(((CommandSource)event.getParseResults().getContext().getSource()).func_197022_f() instanceof ServerPlayerEntity)) {
            return;
        }
        if (!PlayerLoginHandler.instance().isPlayerInLoginList(((CommandSource)event.getParseResults().getContext().getSource()).func_197037_c())) {
            return;
        }
        if (((List)SLConfig.SERVER.commandNames.get()).contains(command)) {
            return;
        }
        SimpleLogin.logger.debug("Denied {} to execute command {} before login", (Object)((CommandSource)event.getParseResults().getContext().getSource()).func_197037_c(), (Object)command);
        event.setCanceled(true);
    }
}

