/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.seraphjack.simplelogin.SLConstants;
import top.seraphjack.simplelogin.server.capability.CapabilityLoader;
import top.seraphjack.simplelogin.server.capability.ILastPos;
import top.seraphjack.simplelogin.server.storage.Position;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public class CapabilityLastPos {

    public static class Implementation
    implements ILastPos {
        Position lastPos = SLConstants.defaultPosition;

        @Override
        public Position getLastPos() {
            return this.lastPos;
        }

        @Override
        public void setLastPos(Position pos) {
            this.lastPos = pos;
        }
    }

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        private final ILastPos lastPos = new Implementation();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityLoader.CAPABILITY_LAST_POS) {
                return LazyOptional.of(() -> this.lastPos);
            }
            return LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return CapabilityLoader.CAPABILITY_LAST_POS.getStorage().writeNBT(CapabilityLoader.CAPABILITY_LAST_POS, (Object)this.lastPos, null);
        }

        public void deserializeNBT(INBT nbt) {
            CapabilityLoader.CAPABILITY_LAST_POS.getStorage().readNBT(CapabilityLoader.CAPABILITY_LAST_POS, (Object)this.lastPos, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<ILastPos> {
        @Nullable
        public INBT writeNBT(Capability<ILastPos> capability, ILastPos instance, Direction side) {
            return instance.getLastPos().toNBT();
        }

        public void readNBT(Capability<ILastPos> capability, ILastPos instance, Direction side, INBT nbt) {
            instance.setLastPos(Position.fromNBT((CompoundNBT)nbt));
        }
    }
}

