/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.multiple;

import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.multiple.TwoByTwoFurniture;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntityDouble;
import com.mcwfurnitures.kikoz.util.parts.LargeFurniturePart;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TwoByTwoFurnitureStorage
extends TwoByTwoFurniture
implements IWaterLoggable {
    private static final EnumProperty<LargeFurniturePart> PART = EnumProperty.func_177709_a((String)"part", LargeFurniturePart.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final Map<Direction, VoxelShape> FURNITURE_MIDDLE = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_MIDDLE_LEFT = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_BOTTOM = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> FURNITURE_BOTTOM_LEFT = new HashMap<Direction, VoxelShape>();
    String infoname;
    boolean hasTextInfo = true;

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        LargeFurniturePart part = (LargeFurniturePart)((Object)state.func_177229_b(PART));
        if (part == LargeFurniturePart.BOTTOM) {
            return FURNITURE_BOTTOM.get(state.func_177229_b((Property)FACING));
        }
        if (part == LargeFurniturePart.BOTTOM_LEFT) {
            return FURNITURE_BOTTOM_LEFT.get(state.func_177229_b((Property)FACING));
        }
        if (part == LargeFurniturePart.MIDDLE) {
            return FURNITURE_MIDDLE.get(state.func_177229_b((Property)FACING));
        }
        if (part == LargeFurniturePart.MIDDLE_LEFT) {
            return FURNITURE_MIDDLE_LEFT.get(state.func_177229_b((Property)FACING));
        }
        return FURNITURE_MIDDLE.get(state.func_177229_b((Property)FACING));
    }

    @Override
    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM))).func_206870_a((Property)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    @Override
    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        BlockPos FurnitureMiddleLeftPos = this.getFurnitureMiddleLeftPos(pos, direction);
        BlockPos FurnitureBottomLeftPos = this.getFurnitureBottomLeftPos(pos, direction);
        FluidState middleFluidState = world.func_204610_c(pos.func_177984_a());
        FluidState middleWestFluidState = world.func_204610_c(pos.func_177984_a().func_177976_e());
        FluidState bottomWestFluidState = world.func_204610_c(pos.func_177976_e());
        world.func_180501_a(FurnitureBottomLeftPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM_LEFT))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bottomWestFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(middleFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        world.func_180501_a(FurnitureMiddleLeftPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.MIDDLE_LEFT))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(middleWestFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    @Override
    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos FurniturePartPos;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos FurniturePos = this.getFurniturePos(pos, (LargeFurniturePart)((Object)state.func_177229_b(PART)), facing);
        BlockState FurnitureBlockState = world.func_180495_p(FurniturePos);
        if (FurnitureBlockState.func_177230_c() == this && !pos.equals((Object)FurniturePos)) {
            this.removePart(world, FurniturePos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddleLeftPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddleRightPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureBottomLeftPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureBottomRightPos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
    }

    private BlockPos getFurnitureMiddlePos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a();
            }
            case EAST: {
                return base.func_177984_a();
            }
            case SOUTH: {
                return base.func_177984_a();
            }
            case WEST: {
                return base.func_177984_a();
            }
        }
        return base.func_177984_a();
    }

    private BlockPos getFurnitureMiddleLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a().func_177976_e();
            }
            case EAST: {
                return base.func_177984_a().func_177978_c();
            }
            case SOUTH: {
                return base.func_177984_a().func_177974_f();
            }
            case WEST: {
                return base.func_177984_a().func_177968_d();
            }
        }
        return base.func_177984_a().func_177974_f();
    }

    private BlockPos getFurnitureMiddleRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a().func_177974_f();
            }
            case EAST: {
                return base.func_177984_a().func_177968_d();
            }
            case SOUTH: {
                return base.func_177984_a().func_177976_e();
            }
            case WEST: {
                return base.func_177984_a().func_177978_c();
            }
        }
        return base.func_177984_a().func_177976_e();
    }

    private BlockPos getFurnitureBottomLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177976_e();
            }
            case EAST: {
                return base.func_177978_c();
            }
            case SOUTH: {
                return base.func_177974_f();
            }
            case WEST: {
                return base.func_177968_d();
            }
        }
        return base.func_177974_f();
    }

    private BlockPos getFurnitureBottomRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177974_f();
            }
            case EAST: {
                return base.func_177968_d();
            }
            case SOUTH: {
                return base.func_177976_e();
            }
            case WEST: {
                return base.func_177978_c();
            }
        }
        return base.func_177976_e();
    }

    private BlockPos getFurniturePos(BlockPos pos, LargeFurniturePart part, Direction facing) {
        if (part == LargeFurniturePart.BOTTOM) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177976_e();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177976_e();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177978_c();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177978_c();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177974_f();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177974_f();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case MIDDLE: {
                        return pos.func_177977_b();
                    }
                    case MIDDLE_LEFT: {
                        return pos.func_177977_b().func_177968_d();
                    }
                    case BOTTOM_LEFT: {
                        return pos.func_177968_d();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.STORAGE_CHEST.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            TileEntity tilenorth = worldIn.func_175625_s(pos.func_177985_f(-1));
            TileEntity tileeast = worldIn.func_175625_s(pos.func_177964_d(-1));
            TileEntity tilesouth = worldIn.func_175625_s(pos.func_177985_f(1));
            TileEntity tilewest = worldIn.func_175625_s(pos.func_177964_d(1));
            TileEntity tiledown = worldIn.func_175625_s(pos.func_177979_c(1));
            TileEntity tilenorth2 = worldIn.func_175625_s(pos.func_177985_f(-1).func_177979_c(1));
            TileEntity tileeast2 = worldIn.func_175625_s(pos.func_177964_d(-1).func_177979_c(1));
            TileEntity tilesouth2 = worldIn.func_175625_s(pos.func_177985_f(1).func_177979_c(1));
            TileEntity tilewest2 = worldIn.func_175625_s(pos.func_177964_d(1).func_177979_c(1));
            LargeFurniturePart part = (LargeFurniturePart)((Object)state.func_177229_b(PART));
            if (tile instanceof FurnitureTileEntityDouble) {
                if (part == LargeFurniturePart.BOTTOM_LEFT) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tile), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.BOTTOM && state.func_177229_b((Property)FACING) == Direction.NORTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilenorth), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.BOTTOM && state.func_177229_b((Property)FACING) == Direction.EAST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tileeast), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.BOTTOM && state.func_177229_b((Property)FACING) == Direction.SOUTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilesouth), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.BOTTOM && state.func_177229_b((Property)FACING) == Direction.WEST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilewest), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.MIDDLE_LEFT) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tiledown), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.MIDDLE && state.func_177229_b((Property)FACING) == Direction.NORTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilenorth2), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.MIDDLE && state.func_177229_b((Property)FACING) == Direction.EAST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tileeast2), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.MIDDLE && state.func_177229_b((Property)FACING) == Direction.SOUTH) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilesouth2), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
                if (part == LargeFurniturePart.MIDDLE && state.func_177229_b((Property)FACING) == Direction.WEST) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntityDouble)tilewest2), (BlockPos)pos);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntityDouble) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((FurnitureTileEntityDouble)te).func_190576_q());
        }
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        FluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos FurnitureMiddlePos = this.getFurnitureMiddlePos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureMiddleLeftPos = this.getFurnitureMiddleLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureMiddleRightPos = this.getFurnitureMiddleRightPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureBottomLeftPos = this.getFurnitureBottomLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos FurnitureBottomRightPos = this.getFurnitureBottomRightPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && FurnitureMiddlePos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context) && FurnitureMiddleLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureMiddleLeftPos).func_196953_a(context) && FurnitureMiddleRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureMiddleRightPos).func_196953_a(context) && FurnitureBottomLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureBottomLeftPos).func_196953_a(context) && FurnitureBottomRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(FurnitureBottomRightPos).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, WATERLOGGED});
    }

    public TwoByTwoFurnitureStorage() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)LargeFurniturePart.BOTTOM)));
    }

    static {
        FURNITURE_MIDDLE.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_MIDDLE_LEFT.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.EAST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.NORTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.WEST, Stream.of(Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
        FURNITURE_BOTTOM_LEFT.put(Direction.SOUTH, Stream.of(Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.01, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }
}

