/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.common.collect.Maps;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.textures.FontRendererWithAtlas;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.DrownedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.PolarBearModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SkeletonModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.DyeableHorseArmorItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;

public class Radar
implements IRadar {
    private Minecraft game;
    private IVoxelMap master = null;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    private FontRendererWithAtlas fontRenderer;
    private TextureAtlas textureAtlas;
    private boolean newMobs = false;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    public HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    public HashMap<String, Integer> contactsSkinGetTries = new HashMap();
    private Sprite clothIcon = null;
    private static final int CLOTH = 0;
    private static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    private String[] armorNames = new String[]{"cloth", "clothOverlay", "clothOuter", "clothOverlayOuter", "chain", "iron", "gold", "diamond", "netherite", "turtle"};
    private final float iconScale = 4.0f;
    private boolean randomobsOptifine = false;
    private Class<?> randomEntitiesClass = null;
    private Field mapPropertiesField = null;
    private Map<String, ?> mapProperties = null;
    private Field randomEntityField = null;
    private Object randomEntity = null;
    private Class<?> iRandomEntityClass = null;
    private Class<?> randomEntityClass = null;
    private Method setEntityMethod = null;
    private Class<?> randomEntitiesPropertiesClass = null;
    private Method getEntityTextureMethod = null;
    private boolean hasCustomNPCs = false;
    private Class<?> entityCustomNpcClass = null;
    private Class<?> modelDataClass = null;
    private Class<?> entityNPCInterfaceClass = null;
    private Field modelDataField = null;
    private Method getEntityMethod = null;
    private boolean lastOutlines = true;
    UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
    private final PlayerModel<? extends LivingEntity> playerArmorModel;
    private final BipedModel<? extends LivingEntity> bipedArmorModel;
    private final SkeletonModel<? extends SkeletonEntity> strayOverlayModel;
    private final DrownedModel<? extends ZombieEntity> drownedOverlayModel;
    private final BipedModel<? extends LivingEntity> piglinArmorModel;
    private DynamicTexture nativeBackedTexture = new DynamicTexture(2, 2, false);
    private final ResourceLocation nativeBackedTextureLocation = new ResourceLocation("voxelmap", "tempimage");
    private static final Int2ObjectMap<ResourceLocation> LEVEL_TO_ID = (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), int2ObjectOpenHashMap -> {
        int2ObjectOpenHashMap.put(1, (Object)new ResourceLocation("stone"));
        int2ObjectOpenHashMap.put(2, (Object)new ResourceLocation("iron"));
        int2ObjectOpenHashMap.put(3, (Object)new ResourceLocation("gold"));
        int2ObjectOpenHashMap.put(4, (Object)new ResourceLocation("emerald"));
        int2ObjectOpenHashMap.put(5, (Object)new ResourceLocation("diamond"));
    });
    private static final Map<CoatTypes, ResourceLocation> TEXTURES = (Map)Util.func_200696_a((Object)Maps.newEnumMap(CoatTypes.class), enumMap -> {
        enumMap.put(CoatTypes.NONE, null);
        enumMap.put(CoatTypes.WHITE, new ResourceLocation("textures/entity/horse/horse_markings_white.png"));
        enumMap.put(CoatTypes.WHITE_FIELD, new ResourceLocation("textures/entity/horse/horse_markings_whitefield.png"));
        enumMap.put(CoatTypes.WHITE_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_whitedots.png"));
        enumMap.put(CoatTypes.BLACK_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_blackdots.png"));
    });

    public Radar(IVoxelMap master) {
        this.master = master;
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = Minecraft.func_71410_x();
        this.fontRenderer = new FontRendererWithAtlas(this.game.func_110434_K(), new ResourceLocation("textures/font/ascii.png"));
        this.textureAtlas = new TextureAtlas("mobs");
        this.textureAtlas.func_174937_a(false, false);
        try {
            this.randomEntitiesClass = Class.forName("net.optifine.RandomEntities");
            this.mapPropertiesField = this.randomEntitiesClass.getDeclaredField("mapProperties");
            this.mapPropertiesField.setAccessible(true);
            this.mapProperties = (Map)this.mapPropertiesField.get(null);
            this.randomEntityField = this.randomEntitiesClass.getDeclaredField("randomEntity");
            this.randomEntityField.setAccessible(true);
            this.randomEntity = this.randomEntityField.get(null);
            this.iRandomEntityClass = Class.forName("net.optifine.IRandomEntity");
            this.randomEntityClass = Class.forName("net.optifine.RandomEntity");
            Class[] argClasses1 = new Class[]{Entity.class};
            this.setEntityMethod = this.randomEntityClass.getDeclaredMethod("setEntity", argClasses1);
            this.randomEntitiesPropertiesClass = Class.forName("net.optifine.RandomEntityProperties");
            Class[] argClasses2 = new Class[]{ResourceLocation.class, this.iRandomEntityClass};
            this.getEntityTextureMethod = this.randomEntitiesPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
            this.randomobsOptifine = true;
        }
        catch (ClassNotFoundException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchMethodException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchFieldException e) {
            this.randomobsOptifine = false;
        }
        catch (SecurityException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalArgumentException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalAccessException e) {
            this.randomobsOptifine = false;
        }
        try {
            this.entityCustomNpcClass = Class.forName("noppes.npcs.entity.EntityCustomNpc");
            this.modelDataClass = Class.forName("noppes.npcs.ModelData");
            this.modelDataField = this.entityCustomNpcClass.getField("modelData");
            this.entityNPCInterfaceClass = Class.forName("noppes.npcs.entity.EntityNPCInterface");
            this.getEntityMethod = this.modelDataClass.getMethod("getEntity", this.entityNPCInterfaceClass);
            this.hasCustomNPCs = true;
        }
        catch (ClassNotFoundException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchFieldException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchMethodException e) {
            this.hasCustomNPCs = false;
        }
        this.playerArmorModel = new PlayerModel(1.0f, false);
        this.bipedArmorModel = new BipedModel(1.0f);
        this.strayOverlayModel = new SkeletonModel(0.25f, true);
        this.drownedOverlayModel = new DrownedModel(0.25f, 0.0f, 64, 64);
        this.piglinArmorModel = new BipedModel(1.15f);
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.loadTexturePackIcons();
        this.fontRenderer.func_195410_a(resourceManager);
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.mpContactsSkinGetTries.clear();
            this.contactsSkinGetTries.clear();
            this.textureAtlas.reset();
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png") : new ResourceLocation("textures/block/red_mushroom.png");
            for (int t = 0; t < EnumMobs.values().length - 1; ++t) {
                String ResourceLocation2 = "minecraft." + EnumMobs.values()[t].id;
                String identifierSimple = EnumMobs.values()[t].id;
                String spriteName = ResourceLocation2 + EnumMobs.values()[t].resourceLocation.toString();
                spriteName = spriteName + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "");
                BufferedImage mobImage = this.getCustomMobImage(ResourceLocation2, identifierSimple);
                if (mobImage != null) {
                    Sprite sprite = this.textureAtlas.registerIconForBufferedImage(ResourceLocation2 + "custom", mobImage);
                    this.textureAtlas.registerMaskedIcon(spriteName, sprite);
                    continue;
                }
                this.textureAtlas.registerFailedIcon(ResourceLocation2 + "custom");
                if (!((double)EnumMobs.values()[t].expectedWidth > 0.5) || (mobImage = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation, null)) == null) continue;
                float scale = (float)mobImage.getWidth() / EnumMobs.values()[t].expectedWidth;
                mobImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobImage, 4.0f / scale)), this.options.outlines, 2);
                this.textureAtlas.registerIconForBufferedImage(spriteName, mobImage);
            }
            BufferedImage[] armorImages = new BufferedImage[]{ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8)};
            for (int t = 0; t < armorImages.length; ++t) {
                float scale = (float)armorImages[t].getWidth() / 8.0f;
                armorImages[t] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorImages[t], 4.0f / scale * 47.0f / 38.0f)), this.options.outlines && t != 2 && t != 3, true, 37.6f, 37.6f, 2);
                Sprite icon = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t], armorImages[t]);
                if (t != 0) continue;
                this.clothIcon = icon;
            }
            BufferedImage zombie = ImageUtils.loadImage(EnumMobs.ZOMBIE.resourceLocation, 8, 8, 8, 8, 64, 64);
            float scale = (float)zombie.getWidth() / 8.0f;
            zombie = ImageUtils.scaleImage(zombie, 4.0f / scale * 47.0f / 38.0f);
            BufferedImage zombieHat = ImageUtils.loadImage(EnumMobs.ZOMBIE.resourceLocation, 40, 8, 8, 8, 64, 64);
            zombieHat = ImageUtils.scaleImage(zombieHat, 4.0f / scale * 47.0f / 35.0f);
            zombie = ImageUtils.addImages(ImageUtils.addImages(new BufferedImage(zombieHat.getWidth(), zombieHat.getHeight() + 8, 6), zombie, (float)(zombieHat.getWidth() - zombie.getWidth()) / 2.0f, (float)(zombieHat.getHeight() - zombie.getHeight()) / 2.0f, zombieHat.getWidth(), zombieHat.getHeight() + 8), zombieHat, 0.0f, 0.0f, zombieHat.getWidth(), zombieHat.getHeight() + 8);
            zombieHat.flush();
            zombie = ImageUtils.fillOutline(ImageUtils.pad(zombie), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + "head", zombie);
            BufferedImage skeleton = ImageUtils.loadImage(EnumMobs.SKELETON.resourceLocation, 8, 8, 8, 8, 64, 32);
            scale = (float)skeleton.getWidth() / 8.0f;
            skeleton = ImageUtils.scaleImage(skeleton, 4.0f / scale * 47.0f / 38.0f);
            skeleton = ImageUtils.addImages(new BufferedImage(skeleton.getWidth(), skeleton.getHeight() + 8, 6), skeleton, 0.0f, 0.0f, skeleton.getWidth(), skeleton.getHeight() + 8);
            skeleton = ImageUtils.fillOutline(ImageUtils.pad(skeleton), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + "head", skeleton);
            BufferedImage witherSkeleton = ImageUtils.loadImage(EnumMobs.SKELETONWITHER.resourceLocation, 8, 8, 8, 8, 64, 32);
            scale = (float)witherSkeleton.getWidth() / 8.0f;
            witherSkeleton = ImageUtils.scaleImage(witherSkeleton, 4.0f / scale * 47.0f / 38.0f);
            witherSkeleton = ImageUtils.addImages(new BufferedImage(witherSkeleton.getWidth(), witherSkeleton.getHeight() + 8, 6), witherSkeleton, 0.0f, 0.0f, witherSkeleton.getWidth(), witherSkeleton.getHeight() + 8);
            witherSkeleton = ImageUtils.fillOutline(ImageUtils.pad(witherSkeleton), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + "head", witherSkeleton);
            BufferedImage creeper = ImageUtils.addImages(ImageUtils.blankImage(EnumMobs.CREEPER.resourceLocation, 8, 10), ImageUtils.loadImage(EnumMobs.CREEPER.resourceLocation, 8, 8, 8, 8), 0.0f, 0.0f, 8, 10);
            scale = (float)creeper.getWidth() / EnumMobs.CREEPER.expectedWidth;
            creeper = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(creeper, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 37.6f, 37.6f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + "head", creeper);
            BufferedImage dragon = this.createImageFromTypeAndResourceLocations(EnumMobs.ENDERDRAGON, EnumMobs.ENDERDRAGON.resourceLocation, null, null);
            scale = (float)dragon.getWidth() / EnumMobs.ENDERDRAGON.expectedWidth;
            dragon = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(dragon, 4.0f / scale)), this.options.outlines, true, 32.0f, 32.0f, 2);
            this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + "head", dragon);
            BufferedImage sheepFur = ImageUtils.loadImage(new ResourceLocation("textures/entity/sheep/sheep_fur.png"), 6, 6, 6, 6);
            scale = (float)sheepFur.getWidth() / 6.0f;
            sheepFur = ImageUtils.scaleImage(sheepFur, 4.0f / scale * 1.0625f);
            int chop = (int)Math.max(1.0f, 2.0f);
            sheepFur = ImageUtils.eraseArea(sheepFur, chop, chop, sheepFur.getWidth() - chop * 2, sheepFur.getHeight() - chop * 2, sheepFur.getWidth(), sheepFur.getHeight());
            sheepFur = ImageUtils.fillOutline(ImageUtils.pad(sheepFur), this.options.outlines, true, 27.5f, 27.5f, (int)Math.max(1.0f, 2.0f));
            this.textureAtlas.registerIconForBufferedImage("sheepfur", sheepFur);
            BufferedImage crown = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/crown.png"), 0, 0, 16, 16, 16, 16);
            crown = ImageUtils.fillOutline(ImageUtils.scaleImage(crown, 2.0f), this.options.outlines, true, 32.0f, 32.0f, 2);
            this.textureAtlas.registerIconForBufferedImage("crown", crown);
            BufferedImage glow = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/glow.png"), 0, 0, 16, 16, 16, 16);
            glow = ImageUtils.fillOutline(glow, this.options.outlines, true, 32.0f, 32.0f, 2);
            this.textureAtlas.registerIconForBufferedImage("glow", glow);
            ResourceLocation fontResourceLocation = new ResourceLocation("textures/font/ascii.png");
            BufferedImage fontImage = ImageUtils.loadImage(fontResourceLocation, 0, 0, 128, 128, 128, 128);
            if (fontImage.getWidth() > 512 || fontImage.getHeight() > 512) {
                int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
                float scaleBy = 512.0f / (float)maxDim;
                fontImage = ImageUtils.scaleImage(fontImage, scaleBy);
            }
            fontImage = ImageUtils.addImages(new BufferedImage(fontImage.getWidth() + 2, fontImage.getHeight() + 2, fontImage.getType()), fontImage, 1.0f, 1.0f, fontImage.getWidth() + 2, fontImage.getHeight() + 2);
            Sprite fontSprite = this.textureAtlas.registerIconForBufferedImage(fontResourceLocation.toString(), fontImage);
            this.fontRenderer.setFontSprite(fontSprite);
            this.fontRenderer.setFontRef(this.textureAtlas.func_110552_b());
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary, Entity entity) {
        BufferedImage mobImage = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
        BufferedImage mobImageSecondary = null;
        if (resourceLocationSecondary != null) {
            mobImageSecondary = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
        }
        try {
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary, Entity entity) {
        BufferedImage image = null;
        switch (type) {
            case GENERICHOSTILE: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/hostile.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICNEUTRAL: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/neutral.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICTAME: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/tame.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0.0f, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0.0f, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3.0f, 8, 12);
                break;
            }
            case BEE: {
                image = ImageUtils.loadImage(mobImage, 10, 10, 7, 7);
                break;
            }
            case BLAZE: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case CAVESPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2.0f, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4.0f, 6, 6);
                break;
            }
            case COD: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 5, 32, 32), ImageUtils.loadImage(mobImage, 15, 3, 1, 3, 32, 32), 1.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 16, 3, 3, 4, 32, 32), 2.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 9, 7, 7, 4, 32, 32), 5.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 7, 4, 4, 32, 32), 12.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 0, 6, 1, 32, 32), 4.0f, 0.0f, 16, 5);
                break;
            }
            case COW: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 1.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 0.0f, 0.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 9.0f, 0.0f, 10, 10);
                break;
            }
            case CREEPER: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case DOLPHIN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 0, 6, 6, 7), 0.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 0, 17, 4, 2), 6.0f, 6.0f, 10, 10);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16.0f, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0.0f, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0.0f, 16, 16);
                break;
            }
            case ENDERMAN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 8, 24, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ENDERMITE: {
                image = ImageUtils.loadImage(mobImage, 2, 2, 4, 3);
                break;
            }
            case GHAST: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GUARDIAN: {
                image = ImageUtils.scaleImage(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12), 0.5f);
                break;
            }
            case GUARDIANELDER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 64, 64), ImageUtils.loadImage(mobImage, 56, 38, 2, 16, 64, 64), 1.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 42, 7, 12, 64, 64), 3.0f, 12.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 7, 5, 64, 64), 3.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 30, 5, 5, 64, 64), 10.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 19, 17, 1, 3, 64, 64), 3.0f, 4.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 64, 64), 3.0f, 0.0f, 16, 24);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8.0f, 8, 12);
                break;
            }
            case LLAMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case LLAMATRADER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3.0f, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15.0f, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                image = ImageUtils.addImages(image, mushroomImage, 12.0f, 0.0f, 40, 40);
                break;
            }
            case PARROT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8, 32, 32), ImageUtils.loadImage(mobImage, 2, 22, 3, 5, 32, 32), 1.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 10, 4, 4, 1, 32, 32), 2.0f, 4.0f, 8, 8), ImageUtils.loadImage(mobImage, 2, 4, 2, 3, 32, 32), 2.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 11, 8, 1, 2, 32, 32), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 16, 8, 1, 2, 32, 32), 5.0f, 5.0f, 8, 8);
                break;
            }
            case PHANTOM: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 5, 5, 7, 3, 64, 64), ImageUtils.loadImage(mobImageSecondary, 5, 5, 7, 3, 64, 64), 0.0f, 0.0f, 7, 3);
                break;
            }
            case PIG: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 16, 17, 6, 3), 1.0f, 4.0f, 8, 8);
                break;
            }
            case POLARBEAR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 9, 8, 128, 64), ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64), 0.0f, 0.0f, 9, 8), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64)), 7.0f, 0.0f, 9, 8), ImageUtils.loadImage(mobImage, 7, 7, 7, 7, 128, 64), 1.0f, 1.0f, 9, 8), ImageUtils.loadImage(mobImage, 3, 47, 5, 3, 128, 64), 2.0f, 5.0f, 9, 8);
                break;
            }
            case PUFFERFISH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 3, 3, 32, 32), ImageUtils.loadImage(mobImage, 3, 30, 3, 2, 32, 32), 0.0f, 1.0f, 3, 3), ImageUtils.loadImage(mobImage, 3, 29, 1, 1, 32, 32), 0.0f, 0.0f, 3, 3), ImageUtils.loadImage(mobImage, 5, 29, 1, 1, 32, 32), 2.0f, 0.0f, 3, 3);
                break;
            }
            case PUFFERFISHHALF: {
                image = ImageUtils.loadImage(mobImage, 17, 27, 5, 5, 32, 32);
                break;
            }
            case PUFFERFISHFULL: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 32, 32);
                break;
            }
            case RABBIT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 10), ImageUtils.loadImage(mobImage, 37, 5, 5, 4), 0.0f, 5.0f, 5, 10), ImageUtils.loadImage(mobImage, 33, 10, 1, 1), 2.0f, 7.5f, 5, 10), ImageUtils.loadImage(mobImage, 53, 1, 2, 5), 0.0f, 0.0f, 5, 10), ImageUtils.loadImage(mobImage, 59, 1, 2, 5), 3.0f, 0.0f, 5, 10);
                break;
            }
            case SALMON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 26, 7, 32, 32), ImageUtils.loadImage(mobImage, 27, 3, 3, 4, 32, 32), 1.0f, 2.5f, 26, 7), ImageUtils.loadImage(mobImage, 11, 8, 8, 5, 32, 32), 4.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 11, 21, 8, 5, 32, 32), 12.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 26, 16, 6, 5, 32, 32), 20.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 0, 0, 2, 2, 32, 32), 10.0f, 0.0f, 26, 7), ImageUtils.loadImage(mobImage, 5, 6, 3, 2, 32, 32), 12.0f, 0.0f, 26, 7);
                break;
            }
            case SHEEP: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 6, 6);
                break;
            }
            case SHULKER: {
                image = ImageUtils.loadImage(mobImage, 6, 58, 6, 6);
                break;
            }
            case SILVERFISH: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 22, 20, 6, 6), ImageUtils.loadImage(mobImage, 2, 2, 3, 2), 2.0f, 2.0f, 6, 6);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SNOWGOLEM: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case SPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case TROPICALFISHA: {
                float[] primaryColorsA = new float[]{0.9765f, 0.502f, 0.1137f};
                float[] secondaryColorsA = new float[]{0.9765f, 1.0f, 0.9961f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    primaryColorsA = fish.func_204219_dC();
                    secondaryColorsA = fish.func_204222_dD();
                }
                BufferedImage baseA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 6, 32, 32), ImageUtils.loadImage(mobImage, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImage, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImage, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), primaryColorsA[0], primaryColorsA[1], primaryColorsA[2]);
                BufferedImage patternA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 10, 6, 32, 32), ImageUtils.loadImage(mobImageSecondary, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), secondaryColorsA[0], secondaryColorsA[1], secondaryColorsA[2]);
                image = ImageUtils.addImages(baseA, patternA, 0.0f, 0.0f, 10, 6);
                baseA.flush();
                patternA.flush();
                break;
            }
            case TROPICALFISHB: {
                float[] primaryColorsB = new float[]{0.5373f, 0.1961f, 0.7216f};
                float[] secondaryColorsB = new float[]{0.9961f, 0.8471f, 0.2392f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    float[] primaryColorsA = fish.func_204219_dC();
                    float[] fArray = fish.func_204222_dD();
                }
                BufferedImage baseB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 12, 12, 32, 32), ImageUtils.loadImage(mobImage, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), primaryColorsB[0], primaryColorsB[1], primaryColorsB[2]);
                BufferedImage patternB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 12, 12, 32, 32), ImageUtils.loadImage(mobImageSecondary, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), secondaryColorsB[0], secondaryColorsB[1], secondaryColorsB[2]);
                image = ImageUtils.addImages(baseB, patternB, 0.0f, 0.0f, 12, 12);
                baseB.flush();
                patternB.flush();
                break;
            }
            case TURTLE: {
                image = ImageUtils.loadImage(mobImage, 3, 6, 6, 5, 128, 64);
                break;
            }
            case WITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            default: {
                image = null;
            }
        }
        mobImage.flush();
        if (mobImageSecondary != null) {
            mobImageSecondary.flush();
        }
        return image;
    }

    @Override
    public void OnTickInGame(Minecraft mc, LayoutVariables layoutVariables) {
        if (!(this.options.radarAllowed.booleanValue() || this.options.radarMobsAllowed.booleanValue() || this.options.radarPlayersAllowed.booleanValue())) {
            return;
        }
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.options.isChanged()) {
            this.timer = 500;
            if (this.options.outlines != this.lastOutlines) {
                this.lastOutlines = this.options.outlines;
                this.loadTexturePackIcons();
            }
        }
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled) {
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.func_78256_a(paramStr);
    }

    private void write(String paramStr, float x, float y, int color) {
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
        this.fontRenderer.drawStringWithShadow(paramStr, x, y, color);
    }

    private boolean isEntityShown(Entity entity) {
        return entity != null && !entity.func_98034_c((PlayerEntity)this.game.field_71439_g) && (this.options.showHostiles && (this.options.radarAllowed != false || this.options.radarMobsAllowed != false) && this.isHostile(entity) || this.options.showPlayers && (this.options.radarAllowed != false || this.options.radarPlayersAllowed != false) && this.isPlayer(entity) || this.options.showNeutrals && this.options.radarMobsAllowed != false && this.isNeutral(entity));
    }

    public void calculateMobs() {
        this.contacts.clear();
        Iterable entities = this.game.field_71441_e.func_217416_b();
        for (Entity entity : entities) {
            try {
                String scrubbedName;
                if (!this.isEntityShown(entity)) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.func_213303_ch().func_82615_a();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.func_213303_ch().func_82616_c();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.func_213303_ch().func_82617_b();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                if (this.hasCustomNPCs) {
                    try {
                        Object modelData;
                        LivingEntity wrappedEntity;
                        if (this.entityCustomNpcClass.isInstance(entity) && (wrappedEntity = (LivingEntity)this.getEntityMethod.invoke(modelData = this.modelDataField.get(entity), entity)) != null) {
                            entity = wrappedEntity;
                        }
                    }
                    catch (Exception modelData) {
                        // empty catch block
                    }
                }
                Contact contact = new Contact(entity, this.getContactTypeStrict(entity));
                String unscrubbedName = TextUtils.getFormattedText(contact.entity.func_145748_c_());
                contact.setName(unscrubbedName);
                if (contact.entity.func_184187_bx() != null && this.isEntityShown(contact.entity.func_184187_bx())) {
                    contact.yFudge = 1;
                }
                contact.updateLocation();
                boolean enabled = false;
                if (!contact.vanillaType) {
                    String type = entity.func_200600_R().func_210760_d();
                    CustomMob customMob = CustomMobsManager.getCustomMobByType(type);
                    if (customMob == null || customMob.enabled) {
                        enabled = true;
                    }
                } else if (contact.type.enabled) {
                    enabled = true;
                }
                if (!enabled) continue;
                if (contact.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact);
                }
                if (contact.icon == null) {
                    this.tryCustomIcon(contact);
                }
                if (contact.icon == null) {
                    this.tryAutoIcon(contact);
                }
                if (contact.icon == null) {
                    this.tryFallbackType(contact);
                }
                if (contact.icon == null) {
                    this.getGenericIcon(contact);
                }
                if (contact.type == EnumMobs.HORSE) {
                    contact.setRotationFactor(45);
                }
                if ((scrubbedName = TextUtils.scrubCodes(contact.entity.func_200200_C_().getString())) != null && (scrubbedName.equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact.entity instanceof PlayerEntity) || ((PlayerEntity)contact.entity).func_175148_a(PlayerModelPart.CAPE))) {
                    contact.setRotationFactor(contact.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) {
                    this.getArmor(contact, entity);
                }
                this.contacts.add(contact);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.newMobs) {
            try {
                this.textureAtlas.stitchNew();
            }
            catch (StitcherException e) {
                System.err.println("Stitcher exception!  Resetting mobs texture atlas.");
                this.loadTexturePackIcons();
            }
        }
        this.newMobs = false;
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private void tryCustomIcon(Contact contact) {
        String ResourceLocation2 = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
        String identifierSimple = contact.vanillaType ? contact.type.id : contact.entity.getClass().getSimpleName();
        Sprite icon = this.textureAtlas.getAtlasSprite(ResourceLocation2 + "custom");
        if (icon == this.textureAtlas.getMissingImage()) {
            boolean isHostile = this.isHostile(contact.entity);
            CustomMobsManager.add(contact.entity.func_200600_R().func_210760_d(), isHostile, !isHostile);
            BufferedImage mobSkin = this.getCustomMobImage(ResourceLocation2, identifierSimple);
            if (mobSkin != null) {
                icon = this.textureAtlas.registerIconForBufferedImage(ResourceLocation2 + "custom", mobSkin);
                this.newMobs = true;
                contact.icon = icon;
                contact.custom = true;
            } else {
                this.textureAtlas.registerFailedIcon(ResourceLocation2 + "custom");
            }
        } else if (icon != this.textureAtlas.getFailedImage()) {
            contact.custom = true;
            contact.icon = icon;
        }
    }

    private BufferedImage getCustomMobImage(String ResourceLocation2, String identifierSimple) {
        BufferedImage mobSkin = null;
        try {
            int intendedSize = 8;
            String fullPath = ("textures/icons/" + ResourceLocation2 + ".png").toLowerCase();
            InputStream is = null;
            try {
                is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
            }
            catch (IOException e) {
                is = null;
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + ".png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + ResourceLocation2 + "8.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "8.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                intendedSize = 16;
                fullPath = ("textures/icons/" + ResourceLocation2 + "16.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "16.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                intendedSize = 32;
                fullPath = ("textures/icons/" + ResourceLocation2 + "32.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "32.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is != null) {
                mobSkin = ImageIO.read(is);
                is.close();
                mobSkin = ImageUtils.validateImage(mobSkin);
                float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                mobSkin = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 4.0f / scale)), this.options.outlines, 2);
            }
        }
        catch (Exception e) {
            mobSkin = null;
        }
        return mobSkin;
    }

    private void tryAutoIcon(Contact contact) {
        block33: {
            EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
            ResourceLocation resourceLocation = render.func_110775_a(contact.entity);
            resourceLocation = this.getRandomizedResourceLocationForEntity(resourceLocation, contact.entity);
            ResourceLocation resourceLocationSecondary = null;
            ResourceLocation resourceLocationTertiary = null;
            ResourceLocation resourceLocationQuaternary = null;
            String color = "";
            if (contact.type.secondaryResourceLocation != null) {
                if (contact.type == EnumMobs.MOOSHROOM) {
                    resourceLocationSecondary = !((MooshroomEntity)contact.entity).func_70631_g_() ? EnumMobs.MOOSHROOM.secondaryResourceLocation : null;
                } else if (contact.type == EnumMobs.TROPICALFISHA || contact.type == EnumMobs.TROPICALFISHB) {
                    TropicalFishEntity fish = (TropicalFishEntity)contact.entity;
                    resourceLocationSecondary = fish.func_204220_dF();
                    color = fish.func_204219_dC() + " " + fish.func_204222_dD();
                } else if (contact.type == EnumMobs.HORSE && contact.entity instanceof HorseEntity) {
                    resourceLocationSecondary = TEXTURES.get(((HorseEntity)contact.entity).func_234240_eM_());
                    ItemStack itemStack = ((HorseEntity)contact.entity).func_213803_dV();
                    if (this.options.showHelmetsMobs && itemStack.func_77973_b() instanceof HorseArmorItem) {
                        HorseArmorItem horseArmorItem = (HorseArmorItem)itemStack.func_77973_b();
                        resourceLocationTertiary = horseArmorItem.func_219976_d();
                        if (horseArmorItem instanceof DyeableHorseArmorItem) {
                            contact.armorColor = ((DyeableHorseArmorItem)horseArmorItem).func_200886_f(itemStack);
                        }
                    }
                } else if (contact.type == EnumMobs.VILLAGER || contact.type == EnumMobs.ZOMBIEVILLAGER) {
                    boolean showBiomeHat;
                    String zombie = contact.type == EnumMobs.ZOMBIEVILLAGER ? "zombie_" : "";
                    VillagerData villagerData = ((IVillagerDataHolder)contact.entity).func_213700_eh();
                    VillagerType villagerType = villagerData.func_221129_a();
                    VillagerProfession villagerProfession = villagerData.func_221130_b();
                    resourceLocationSecondary = Registry.field_218369_K.func_177774_c((Object)villagerType);
                    resourceLocationSecondary = new ResourceLocation(resourceLocationSecondary.func_110624_b(), "textures/entity/" + zombie + "villager/type/" + resourceLocationSecondary.func_110623_a() + ".png");
                    if (villagerProfession != VillagerProfession.field_221151_a && !((LivingEntity)contact.entity).func_70631_g_()) {
                        resourceLocationTertiary = Registry.field_218370_L.func_177774_c((Object)villagerProfession);
                        resourceLocationTertiary = new ResourceLocation(resourceLocationTertiary.func_110624_b(), "textures/entity/" + zombie + "villager/profession/" + resourceLocationTertiary.func_110623_a() + ".png");
                        if (villagerProfession != VillagerProfession.field_221162_l) {
                            resourceLocationQuaternary = (ResourceLocation)LEVEL_TO_ID.get(MathHelper.func_76125_a((int)villagerData.func_221132_c(), (int)1, (int)LEVEL_TO_ID.size()));
                            resourceLocationQuaternary = new ResourceLocation(resourceLocationQuaternary.func_110624_b(), "textures/entity/" + zombie + "villager/profession_level/" + resourceLocationQuaternary.func_110623_a() + ".png");
                        }
                    }
                    VillagerMetadataSection.HatType biomeHatType = this.getHatType(resourceLocationSecondary);
                    VillagerMetadataSection.HatType professionHatType = this.getHatType(resourceLocationTertiary);
                    boolean bl = showBiomeHat = professionHatType == VillagerMetadataSection.HatType.NONE || professionHatType == VillagerMetadataSection.HatType.PARTIAL && biomeHatType != VillagerMetadataSection.HatType.FULL;
                    if (!showBiomeHat) {
                        resourceLocationSecondary = null;
                    }
                } else {
                    resourceLocationSecondary = contact.type.secondaryResourceLocation;
                }
                if (resourceLocationSecondary != null) {
                    resourceLocationSecondary = this.getRandomizedResourceLocationForEntity(resourceLocationSecondary, (Entity)((LivingEntity)contact.entity));
                }
                if (resourceLocationTertiary != null) {
                    resourceLocationTertiary = this.getRandomizedResourceLocationForEntity(resourceLocationTertiary, (Entity)((LivingEntity)contact.entity));
                }
                if (resourceLocationQuaternary != null) {
                    resourceLocationQuaternary = this.getRandomizedResourceLocationForEntity(resourceLocationQuaternary, (Entity)((LivingEntity)contact.entity));
                }
            }
            String entityName = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
            String resourceLocationString = (resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
            resourceLocationString = resourceLocationString + (resourceLocationTertiary != null ? resourceLocationTertiary.toString() : "") + (resourceLocationQuaternary != null ? resourceLocationQuaternary.toString() : "");
            resourceLocationString = resourceLocationString + (contact.armorColor != -1 ? Integer.valueOf(contact.armorColor) : "");
            String name = entityName + color + resourceLocationString;
            Sprite icon = this.textureAtlas.getAtlasSprite(name);
            if (icon == this.textureAtlas.getMissingImage()) {
                Integer n;
                Integer checkCount = this.contactsSkinGetTries.get(name);
                if (checkCount == null) {
                    checkCount = 0;
                }
                BufferedImage mobImage = null;
                if (contact.type == EnumMobs.HORSE) {
                    BufferedImage base = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
                    if (resourceLocationSecondary != null) {
                        BufferedImage pattern = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
                        pattern = ImageUtils.scaleImage(pattern, (float)base.getWidth() / (float)pattern.getWidth(), (float)base.getHeight() / (float)pattern.getHeight());
                        base = ImageUtils.addImages(base, pattern, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        pattern.flush();
                    }
                    if (resourceLocationTertiary != null) {
                        BufferedImage armor = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationTertiary);
                        armor = ImageUtils.scaleImage(armor, (float)base.getWidth() / (float)armor.getWidth(), (float)base.getHeight() / (float)armor.getHeight());
                        armor = ImageUtils.colorify(armor, contact.armorColor);
                        base = ImageUtils.addImages(base, armor, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        armor.flush();
                    }
                    mobImage = this.createImageFromTypeAndImages(contact.type, base, null, contact.entity);
                    base.flush();
                } else if ((double)contact.type.expectedWidth > 0.5) {
                    mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, resourceLocationSecondary, contact.entity);
                }
                mobImage = mobImage != null ? this.trimAndOutlineImage(contact, mobImage, false, true) : this.createAutoIconImageFromResourceLocations(contact, (EntityRenderer<? extends Entity>)render, resourceLocation, resourceLocationSecondary, resourceLocationTertiary, resourceLocationQuaternary);
                if (mobImage != null) {
                    try {
                        contact.icon = icon = this.textureAtlas.registerIconForBufferedImage(name, mobImage);
                        this.newMobs = true;
                        this.contactsSkinGetTries.remove(name);
                    }
                    catch (Exception e) {
                        n = checkCount;
                        Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                        if (checkCount > 4) {
                            this.textureAtlas.registerFailedIcon(name);
                            this.contactsSkinGetTries.remove(name);
                            break block33;
                        }
                        this.contactsSkinGetTries.put(name, checkCount);
                    }
                } else {
                    Integer n3 = checkCount;
                    n = checkCount = Integer.valueOf(checkCount + 1);
                    if (checkCount > 4) {
                        this.textureAtlas.registerFailedIcon(name);
                        this.contactsSkinGetTries.remove(name);
                    } else {
                        this.contactsSkinGetTries.put(name, checkCount);
                    }
                }
            } else if (icon != this.textureAtlas.getFailedImage()) {
                contact.icon = icon;
            }
        }
    }

    public VillagerMetadataSection.HatType getHatType(ResourceLocation resourceLocation) {
        VillagerMetadataSection.HatType hatType = VillagerMetadataSection.HatType.NONE;
        if (resourceLocation != null) {
            try {
                IResource resource = this.game.func_195551_G().func_199002_a(resourceLocation);
                if (resource != null) {
                    VillagerMetadataSection villagerResourceMetadata = (VillagerMetadataSection)resource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (villagerResourceMetadata != null) {
                        hatType = villagerResourceMetadata.func_217826_a();
                    }
                    resource.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hatType;
    }

    private BufferedImage createAutoIconImageFromResourceLocations(Contact contact, EntityRenderer<? extends Entity> render, ResourceLocation ... resourceLocations) {
        BufferedImage headImage = null;
        EntityModel model = null;
        if (render instanceof LivingRenderer || render == null) {
            try {
                model = ((LivingRenderer)render).func_217764_d();
                if (render instanceof TropicalFishRenderer) {
                    Object fishModel = null;
                    int size = ((TropicalFishEntity)contact.entity).func_204217_dE();
                    fishModel = size == 0 ? ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishAModel.class) : ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishBModel.class);
                    if (fishModel != null) {
                        model = (EntityModel)fishModel;
                    }
                }
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer.class);
                ArrayList<Field> submodelArrays = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer[].class);
                ModelRenderer[] headBits = null;
                ArrayList<ModelPartWithResourceLocation> headPartsWithResourceLocationList = new ArrayList<ModelPartWithResourceLocation>();
                Properties properties = new Properties();
                String fullName = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
                String simpleName = contact.vanillaType ? contact.type.id : contact.entity.getClass().getSimpleName();
                String fullPath = ("textures/icons/" + fullName + ".properties").toLowerCase();
                InputStream is = null;
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is == null) {
                    fullPath = ("textures/icons/" + simpleName + ".properties").toLowerCase();
                    try {
                        is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
                if (is != null) {
                    String name;
                    properties.load(is);
                    is.close();
                    String subModelNames = properties.getProperty("models", "").toLowerCase();
                    String[] submodelNamesArray = subModelNames.split(",");
                    Iterator<Field> subModelNamesList = Arrays.asList(submodelNamesArray);
                    HashSet<String> subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll((Collection<String>)((Object)subModelNamesList));
                    ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                    for (Field submodelArray : submodelArrays) {
                        ModelRenderer[] submodelArrayValue;
                        name = submodelArray.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null) continue;
                        for (int t = 0; t < submodelArrayValue.length; ++t) {
                            headPartsArrayList.add(submodelArrayValue[t]);
                        }
                    }
                    for (Field submodel : submodels) {
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                        headPartsArrayList.add((ModelRenderer)submodel.get(model));
                    }
                    if (headPartsArrayList.size() > 0) {
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                if (headBits == null) {
                    if (model instanceof PlayerModel) {
                        boolean showHat = true;
                        if (contact.entity instanceof PlayerEntity) {
                            PlayerEntity player = (PlayerEntity)contact.entity;
                            showHat = player.func_175148_a(PlayerModelPart.HAT);
                        }
                        headBits = showHat ? new ModelRenderer[]{((PlayerModel)model).field_78116_c, ((PlayerModel)model).field_178720_f} : new ModelRenderer[]{((PlayerModel)model).field_78116_c};
                    } else if (contact.type == EnumMobs.STRAY) {
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((SkeletonModel)model).field_78116_c, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((SkeletonModel)model).field_178720_f, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.strayOverlayModel.field_78116_c, resourceLocations[1]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.strayOverlayModel.field_178720_f, resourceLocations[1]));
                    } else if (contact.type == EnumMobs.DROWNED) {
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((DrownedModel)model).field_78116_c, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(((DrownedModel)model).field_178720_f, resourceLocations[0]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.drownedOverlayModel.field_78116_c, resourceLocations[1]));
                        headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(this.drownedOverlayModel.field_178720_f, resourceLocations[1]));
                    } else if (model instanceof BatModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class)};
                    } else if (model instanceof BeeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 9)};
                    } else if (model instanceof BipedModel) {
                        headBits = new ModelRenderer[]{((BipedModel)model).field_78116_c, ((BipedModel)model).field_178720_f};
                    } else if (model instanceof BlazeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BlazeModel.class, ModelRenderer.class)};
                    } else if (model instanceof ChickenModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ChickenModel.class, ModelRenderer.class)};
                    } else if (model instanceof CowModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof CreeperModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, CreeperModel.class, ModelRenderer.class)};
                    } else if (model instanceof DolphinModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, DolphinModel.class, ModelRenderer.class)};
                    } else if (model instanceof EnderDragonRenderer.EnderDragonModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, EnderDragonRenderer.EnderDragonModel.class, ModelRenderer.class)};
                    } else if (model instanceof GhastModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((GhastModel)model).func_225601_a_().iterator().next()};
                    } else if (model instanceof GuardianModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 1)};
                    } else if (model instanceof HorseModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, HorseModel.class, ModelRenderer.class)};
                    } else if (model instanceof IllagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IllagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof IronGolemModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IronGolemModel.class, ModelRenderer.class)};
                    } else if (model instanceof MagmaCubeModel) {
                        headBits = (ModelRenderer[])ReflectionUtils.getPrivateFieldValueByType(model, MagmaCubeModel.class, ModelRenderer[].class);
                    } else if (model instanceof OcelotModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, OcelotModel.class, ModelRenderer.class, 6)};
                    } else if (model instanceof PhantomModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, PhantomModel.class, ModelRenderer.class)};
                    } else if (model instanceof PigModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof PolarBearModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof RabbitModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 7), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 9), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 10)};
                    } else if (model instanceof RavagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RavagerModel.class, ModelRenderer.class, 7)};
                    } else if (model instanceof ShulkerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ShulkerModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SilverfishModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[0], (ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[1]};
                    } else if (model instanceof SlimeModel) {
                        SlimeModel modelOuter = new SlimeModel(0);
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 1), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 2), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 3), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(modelOuter, SlimeModel.class, ModelRenderer.class, 0)};
                    } else if (model instanceof SnowManModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SnowManModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SpiderModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SpiderModel.class, ModelRenderer.class)};
                    } else if (model instanceof SquidModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SquidModel.class, ModelRenderer.class)};
                    } else if (model instanceof StriderModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, StriderModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof VillagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, VillagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof WolfModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, WolfModel.class, ModelRenderer.class)};
                    } else if (model instanceof QuadrupedModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else {
                        String name;
                        ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                        ArrayList purge = new ArrayList();
                        for (Field submodelArray : submodelArrays) {
                            ModelRenderer[] submodelArrayValue;
                            name = submodelArray.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                        for (Field submodel : submodels) {
                            name = submodel.getName().toLowerCase();
                            String nameS = submodel.getName();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(!nameS.equals("LeftSmallEar") & !nameS.equals("RightSmallEar") & !nameS.equals("BHead") & !nameS.equals("BSnout") & !nameS.equals("BMouth") & !nameS.equals("BMouthOpen") & !nameS.equals("BLEar") & !nameS.equals("BREar") & !nameS.equals("CHead") & !nameS.equals("CSnout") & !nameS.equals("CMouth") & !nameS.equals("CMouthOpen") & !nameS.equals("CLEar") & !nameS.equals("CREar")) || submodel.get(model) == null) continue;
                            headPartsArrayList.add((ModelRenderer)submodel.get(model));
                        }
                        if (headPartsArrayList.size() == 0) {
                            ModelRenderer[] submodelArrayValue;
                            if (submodels.size() > 0) {
                                if (submodels.get(0).get(model) != null) {
                                    headPartsArrayList.add((ModelRenderer)submodels.get(0).get(model));
                                }
                            } else if (submodelArrays.size() > 0 && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (ModelRenderer[])submodelArrays.get(0).get(model)).length > 0) {
                                headPartsArrayList.add(submodelArrayValue[0]);
                            }
                        }
                        for (ModelRenderer bit : headPartsArrayList) {
                            try {
                                Object childrenObj = ReflectionUtils.getPrivateFieldValueByType(bit, ModelRenderer.class, ObjectList.class, 1);
                                if (childrenObj == null) continue;
                                List children = (List)childrenObj;
                                purge.addAll(children);
                            }
                            catch (Exception childrenObj) {}
                        }
                        headPartsArrayList.removeAll(purge);
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                if (contact.entity != null && model != null && (headBits != null && headBits.length > 0 || headPartsWithResourceLocationList.size() > 0) && resourceLocations[0] != null) {
                    ModelPartWithResourceLocation[] headBitsWithLocations;
                    boolean success;
                    String scaleString = properties.getProperty("scale", "1");
                    float scale = Float.parseFloat(scaleString);
                    Direction facing = Direction.NORTH;
                    String facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = Direction.UP;
                    } else if (facingString.equals("side")) {
                        facing = Direction.EAST;
                    }
                    ResourceLocation resourceLocation = this.combineResourceLocations(resourceLocations);
                    if (headBits != null) {
                        for (int t = 0; t < headBits.length; ++t) {
                            headPartsWithResourceLocationList.add(new ModelPartWithResourceLocation(headBits[t], resourceLocation));
                        }
                    }
                    if (success = this.drawModel(scale, 1000, (LivingEntity)contact.entity, facing, model, headBitsWithLocations = headPartsWithResourceLocationList.toArray(new ModelPartWithResourceLocation[headPartsWithResourceLocationList.size()]))) {
                        headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    }
                }
            }
            catch (Exception e) {
                headImage = null;
                e.printStackTrace();
            }
        }
        if (headImage != null) {
            headImage = this.trimAndOutlineImage(contact, headImage, true, model != null && model instanceof BipedModel);
        }
        return headImage;
    }

    private ResourceLocation combineResourceLocations(ResourceLocation ... resourceLocations) {
        ResourceLocation resourceLocation = resourceLocations[0];
        if (resourceLocations.length > 1) {
            boolean hasAdditional = false;
            try {
                Image base = null;
                for (int t = 1; t < resourceLocations.length; ++t) {
                    if (resourceLocations[t] == null) continue;
                    if (!hasAdditional) {
                        base = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
                    }
                    hasAdditional = true;
                    BufferedImage overlay = ImageUtils.createBufferedImageFromResourceLocation(resourceLocations[t]);
                    float xScale = ((BufferedImage)base).getWidth() / overlay.getWidth();
                    float yScale = ((BufferedImage)base).getHeight() / overlay.getHeight();
                    if (xScale != 1.0f || yScale != 1.0f) {
                        overlay = ImageUtils.scaleImage(overlay, xScale, yScale);
                    }
                    base = ImageUtils.addImages((BufferedImage)base, overlay, 0.0f, 0.0f, ((BufferedImage)base).getWidth(), ((BufferedImage)base).getHeight());
                    overlay.flush();
                }
                if (hasAdditional) {
                    NativeImage nativeImage = GLUtils.nativeImageFromBufferedImage(base);
                    base.flush();
                    this.nativeBackedTexture.close();
                    this.nativeBackedTexture = new DynamicTexture(nativeImage);
                    GLUtils.register(this.nativeBackedTextureLocation, (Texture)this.nativeBackedTexture);
                    resourceLocation = this.nativeBackedTextureLocation;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resourceLocation;
    }

    private boolean drawModel(float scale, int captureDepth, LivingEntity livingEntity, Direction facing, EntityModel model, ModelPartWithResourceLocation[] headBits) {
        boolean failed = false;
        float size = 64.0f * scale;
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f + (float)captureDepth);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glTexEnvi(8960, 8704, 7681);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef(width / 2, height / 2, 0.0f);
        GLShim.glScalef(size, size, size);
        GLShim.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        if (facing == Direction.EAST) {
            GLShim.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (facing == Direction.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        try {
            int t;
            MatrixStack matrixStack = new MatrixStack();
            IRenderTypeBuffer.Impl immediate = this.game.func_228019_au_().func_228487_b_();
            float offsetByY = model instanceof BipedModel ? 4.0f : 0.0f;
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].modelPart.field_78797_d < minY) {
                    minY = headBits[t].modelPart.field_78797_d;
                }
                if (!(headBits[t].modelPart.field_78797_d > maxY)) continue;
                maxY = headBits[t].modelPart.field_78797_d;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            for (t = 0; t < headBits.length; ++t) {
                IVertexBuilder vertexConsumer = immediate.getBuffer(model.func_228282_a_(headBits[t].resourceLocation));
                model.func_225597_a_((Entity)livingEntity, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
                float y = headBits[t].modelPart.field_78797_d;
                headBits[t].modelPart.field_78797_d += offsetByY;
                headBits[t].modelPart.func_228308_a_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_);
                headBits[t].modelPart.field_78797_d = y;
                immediate.func_228461_a_();
            }
        }
        catch (Exception e) {
            System.out.println("Error attempting to render head bits for " + livingEntity.getClass().getSimpleName());
            e.printStackTrace();
            failed = true;
        }
        GLShim.glPopMatrix();
        GLShim.glTexEnvi(8960, 8704, 8448);
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.func_228018_at_().func_198109_k(), this.game.func_228018_at_().func_198091_l());
        return !failed;
    }

    private void tryFallbackType(Contact contact) {
        contact.type = this.getContactType(contact.entity);
        if (contact.type != EnumMobs.UNKNOWN) {
            String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
            resourceLocationString = resourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "");
            String name = "minecraft." + contact.type.id + resourceLocationString;
            Sprite icon = this.textureAtlas.getAtlasSprite(name);
            if (icon != this.textureAtlas.getMissingImage()) {
                contact.icon = icon;
            }
        }
    }

    private void getGenericIcon(Contact contact) {
        contact.type = this.getUnknownMobNeutrality(contact.entity);
        String name = "minecraft." + contact.type.id + contact.type.resourceLocation.toString();
        contact.icon = this.textureAtlas.getAtlasSprite(name);
    }

    private ResourceLocation getRandomizedResourceLocationForEntity(ResourceLocation resourceLocation, Entity entity) {
        try {
            Object randomEntitiesProperties;
            if (this.randomobsOptifine && (randomEntitiesProperties = this.mapProperties.get(resourceLocation.func_110623_a())) != null) {
                this.setEntityMethod.invoke(this.randomEntityClass.cast(this.randomEntity), entity);
                resourceLocation = (ResourceLocation)this.getEntityTextureMethod.invoke(this.randomEntitiesPropertiesClass.cast(randomEntitiesProperties), resourceLocation, this.randomEntityClass.cast(this.randomEntity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceLocation;
    }

    private BufferedImage trimAndOutlineImage(Contact contact, BufferedImage image, boolean auto, boolean centered) {
        if (auto) {
            image = centered ? ImageUtils.trimCentered(image) : ImageUtils.trim(image);
            double acceptableMax = 64.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 128.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)Math.ceil((double)maxDimension / acceptableMax);
            image = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines, 2);
            return image;
        }
        float scale = (float)image.getWidth() / contact.type.expectedWidth;
        image = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 4.0f / scale)), this.options.outlines, 2);
        return image;
    }

    private void handleMPplayer(Contact contact) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)contact.entity;
        GameProfile gameProfile = player.func_146103_bH();
        UUID uuid = gameProfile.getId();
        contact.setUUID(uuid);
        String playerName = this.scrubCodes(gameProfile.getName());
        Sprite icon = this.textureAtlas.getAtlasSprite(playerName);
        Integer checkCount = 0;
        if (icon == this.textureAtlas.getMissingImage()) {
            checkCount = this.mpContactsSkinGetTries.get(playerName);
            if (checkCount == null) {
                checkCount = 0;
            }
            if (checkCount < 5) {
                DownloadingTexture imageData = null;
                try {
                    if (player.func_110306_p() == DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au())) {
                        throw new Exception("failed to get skin: skin is default");
                    }
                    imageData = AbstractClientPlayerEntity.func_110304_a((ResourceLocation)player.func_110306_p(), (String)player.func_200200_C_().getString());
                    if (imageData == null) {
                        throw new Exception("failed to get skin: image data was null");
                    }
                    EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
                    BufferedImage skinImage = this.createAutoIconImageFromResourceLocations(contact, (EntityRenderer<? extends Entity>)render, player.func_110306_p(), null);
                    icon = this.textureAtlas.registerIconForBufferedImage(playerName, skinImage);
                    this.newMobs = true;
                    this.mpContactsSkinGetTries.remove(playerName);
                }
                catch (Exception e) {
                    icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString());
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    this.mpContactsSkinGetTries.put(playerName, checkCount);
                }
                contact.icon = icon;
            }
        } else {
            contact.icon = icon;
        }
    }

    private void getArmor(Contact contact, Entity entity) {
        Sprite icon = null;
        ItemStack stack = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.HEAD);
        Item helmet = null;
        if (stack != null && stack.func_190916_E() > 0) {
            helmet = stack.func_77973_b();
        }
        if (contact.type == EnumMobs.SHEEP) {
            SheepEntity sheepEntity = (SheepEntity)contact.entity;
            if (!sheepEntity.func_70892_o()) {
                icon = this.textureAtlas.getAtlasSprite("sheepfur");
                float[] sheepColors = SheepEntity.func_175513_a((DyeColor)sheepEntity.func_175509_cj());
                contact.setArmorColor((int)(sheepColors[0] * 255.0f) << 16 | (int)(sheepColors[1] * 255.0f) << 8 | (int)(sheepColors[2] * 255.0f));
            }
        } else if (helmet != null) {
            if (helmet == Items.field_196182_dv) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + "head");
            } else if (helmet == Items.field_196183_dw) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + "head");
            } else if (helmet == Items.field_196186_dz) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + "head");
            } else if (helmet == Items.field_196185_dy) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + "head");
            } else if (helmet == Items.field_196151_dA) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + "head");
            } else if (helmet == Items.field_196184_dx) {
                ModelPartWithResourceLocation[] headBits;
                boolean success;
                Map map;
                GameProfile gameProfile = null;
                if (stack.func_77942_o()) {
                    String name;
                    CompoundNBT nbttagcompound = stack.func_77978_p();
                    if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                        gameProfile = NBTUtil.func_152459_a((CompoundNBT)nbttagcompound.func_74775_l("SkullOwner"));
                    } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && (name = nbttagcompound.func_74779_i("SkullOwner")) != null && !name.equals("")) {
                        gameProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile((UUID)null, name));
                        nbttagcompound.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameProfile));
                    }
                }
                ResourceLocation resourceLocation = DefaultPlayerSkin.func_177335_a();
                if (gameProfile != null && (map = this.game.func_152342_ad().func_152788_a(gameProfile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    resourceLocation = this.game.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                if ((icon = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched("minecraft." + EnumMobs.PLAYER.id + resourceLocation.toString() + "head")) == this.textureAtlas.getMissingImage() && (success = this.drawModel(1.0f, 1000, (LivingEntity)contact.entity, Direction.NORTH, (EntityModel)this.playerArmorModel, headBits = new ModelPartWithResourceLocation[]{new ModelPartWithResourceLocation(this.playerArmorModel.field_78116_c, resourceLocation), new ModelPartWithResourceLocation(this.playerArmorModel.field_178720_f, resourceLocation)}))) {
                    BufferedImage headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    headImage = this.trimAndOutlineImage(new Contact((Entity)this.game.field_71439_g, EnumMobs.PLAYER), headImage, true, true);
                    icon = this.textureAtlas.registerIconForBufferedImage("minecraft." + EnumMobs.PLAYER.id + resourceLocation.toString() + "head", headImage);
                    this.newMobs = true;
                }
            } else if (helmet instanceof ArmorItem) {
                ArmorItem helmetArmor = (ArmorItem)helmet;
                int armorType = this.getArmorType(helmetArmor);
                if (armorType == UNKNOWN) {
                    boolean isPiglin = contact.type == EnumMobs.PIGLIN || contact.type == EnumMobs.PIGLINZOMBIE;
                    icon = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a() + (isPiglin ? "_piglin" : ""));
                    if (icon == this.textureAtlas.getMissingImage()) {
                        icon = this.createUnknownArmorIcons(contact, stack, helmet);
                    } else if (icon == this.textureAtlas.getFailedImage()) {
                        icon = null;
                    }
                } else {
                    icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType]);
                }
                if (helmetArmor instanceof DyeableArmorItem) {
                    contact.setArmorColor(((DyeableArmorItem)helmetArmor).func_200886_f(stack));
                }
            } else if (helmet instanceof BlockItem) {
                BufferedImage blockImage;
                Block block = ((BlockItem)helmet).func_179223_d();
                BlockState blockState = block.func_176223_P();
                int stateID = Block.func_196246_j((BlockState)blockState);
                icon = this.textureAtlas.getAtlasSprite("blockArmor " + stateID);
                if (icon == this.textureAtlas.getMissingImage() && (blockImage = this.master.getColorManager().getBlockImage(blockState, stack, entity.field_70170_p, 4.9473686f, -8.0f)) != null) {
                    int width = blockImage.getWidth();
                    int height = blockImage.getHeight();
                    blockImage = ImageUtils.eraseArea(blockImage, width / 2 - 15, height / 2 - 15, 30, 30, width, height);
                    BufferedImage blockImageFront = this.master.getColorManager().getBlockImage(blockState, stack, entity.field_70170_p, 4.9473686f, 7.25f);
                    blockImageFront = blockImageFront.getSubimage(width / 2 - 15, height / 2 - 15, 30, 30);
                    blockImage = ImageUtils.addImages(blockImage, blockImageFront, width / 2 - 15, height / 2 - 15, width, height);
                    blockImageFront.flush();
                    blockImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.trimCentered(blockImage)), this.options.outlines, true, 37.6f, 37.6f, 2);
                    icon = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID, blockImage);
                    this.newMobs = true;
                }
            }
        }
        contact.armorIcon = icon;
    }

    private Sprite createUnknownArmorIcons(Contact contact, ItemStack stack, Item helmet) {
        BufferedImage armorTexture;
        Sprite icon = null;
        boolean isPiglin = contact.type == EnumMobs.PIGLIN || contact.type == EnumMobs.PIGLINZOMBIE;
        Method m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorTexture", Entity.class, ItemStack.class, String.class, EquipmentSlotType.class, String.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getResourceLocation = m;
        ResourceLocation resourceLocation = null;
        try {
            String suffix;
            String materialName = ((ArmorItem)helmet).func_200880_d().func_200897_d();
            String domain = "minecraft";
            int sep = materialName.indexOf(58);
            if (sep != -1) {
                domain = materialName.substring(0, sep);
                materialName = materialName.substring(sep + 1);
            }
            suffix = (suffix = null) == null ? "" : "_" + suffix;
            String resourcePath = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, materialName, 1, suffix);
            if (getResourceLocation != null) {
                resourcePath = (String)getResourceLocation.invoke(null, contact.entity, stack, resourcePath, EquipmentSlotType.HEAD, null);
            }
            resourceLocation = new ResourceLocation(resourcePath);
        }
        catch (Exception materialName) {
            // empty catch block
        }
        m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorModel", LivingEntity.class, ItemStack.class, EquipmentSlotType.class, BipedModel.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getModel = m;
        BipedModel modelBiped = null;
        try {
            if (getModel != null) {
                modelBiped = (BipedModel)getModel.invoke(null, contact.entity, stack, EquipmentSlotType.HEAD, null);
            }
        }
        catch (Exception sep) {
            // empty catch block
        }
        float intendedWidth = 9.0f;
        float intendedHeight = 9.0f;
        if (modelBiped == null) {
            if (!isPiglin) {
                modelBiped = this.bipedArmorModel;
            } else {
                modelBiped = this.piglinArmorModel;
                intendedWidth = 11.5f;
            }
        }
        if (modelBiped != null && resourceLocation != null) {
            ModelPartWithResourceLocation[] headBitsWithResourceLocation = new ModelPartWithResourceLocation[]{new ModelPartWithResourceLocation(modelBiped.field_78116_c, resourceLocation), new ModelPartWithResourceLocation(modelBiped.field_178720_f, resourceLocation)};
            this.drawModel(1.0f, 2, (LivingEntity)contact.entity, Direction.NORTH, (EntityModel)modelBiped, headBitsWithResourceLocation);
            BufferedImage armorImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            armorImage = armorImage.getSubimage(200, 200, 112, 112);
            armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.trimCentered(armorImage)), this.options.outlines, true, intendedWidth * 4.0f, intendedHeight * 4.0f, 2);
            icon = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + (isPiglin ? "_piglin" : ""), armorImage);
            this.newMobs = true;
        }
        if (icon == null && resourceLocation != null && (armorTexture = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation)) != null) {
            if (!isPiglin) {
                armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                float scale = (float)armorTexture.getWidth() / 8.0f;
                BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 37.6f, 37.6f, 2);
                icon = this.textureAtlas.registerIconForBufferedImage("armor " + resourceLocation.toString(), armorImage);
            } else {
                armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                float scale = (float)armorTexture.getWidth() / 8.0f;
                BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 4.0f / scale * 47.0f / 38.0f)), this.options.outlines, true, 47.0f, 37.6f, 2);
                icon = this.textureAtlas.registerIconForBufferedImage("armor " + resourceLocation.toString() + "_piglin", armorImage);
            }
            this.newMobs = true;
        }
        if (icon == null) {
            System.out.println("can't get texture for custom armor type: " + helmet.getClass());
            this.textureAtlas.registerFailedIcon("armor " + helmet.func_77658_a() + helmet.getClass().getName());
        }
        return icon;
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    private EnumMobs getContactTypeStrict(Entity entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.equals(BatEntity.class)) {
            return EnumMobs.BAT;
        }
        if (entityClass.equals(BeeEntity.class)) {
            return EnumMobs.BEE;
        }
        if (entityClass.equals(BlazeEntity.class)) {
            return EnumMobs.BLAZE;
        }
        if (entityClass.equals(CatEntity.class)) {
            return EnumMobs.CAT;
        }
        if (entityClass.equals(CaveSpiderEntity.class)) {
            return EnumMobs.CAVESPIDER;
        }
        if (entityClass.equals(ChickenEntity.class)) {
            return EnumMobs.CHICKEN;
        }
        if (entityClass.equals(CodEntity.class)) {
            return EnumMobs.COD;
        }
        if (entityClass.equals(MooshroomEntity.class)) {
            return EnumMobs.MOOSHROOM;
        }
        if (entityClass.equals(CowEntity.class)) {
            return EnumMobs.COW;
        }
        if (entityClass.equals(CreeperEntity.class)) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof DolphinEntity) {
            return EnumMobs.DOLPHIN;
        }
        if (entity instanceof DrownedEntity) {
            return EnumMobs.DROWNED;
        }
        if (entityClass.equals(EnderDragonEntity.class)) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entityClass.equals(EndermanEntity.class)) {
            return EnumMobs.ENDERMAN;
        }
        if (entityClass.equals(EndermiteEntity.class)) {
            return EnumMobs.ENDERMITE;
        }
        if (entityClass.equals(EvokerEntity.class)) {
            return EnumMobs.EVOKER;
        }
        if (entityClass.equals(FoxEntity.class)) {
            return EnumMobs.FOX;
        }
        if (entityClass.equals(GhastEntity.class)) {
            return EnumMobs.GHAST;
        }
        if (entityClass.equals(GuardianEntity.class)) {
            return EnumMobs.GUARDIAN;
        }
        if (entityClass.equals(ElderGuardianEntity.class)) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entityClass.equals(HoglinEntity.class)) {
            return EnumMobs.HOGLIN;
        }
        if (entityClass.equals(HorseEntity.class) || entityClass.equals(DonkeyEntity.class) || entityClass.equals(MuleEntity.class) || entityClass.equals(SkeletonHorseEntity.class) || entityClass.equals(ZombieHorseEntity.class)) {
            return EnumMobs.HORSE;
        }
        if (entityClass.equals(HuskEntity.class)) {
            return EnumMobs.HUSK;
        }
        if (entityClass.equals(LlamaEntity.class)) {
            return EnumMobs.LLAMA;
        }
        if (entityClass.equals(TraderLlamaEntity.class)) {
            return EnumMobs.LLAMATRADER;
        }
        if (entityClass.equals(IronGolemEntity.class)) {
            return EnumMobs.IRONGOLEM;
        }
        if (entityClass.equals(MagmaCubeEntity.class)) {
            return EnumMobs.MAGMA;
        }
        if (entityClass.equals(OcelotEntity.class)) {
            return EnumMobs.OCELOT;
        }
        if (entityClass.equals(PandaEntity.class)) {
            return EnumMobs.PANDA;
        }
        if (entityClass.equals(ParrotEntity.class)) {
            return EnumMobs.PARROT;
        }
        if (entityClass.equals(PhantomEntity.class)) {
            return EnumMobs.PHANTOM;
        }
        if (entityClass.equals(PigEntity.class)) {
            return EnumMobs.PIG;
        }
        if (entityClass.equals(PiglinEntity.class)) {
            return EnumMobs.PIGLIN;
        }
        if (entityClass.equals(ZombifiedPiglinEntity.class)) {
            return EnumMobs.PIGLINZOMBIE;
        }
        if (entityClass.equals(PillagerEntity.class)) {
            return EnumMobs.PILLAGER;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entityClass.equals(PolarBearEntity.class)) {
            return EnumMobs.POLARBEAR;
        }
        if (entityClass.equals(PufferfishEntity.class)) {
            return EnumMobs.PUFFERFISH;
        }
        if (entityClass.equals(RabbitEntity.class)) {
            return EnumMobs.RABBIT;
        }
        if (entityClass.equals(RavagerEntity.class)) {
            return EnumMobs.RAVAGER;
        }
        if (entityClass.equals(SalmonEntity.class)) {
            return EnumMobs.SALMON;
        }
        if (entityClass.equals(SheepEntity.class)) {
            return EnumMobs.SHEEP;
        }
        if (entityClass.equals(ShulkerEntity.class)) {
            return EnumMobs.SHULKER;
        }
        if (entityClass.equals(SilverfishEntity.class)) {
            return EnumMobs.SILVERFISH;
        }
        if (entityClass.equals(SkeletonEntity.class)) {
            return EnumMobs.SKELETON;
        }
        if (entityClass.equals(WitherSkeletonEntity.class)) {
            return EnumMobs.SKELETONWITHER;
        }
        if (entityClass.equals(SlimeEntity.class)) {
            return EnumMobs.SLIME;
        }
        if (entityClass.equals(SnowGolemEntity.class)) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entityClass.equals(SpiderEntity.class)) {
            return EnumMobs.SPIDER;
        }
        if (entityClass.equals(SquidEntity.class)) {
            return EnumMobs.SQUID;
        }
        if (entityClass.equals(TropicalFishEntity.class)) {
            if (((TropicalFishEntity)entity).func_204217_dE() == 0) {
                return EnumMobs.TROPICALFISHA;
            }
            return EnumMobs.TROPICALFISHB;
        }
        if (entityClass.equals(StrayEntity.class)) {
            return EnumMobs.STRAY;
        }
        if (entityClass.equals(StriderEntity.class)) {
            return EnumMobs.STRIDER;
        }
        if (entityClass.equals(TurtleEntity.class)) {
            return EnumMobs.TURTLE;
        }
        if (entityClass.equals(VexEntity.class)) {
            return EnumMobs.VEX;
        }
        if (entityClass.equals(VillagerEntity.class)) {
            return EnumMobs.VILLAGER;
        }
        if (entityClass.equals(VindicatorEntity.class)) {
            return EnumMobs.VINDICATOR;
        }
        if (entityClass.equals(WanderingTraderEntity.class)) {
            return EnumMobs.WANDERINGTRADER;
        }
        if (entityClass.equals(WitchEntity.class)) {
            return EnumMobs.WITCH;
        }
        if (entityClass.equals(WitherEntity.class)) {
            return EnumMobs.WITHER;
        }
        if (entityClass.equals(WolfEntity.class)) {
            return EnumMobs.WOLF;
        }
        if (entityClass.equals(ZoglinEntity.class)) {
            return EnumMobs.ZOGLIN;
        }
        if (entityClass.equals(ZombieEntity.class)) {
            return EnumMobs.ZOMBIE;
        }
        if (entityClass.equals(ZombieVillagerEntity.class)) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getContactType(Entity entity) {
        if (entity instanceof BatEntity) {
            return EnumMobs.BAT;
        }
        if (entity instanceof BeeEntity) {
            return EnumMobs.BEE;
        }
        if (entity instanceof BlazeEntity) {
            return EnumMobs.BLAZE;
        }
        if (entity instanceof CatEntity) {
            return EnumMobs.CAT;
        }
        if (entity instanceof CaveSpiderEntity) {
            return EnumMobs.CAVESPIDER;
        }
        if (entity instanceof ChickenEntity) {
            return EnumMobs.CHICKEN;
        }
        if (entity instanceof MooshroomEntity) {
            return EnumMobs.MOOSHROOM;
        }
        if (entity instanceof CowEntity) {
            return EnumMobs.COW;
        }
        if (entity instanceof CreeperEntity) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof DolphinEntity) {
            return EnumMobs.DOLPHIN;
        }
        if (entity instanceof EnderDragonEntity) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entity instanceof EndermanEntity) {
            return EnumMobs.ENDERMAN;
        }
        if (entity instanceof EndermiteEntity) {
            return EnumMobs.ENDERMITE;
        }
        if (entity instanceof EvokerEntity) {
            return EnumMobs.EVOKER;
        }
        if (entity instanceof GhastEntity) {
            return EnumMobs.GHAST;
        }
        if (entity instanceof ElderGuardianEntity) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entity instanceof GuardianEntity) {
            return EnumMobs.GUARDIAN;
        }
        if (entity instanceof TraderLlamaEntity) {
            return EnumMobs.LLAMATRADER;
        }
        if (entity instanceof LlamaEntity) {
            return EnumMobs.LLAMA;
        }
        if (entity instanceof AbstractHorseEntity) {
            return EnumMobs.HORSE;
        }
        if (entity instanceof IronGolemEntity) {
            return EnumMobs.IRONGOLEM;
        }
        if (entity instanceof MagmaCubeEntity) {
            return EnumMobs.MAGMA;
        }
        if (entity instanceof OcelotEntity) {
            return EnumMobs.OCELOT;
        }
        if (entity instanceof ParrotEntity) {
            return EnumMobs.PARROT;
        }
        if (entity instanceof PhantomEntity) {
            return EnumMobs.PHANTOM;
        }
        if (entity instanceof PigEntity) {
            return EnumMobs.PIG;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entity instanceof PolarBearEntity) {
            return EnumMobs.POLARBEAR;
        }
        if (entity instanceof PufferfishEntity) {
            return EnumMobs.PUFFERFISH;
        }
        if (entity instanceof RabbitEntity) {
            return EnumMobs.RABBIT;
        }
        if (entity instanceof SheepEntity) {
            return EnumMobs.SHEEP;
        }
        if (entity instanceof ShulkerEntity) {
            return EnumMobs.SHULKER;
        }
        if (entity instanceof SilverfishEntity) {
            return EnumMobs.SILVERFISH;
        }
        if (entity instanceof AbstractSkeletonEntity) {
            return EnumMobs.SKELETON;
        }
        if (entity instanceof SlimeEntity) {
            return EnumMobs.SLIME;
        }
        if (entity instanceof SnowGolemEntity) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entity instanceof SpiderEntity) {
            return EnumMobs.SPIDER;
        }
        if (entity instanceof SquidEntity) {
            return EnumMobs.SQUID;
        }
        if (entity instanceof VexEntity) {
            return EnumMobs.VEX;
        }
        if (entity instanceof VillagerEntity) {
            return EnumMobs.VILLAGER;
        }
        if (entity instanceof VindicatorEntity) {
            return EnumMobs.VINDICATOR;
        }
        if (entity instanceof WitchEntity) {
            return EnumMobs.WITCH;
        }
        if (entity instanceof WitherEntity) {
            return EnumMobs.WITHER;
        }
        if (entity instanceof WolfEntity) {
            return EnumMobs.WOLF;
        }
        if (entity instanceof ZombieVillagerEntity) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        if (entity instanceof ZombieEntity) {
            return EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getUnknownMobNeutrality(Entity entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() && (this.game.func_71387_A() || ((TameableEntity)entity).func_70902_q().equals((Object)this.game.field_71439_g))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private int getArmorType(ArmorItem helmet) {
        if (helmet.func_77658_a().equals("item.minecraft.leather_helmet")) {
            return 0;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp(this.textureAtlas.func_110552_b());
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 771);
        for (Contact contact : this.contacts) {
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            boolean inRange = false;
            if (this.minimapOptions.squareMap) {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            } else {
                boolean bl = inRange = contact.distance < 31.0;
            }
            if (!inRange) continue;
            try {
                GLShim.glPushMatrix();
                if (this.options.filtering) {
                    GLShim.glTranslatef(x, y, 0.0f);
                    GLShim.glRotatef(-contact.angle, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslated(0.0, -contact.distance, 0.0);
                    GLShim.glRotatef(contact.angle + (float)contact.rotationFactor, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    wayX = Math.sin(Math.toRadians(contact.angle)) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(contact.angle)) * contact.distance;
                    if (this.options.filtering) {
                        GLShim.glTranslated(-wayX, -wayZ, 0.0);
                    } else {
                        GLShim.glTranslated((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, (double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, 0.0);
                    }
                }
                float yOffset = 0.0f;
                if (contact.entity.func_184187_bx() != null && this.isEntityShown(contact.entity.func_184187_bx())) {
                    yOffset = -4.0f;
                }
                if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING || contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE || contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING || contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                    if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING) {
                        EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = render.func_110775_a(contact.entity).func_110623_a();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                    } else if (contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                        EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = render.func_110775_a(contact.entity).func_110623_a();
                        contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                    } else if (contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING) {
                        EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = render.func_110775_a(contact.entity).func_110623_a();
                        contact.type = path.endsWith("vex_charging.png") ? EnumMobs.VEXCHARGING : EnumMobs.VEX;
                    } else if (contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                        int size = ((PufferfishEntity)contact.entity).func_203715_dA();
                        switch (size) {
                            case 0: {
                                contact.type = EnumMobs.PUFFERFISH;
                                break;
                            }
                            case 1: {
                                contact.type = EnumMobs.PUFFERFISHHALF;
                                break;
                            }
                            case 2: {
                                contact.type = EnumMobs.PUFFERFISHFULL;
                            }
                        }
                    }
                    this.tryAutoIcon(contact);
                    this.tryCustomIcon(contact);
                    if (this.newMobs) {
                        try {
                            this.textureAtlas.stitchNew();
                        }
                        catch (StitcherException e) {
                            System.err.println("Stitcher exception in render method!  Resetting mobs texture atlas.");
                            this.loadTexturePackIcons();
                        }
                        GLUtils.disp(this.textureAtlas.func_110552_b());
                    }
                    this.newMobs = false;
                }
                if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    Sprite icon = this.textureAtlas.getAtlasSprite("glow");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / 2.0f));
                    GLUtils.drawPost();
                }
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(contact.icon, x, (float)y + yOffset, (int)((float)contact.icon.getIconWidth() / 4.0f));
                GLUtils.drawPost();
                if ((this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) && contact.armorIcon != null) {
                    Sprite icon = contact.armorIcon;
                    float armorOffset = 0.0f;
                    if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                        armorOffset = -0.5f;
                    }
                    float armorScale = 1.0f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    if (contact.armorColor != -1) {
                        red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                        green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                        blue = (float)(contact.armorColor >> 0 & 0xFF) / 255.0f;
                        if (contact.type == EnumMobs.SHEEP) {
                            SheepEntity sheepEntity = (SheepEntity)contact.entity;
                            if (sheepEntity.func_145818_k_() && "jeb_".equals(sheepEntity.func_200200_C_().func_150261_e())) {
                                int semiRandom = sheepEntity.field_70173_aa / 25 + sheepEntity.func_145782_y();
                                int numDyeColors = DyeColor.values().length;
                                int colorID1 = semiRandom % numDyeColors;
                                int colorID2 = (semiRandom + 1) % numDyeColors;
                                float lerpVal = ((float)(sheepEntity.field_70173_aa % 25) + this.game.func_184121_ak()) / 25.0f;
                                float[] sheepColors1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID1));
                                float[] sheepColors2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID2));
                                red = sheepColors1[0] * (1.0f - lerpVal) + sheepColors2[0] * lerpVal;
                                green = sheepColors1[1] * (1.0f - lerpVal) + sheepColors2[1] * lerpVal;
                                blue = sheepColors1[2] * (1.0f - lerpVal) + sheepColors2[2] * lerpVal;
                            }
                            armorScale = 1.04f;
                        }
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                    }
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / 4.0f * armorScale));
                    GLUtils.drawPost();
                    if (icon == this.clothIcon) {
                        if (wayY < 0) {
                            GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
                        } else {
                            GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[2]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale);
                        GLUtils.drawPost();
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[1]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale * 40.0f / 37.0f);
                        GLUtils.drawPost();
                        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[3]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale * 40.0f / 37.0f);
                        GLUtils.drawPost();
                    }
                } else if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    Sprite icon = this.textureAtlas.getAtlasSprite("crown");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (float)icon.getIconWidth() / 4.0f);
                    GLUtils.drawPost();
                }
                if (contact.name == null || (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) && (!this.options.showMobNames || contact.type == EnumMobs.PLAYER)) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                GLShim.glScalef(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
                int m = this.chkLen(contact.name) / 2;
                this.write(contact.name, (float)x * scaleFactor - (float)m, (float)(y + 3) * scaleFactor, 0xFFFFFF);
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }

    private boolean isHostile(Entity entity) {
        if (entity instanceof ZombifiedPiglinEntity) {
            return ((ZombifiedPiglinEntity)entity).func_230292_f_((PlayerEntity)this.game.field_71439_g);
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity instanceof BeeEntity) {
            return ((BeeEntity)entity).func_233678_J__();
        }
        if (entity instanceof PolarBearEntity) {
            for (PolarBearEntity polarBear : ((PolarBearEntity)entity).field_70170_p.func_217357_a(PolarBearEntity.class, ((PolarBearEntity)entity).func_174813_aQ().func_72321_a(8.0, 4.0, 8.0))) {
                if (!polarBear.func_70631_g_()) continue;
                return true;
            }
        }
        if (entity instanceof RabbitEntity) {
            return ((RabbitEntity)entity).func_175531_cl() == 99;
        }
        if (entity instanceof WolfEntity) {
            return ((WolfEntity)entity).func_233678_J__();
        }
        return false;
    }

    private boolean isPlayer(Entity entity) {
        return entity instanceof RemoteClientPlayerEntity;
    }

    private boolean isNeutral(Entity entity) {
        if (entity instanceof LivingEntity) {
            return !(entity instanceof PlayerEntity) && !this.isHostile(entity);
        }
        return false;
    }

    private class ModelPartWithResourceLocation {
        ModelRenderer modelPart;
        ResourceLocation resourceLocation;

        public ModelPartWithResourceLocation(ModelRenderer modelPart, ResourceLocation resourceLocation) {
            this.modelPart = modelPart;
            this.resourceLocation = resourceLocation;
        }
    }
}

