/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionSliderMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPersistentMapOptions
extends GuiScreenMinimap {
    private final Screen parent;
    private static EnumOptionsMinimap[] relevantOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "Worldmap Options";
    protected String cacheSettings = "Zoom/Cache Settings";
    protected String warning = "Edit at your own risk";
    private static EnumOptionsMinimap[] relevantOptions2;

    public GuiPersistentMapOptions(Screen parent, IVoxelMap master) {
        this.parent = parent;
        this.options = master.getPersistentMapOptions();
    }

    public void func_231160_c_() {
        EnumOptionsMinimap option;
        int t;
        relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.SHOWWAYPOINTS, EnumOptionsMinimap.SHOWWAYPOINTNAMES};
        this.screenTitle = I18nUtils.getString("options.worldmap.title", new Object[0]);
        this.cacheSettings = I18nUtils.getString("options.worldmap.cachesettings", new Object[0]);
        this.warning = I18nUtils.getString("options.worldmap.warning", new Object[0]);
        int var2 = 0;
        for (t = 0; t < relevantOptions.length; ++t) {
            option = relevantOptions[t];
            this.func_230480_a_((Widget)new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (ITextComponent)new StringTextComponent(this.options.getKeyText(option)), button -> this.optionClicked(button)));
            ++var2;
        }
        relevantOptions2 = new EnumOptionsMinimap[]{EnumOptionsMinimap.MINZOOM, EnumOptionsMinimap.MAXZOOM, EnumOptionsMinimap.CACHESIZE};
        var2 += 2;
        for (t = 0; t < relevantOptions2.length; ++t) {
            option = relevantOptions2[t];
            if (option.isFloat()) {
                float sValue = this.options.getOptionFloatValue(option);
                float fValue = 0.0f;
                switch (option) {
                    case MINZOOM: {
                        this.options.getClass();
                        this.options.getClass();
                        this.options.getClass();
                        fValue = (sValue - -3.0f) / (float)(5 - -3);
                        break;
                    }
                    case MAXZOOM: {
                        this.options.getClass();
                        this.options.getClass();
                        this.options.getClass();
                        fValue = (sValue - -3.0f) / (float)(5 - -3);
                        break;
                    }
                    case CACHESIZE: {
                        this.options.getClass();
                        fValue = sValue / 5000.0f;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + option.getName() + ". (possibly not a float value applicable to persistent map)");
                    }
                }
                this.func_230480_a_((Widget)new GuiOptionSliderMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, fValue, this.options));
            } else {
                this.func_230480_a_((Widget)new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (ITextComponent)new StringTextComponent(this.options.getKeyText(option)), button -> this.optionClicked(button)));
            }
            ++var2;
        }
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parent)));
        for (Widget buttonObj : this.getButtonList()) {
            GuiOptionButtonMinimap button2;
            if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button2 = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWWAYPOINTNAMES)) continue;
            button2.field_230693_o_ = this.options.showWaypoints;
        }
    }

    protected void optionClicked(Button par1GuiButton) {
        EnumOptionsMinimap option = ((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions();
        this.options.setOptionValue(option);
        par1GuiButton.func_238482_a_((ITextComponent)new StringTextComponent(this.options.getKeyText(option)));
        for (Widget buttonObj : this.getButtonList()) {
            GuiOptionButtonMinimap button;
            if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWWAYPOINTNAMES)) continue;
            button.field_230693_o_ = this.options.showWaypoints;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        for (Widget buttonObj : this.getButtonList()) {
            if (!(buttonObj instanceof GuiOptionSliderMinimap)) continue;
            GuiOptionSliderMinimap slider = (GuiOptionSliderMinimap)buttonObj;
            EnumOptionsMinimap option = slider.returnEnumOptions();
            float sValue = this.options.getOptionFloatValue(option);
            float fValue = 0.0f;
            switch (option) {
                case MINZOOM: {
                    this.options.getClass();
                    this.options.getClass();
                    this.options.getClass();
                    fValue = (sValue - -3.0f) / (float)(5 - -3);
                    break;
                }
                case MAXZOOM: {
                    this.options.getClass();
                    this.options.getClass();
                    this.options.getClass();
                    fValue = (sValue - -3.0f) / (float)(5 - -3);
                    break;
                }
                case CACHESIZE: {
                    this.options.getClass();
                    fValue = sValue / 5000.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + option.getName() + ". (possibly not a float value applicable to persistent map)");
                }
            }
            if (this.func_241217_q_() == slider) continue;
            slider.setValue(fValue);
        }
        super.drawMap(matrixStack);
        this.func_230446_a_(matrixStack);
        GuiPersistentMapOptions.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        GuiPersistentMapOptions.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.cacheSettings, (int)(this.getWidth() / 2), (int)(this.getHeight() / 6 + 24), (int)0xFFFFFF);
        GuiPersistentMapOptions.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.warning, (int)(this.getWidth() / 2), (int)(this.getHeight() / 6 + 34), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, par1, par2, par3);
    }
}

