/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class BiomeRepository {
    public static Biome DEFAULT;
    public static Biome FOREST;
    public static Biome SWAMP;
    public static Biome SWAMP_HILLS;
    private static IdentityHashMap<Biome, Integer> biomeToInt;
    private static int count;
    private static Biome[] biomes;
    private static Random generator;
    private static HashMap<Integer, Integer> IDtoColor;
    private static TreeMap<String, Integer> nameToColor;
    private static boolean dirty;

    public static void getBiomes() {
        DEFAULT = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(Biomes.field_76771_b.func_240901_a_());
        FOREST = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(Biomes.field_76767_f.func_240901_a_());
        SWAMP = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(Biomes.field_76780_h.func_240901_a_());
        SWAMP_HILLS = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(Biomes.field_150599_m.func_240901_a_());
    }

    public static int getBiomeId(Biome biome) {
        Integer id = biomeToInt.get(biome);
        if (id == null) {
            id = count;
            BiomeRepository.biomes[id.intValue()] = biome;
            biomeToInt.put(biome, id);
            ++count;
        }
        return id;
    }

    public static Biome betBiomeByID(int id) {
        return biomes[id];
    }

    public static void loadBiomeColors() {
        File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
        File settingsFile = new File(saveDir, "biomecolors.txt");
        if (settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader br = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = br.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    if (curLine.length != 2) continue;
                    String name = curLine[0];
                    int color = 0;
                    try {
                        color = Integer.decode(curLine[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                        color = 0;
                    }
                    if (nameToColor.put(name, color) == null) continue;
                    dirty = true;
                }
                br.close();
            }
            catch (Exception e) {
                System.err.println("biome load error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        try {
            String sCurrentLine;
            InputStream is = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "conf/biomecolors.txt")).func_199027_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] curLine = sCurrentLine.split("=");
                if (curLine.length != 2) continue;
                String name = curLine[0];
                int color = 0;
                try {
                    color = Integer.decode(curLine[1]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Error decoding integer string for biome colors; " + curLine[1]);
                    color = 0;
                }
                if (nameToColor.get(name) != null) continue;
                nameToColor.put(name, color);
                dirty = true;
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            System.out.println("Error loading biome color config file from litemod!");
            e.printStackTrace();
        }
    }

    public static void saveBiomeColors() {
        if (dirty) {
            File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File settingsFile = new File(saveDir, "biomecolors.txt");
            try {
                PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
                for (Map.Entry<String, Integer> entry : nameToColor.entrySet()) {
                    String name = entry.getKey();
                    Integer color = entry.getValue();
                    String hexColor = Integer.toHexString(color);
                    while (hexColor.length() < 6) {
                        hexColor = "0" + hexColor;
                    }
                    hexColor = "0x" + hexColor;
                    out.println(name + "=" + hexColor);
                }
                out.close();
            }
            catch (Exception e) {
                System.err.println("biome save error: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        dirty = false;
    }

    public static int getBiomeColor(int biomeID) {
        Integer color = IDtoColor.get(biomeID);
        if (color == null) {
            Biome biome = (Biome)Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_148745_a(biomeID);
            if (biome != null) {
                String friendlyName;
                String identifier = Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome).toString();
                color = nameToColor.get(identifier);
                if (color == null && (color = nameToColor.get(friendlyName = BiomeRepository.getName(biome))) != null) {
                    nameToColor.remove(friendlyName);
                    nameToColor.put(identifier, color);
                    dirty = true;
                }
                if (color == null) {
                    int r = generator.nextInt(255);
                    int g = generator.nextInt(255);
                    int b = generator.nextInt(255);
                    color = r << 16 | g << 8 | b;
                    nameToColor.put(identifier, color);
                    dirty = true;
                }
            } else {
                System.out.println("non biome");
                color = 0;
            }
            IDtoColor.put(biomeID, color);
        }
        return color;
    }

    private static String getName(Biome biome) {
        ResourceLocation resourceLocation = Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        String translationKey = Util.func_200697_a((String)"biome", (ResourceLocation)resourceLocation);
        String name = I18nUtils.getString(translationKey, new Object[0]);
        if (name.equals(translationKey)) {
            name = TextUtils.prettify(resourceLocation.func_110623_a().toString());
        }
        return name;
    }

    public static String getName(int biomeID) {
        String name = null;
        Biome biome = (Biome)Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_148745_a(biomeID);
        if (biome != null) {
            name = BiomeRepository.getName(biome);
        }
        if (name == null) {
            name = "Unknown";
        }
        return name;
    }

    static {
        biomeToInt = new IdentityHashMap(256);
        count = 1;
        biomes = new Biome[65536];
        biomeToInt.put(DEFAULT, 0);
        Arrays.fill(biomes, DEFAULT);
        generator = new Random();
        IDtoColor = new HashMap(256);
        nameToColor = new TreeMap();
        dirty = false;
    }
}

