/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import java.io.Serializable;
import java.util.Locale;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public class Waypoint
implements Serializable,
Comparable<Waypoint> {
    private static final long serialVersionUID = 8136790917447997951L;
    public String name;
    public String imageSuffix = "";
    public String world = "";
    public TreeSet<DimensionContainer> dimensions = new TreeSet();
    public int x;
    public int z;
    public int y;
    public boolean enabled;
    public boolean inWorld = true;
    public boolean inDimension = true;
    public float red = 0.0f;
    public float green = 1.0f;
    public float blue = 0.0f;

    public Waypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<DimensionContainer> dimensions) {
        this.name = name;
        this.x = x;
        this.z = z;
        this.y = y;
        this.enabled = enabled;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.imageSuffix = suffix.toLowerCase(Locale.ROOT);
        this.world = world;
        this.dimensions = dimensions;
    }

    public int getUnifiedColor() {
        return -16777216 + ((int)(this.red * 255.0f) << 16) + ((int)(this.green * 255.0f) << 8) + (int)(this.blue * 255.0f);
    }

    public boolean isActive() {
        return this.enabled && this.inWorld && this.inDimension;
    }

    public int getX() {
        return (int)((double)this.x / Minecraft.func_71410_x().field_71439_g.field_70170_p.func_230315_m_().func_242724_f());
    }

    public int getZ() {
        return (int)((double)this.z / Minecraft.func_71410_x().field_71439_g.field_70170_p.func_230315_m_().func_242724_f());
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = (int)((double)x * Minecraft.func_71410_x().field_71439_g.field_70170_p.func_230315_m_().func_242724_f());
    }

    public void setZ(int z) {
        this.z = (int)((double)z * Minecraft.func_71410_x().field_71439_g.field_70170_p.func_230315_m_().func_242724_f());
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int compareTo(Waypoint arg0) {
        double myDistance = this.getDistanceSqToEntity((Entity)Minecraft.func_71410_x().field_71439_g);
        double comparedDistance = arg0.getDistanceSqToEntity((Entity)Minecraft.func_71410_x().field_71439_g);
        return Double.compare(myDistance, comparedDistance);
    }

    public double getDistanceSqToEntity(Entity par1Entity) {
        double var2 = (double)this.getX() + 0.5 - par1Entity.func_226277_ct_();
        double var4 = (double)this.getY() + 0.5 - par1Entity.func_226278_cu_();
        double var6 = (double)this.getZ() + 0.5 - par1Entity.func_226281_cx_();
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Waypoint)) {
            return false;
        }
        Waypoint otherWaypoint = (Waypoint)otherObject;
        return this.name.equals(otherWaypoint.name) && this.imageSuffix.equals(otherWaypoint.imageSuffix) && this.world.equals(otherWaypoint.world) && this.x == otherWaypoint.x && this.y == otherWaypoint.y && this.z == otherWaypoint.z && this.red == otherWaypoint.red && this.green == otherWaypoint.green && this.blue == otherWaypoint.blue && this.dimensions.equals(otherWaypoint.dimensions);
    }
}

