/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.contents.Contents;

@Mod.EventBusSubscriber(modid="paraglider")
public abstract class PlayerMovement
implements ICapabilityProvider {
    @CapabilityInject(value=PlayerMovement.class)
    public static final Capability<PlayerMovement> CAP = null;
    public static final int BASE_STAMINA = 1000;
    public static final int STAMINA_INCREMENT = 200;
    public static final int RECOVERY_DELAY = 10;
    public static final int MAX_STAMINA_VESSELS = 10;
    public static final int MAX_HEART_CONTAINERS = 20;
    public final PlayerEntity player;
    private PlayerState state = PlayerState.IDLE;
    private int stamina = 1000;
    private boolean depleted;
    private int recoveryDelay;
    private int staminaVessels;
    private int heartContainers;
    private final LazyOptional<PlayerMovement> self = LazyOptional.of(() -> this);

    public PlayerMovement(PlayerEntity player) {
        this.player = Objects.requireNonNull(player);
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = Objects.requireNonNull(state);
    }

    public int getStamina() {
        return this.stamina;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public boolean isDepleted() {
        return this.depleted;
    }

    public void setDepleted(boolean depleted) {
        this.depleted = depleted;
    }

    public int getRecoveryDelay() {
        return this.recoveryDelay;
    }

    public void setRecoveryDelay(int recoveryDelay) {
        this.recoveryDelay = recoveryDelay;
    }

    public int getStaminaVessels() {
        return this.staminaVessels;
    }

    public void setStaminaVessels(int staminaVessels) {
        this.staminaVessels = MathHelper.func_76125_a((int)staminaVessels, (int)0, (int)10);
    }

    public int getHeartContainers() {
        return this.heartContainers;
    }

    public void setHeartContainers(int heartContainers) {
        this.heartContainers = MathHelper.func_76125_a((int)heartContainers, (int)0, (int)20);
    }

    public int getMaxStamina() {
        return 1000 + this.staminaVessels * 200;
    }

    public boolean canUseParaglider() {
        return this.player.field_71075_bZ.field_75098_d || !this.depleted;
    }

    public abstract boolean isParagliding();

    public abstract void update();

    protected void updateStamina() {
        if (this.state.staminaAction.isConsume) {
            this.recoveryDelay = 10;
            if (!this.depleted && (this.state.isParagliding() ? ModCfg.paraglidingConsumesStamina() : ModCfg.runningConsumesStamina())) {
                this.stamina = this.stamina < this.state.staminaAction.change ? 0 : (this.stamina -= this.state.staminaAction.change);
            }
        } else {
            if (this.state.staminaAction == PlayerState.StaminaAction.FAST_RECOVER) {
                this.recoveryDelay = 0;
            }
            if (this.recoveryDelay > 0) {
                --this.recoveryDelay;
            } else if (this.state.staminaAction.change > 0) {
                int max = this.getMaxStamina();
                this.stamina = this.stamina + this.state.staminaAction.change >= max ? max : (this.stamina += this.state.staminaAction.change);
            }
        }
    }

    protected void applyMovement() {
        if (!this.player.field_71075_bZ.field_75098_d && this.isDepleted()) {
            this.player.func_195064_c(new EffectInstance((Effect)Contents.EXHAUSTED.get(), 2, 0, false, false, false));
        }
        if (this.isParagliding()) {
            this.player.field_70143_R = 1.5f;
            Vector3d m = this.player.func_213322_ci();
            switch (this.state) {
                case PARAGLIDING: {
                    if (!(m.field_72448_b < -0.05)) break;
                    this.player.func_213317_d(new Vector3d(m.field_72450_a, -0.05, m.field_72449_c));
                    break;
                }
                case ASCENDING: {
                    if (!(m.field_72448_b < 0.25)) break;
                    this.player.func_213317_d(new Vector3d(m.field_72450_a, Math.max(m.field_72448_b + 0.05, 0.25), m.field_72449_c));
                }
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == CAP ? this.self.cast() : LazyOptional.empty();
    }
}

