/*
 * Decompiled with CFR 0.152.
 */
package its_meow.quickteleports;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import its_meow.quickteleports.TpConfig;
import its_meow.quickteleports.util.FTC;
import its_meow.quickteleports.util.HereTeleport;
import its_meow.quickteleports.util.Teleport;
import its_meow.quickteleports.util.ToTeleport;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod(value="quickteleports")
@Mod.EventBusSubscriber(modid="quickteleports")
public class QuickTeleportsMod {
    public static final String MOD_ID = "quickteleports";
    public static HashMap<Teleport, Integer> tps = new HashMap();

    public QuickTeleportsMod() {
        TpConfig.setupConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, TpConfig.SERVER_CONFIG);
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher d = event.getServer().func_195571_aL().func_197054_a();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpa").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(Commands.func_197056_a((String)"target", (ArgumentType)GameProfileArgument.func_197108_a()).executes(command -> {
            Collection profiles = GameProfileArgument.func_197109_a((CommandContext)command, (String)"target");
            if (profiles.size() > 1) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "Specify one player as an argument!")});
                return 0;
            }
            GameProfile profile = QuickTeleportsMod.getFirstProfile(profiles);
            if (!QuickTeleportsMod.isGameProfileOnline(profile)) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "This player is not online!")});
                return 0;
            }
            if (profile.getId().equals(((CommandSource)command.getSource()).func_197035_h().func_146103_bH().getId())) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "You cannot teleport to yourself!")});
                return 0;
            }
            String sourceName = ((CommandSource)command.getSource()).func_197035_h().func_200200_C_().getString();
            ServerPlayerEntity targetPlayer = event.getServer().func_184103_al().func_177451_a(profile.getId());
            Teleport remove = QuickTeleportsMod.getRequestTP(sourceName);
            if (remove != null) {
                tps.remove(remove);
                QuickTeleportsMod.notifyCanceledTP(remove);
            }
            ToTeleport teleport = new ToTeleport(sourceName, targetPlayer.func_200200_C_().getString());
            tps.put(teleport, (Integer)TpConfig.CONFIG.timeout.get() * 20);
            QuickTeleportsMod.sendMessage((PlayerEntity)targetPlayer, new TextComponent[]{new FTC(TextFormatting.GREEN, sourceName), new FTC(TextFormatting.GOLD, " has requested to teleport to you. Type "), new FTC(TextFormatting.YELLOW, "/tpaccept"), new FTC(TextFormatting.GOLD, " to accept.")});
            QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.GOLD, "Requested to teleport to "), new FTC(TextFormatting.GREEN, targetPlayer.func_200200_C_().getString()), new FTC(TextFormatting.GOLD, ".")});
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpaccept").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).executes(command -> {
            Teleport tp = QuickTeleportsMod.getSubjectTP(((CommandSource)command.getSource()).func_197035_h().func_200200_C_().getString());
            if (tp == null) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "You have no pending teleport requests!")});
                return 0;
            }
            tps.remove(tp);
            ServerPlayerEntity playerRequesting = event.getServer().func_184103_al().func_152612_a(tp.getRequester());
            ServerPlayerEntity playerMoving = event.getServer().func_184103_al().func_152612_a(tp.getSubject());
            if (playerMoving == null) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "The player that is teleporting no longer exists!")});
                return 0;
            }
            if (tp instanceof ToTeleport) {
                ServerPlayerEntity holder = playerMoving;
                playerMoving = playerRequesting;
                playerRequesting = holder;
            }
            QuickTeleportsMod.sendMessage((PlayerEntity)playerRequesting, new TextComponent[]{new FTC(TextFormatting.GREEN, "Teleport request accepted.")});
            QuickTeleportsMod.sendMessage((PlayerEntity)playerMoving, new TextComponent[]{new FTC(TextFormatting.GREEN, tp instanceof ToTeleport ? "Your teleport request has been accepted." : "You are now being teleported.")});
            double posX = playerRequesting.func_226277_ct_();
            double posY = playerRequesting.func_226278_cu_();
            double posZ = playerRequesting.func_226281_cx_();
            playerMoving.func_200619_a(playerRequesting.func_71121_q(), posX, posY, posZ, playerRequesting.field_70177_z, 0.0f);
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tpahere").requires(source -> {
            try {
                return source.func_197035_h() != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        })).then(Commands.func_197056_a((String)"target", (ArgumentType)GameProfileArgument.func_197108_a()).executes(command -> {
            Collection profiles = GameProfileArgument.func_197109_a((CommandContext)command, (String)"target");
            if (profiles.size() > 1) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "Specify one player as an argument!")});
                return 0;
            }
            GameProfile profile = QuickTeleportsMod.getFirstProfile(profiles);
            if (!QuickTeleportsMod.isGameProfileOnline(profile)) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "This player is not online!")});
                return 0;
            }
            if (profile.getId().equals(((CommandSource)command.getSource()).func_197035_h().func_146103_bH().getId())) {
                QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.RED, "You cannot send a teleport request to yourself!")});
                return 0;
            }
            String sourceName = ((CommandSource)command.getSource()).func_197035_h().func_200200_C_().getString();
            Teleport remove = QuickTeleportsMod.getRequestTP(sourceName);
            if (remove != null) {
                tps.remove(remove);
                QuickTeleportsMod.notifyCanceledTP(remove);
            }
            ServerPlayerEntity targetPlayer = event.getServer().func_184103_al().func_177451_a(profile.getId());
            HereTeleport tp = new HereTeleport(sourceName, targetPlayer.func_200200_C_().getString());
            tps.put(tp, (Integer)TpConfig.CONFIG.timeout.get() * 20);
            QuickTeleportsMod.sendMessage((PlayerEntity)targetPlayer, new TextComponent[]{new FTC(TextFormatting.GREEN, sourceName), new FTC(TextFormatting.GOLD, " has requested that you teleport to them. Type "), new FTC(TextFormatting.YELLOW, "/tpaccept"), new FTC(TextFormatting.GOLD, " to accept.")});
            QuickTeleportsMod.sendMessage((CommandSource)command.getSource(), new TextComponent[]{new FTC(TextFormatting.GOLD, "Requested "), new FTC(TextFormatting.GREEN, targetPlayer.func_200200_C_().getString()), new FTC(TextFormatting.GOLD, " to teleport to you.")});
            return 1;
        })));
    }

    private static boolean isGameProfileOnline(GameProfile profile) {
        ServerPlayerEntity player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(profile.getId());
        return player != null && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v().contains(player);
    }

    private static GameProfile getFirstProfile(Collection<GameProfile> profiles) {
        Iterator<GameProfile> iterator = profiles.iterator();
        if (iterator.hasNext()) {
            GameProfile profile = iterator.next();
            return profile;
        }
        return null;
    }

    @Nullable
    public static Teleport getSubjectTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getSubject().equalsIgnoreCase(name)) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static Teleport getRequestTP(String name) {
        for (Teleport pair : tps.keySet()) {
            if (!pair.getRequester().equalsIgnoreCase(name)) continue;
            return pair;
        }
        return null;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        HashSet<Teleport> toRemove = new HashSet<Teleport>();
        for (Teleport tp : tps.keySet()) {
            int time = tps.get(tp);
            if (time > 0) {
                tps.put(tp, --time);
                continue;
            }
            if (time > 0) continue;
            toRemove.add(tp);
            QuickTeleportsMod.notifyTimeoutTP(tp);
        }
        for (Teleport remove : toRemove) {
            tps.remove(remove);
        }
    }

    public static void notifyTimeoutTP(Teleport tp) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerPlayerEntity tper = server.func_184103_al().func_152612_a(tp.getRequester());
        ServerPlayerEntity target = server.func_184103_al().func_152612_a(tp.getSubject());
        if (target != null) {
            QuickTeleportsMod.sendMessage((PlayerEntity)target, new TextComponent[]{new FTC(TextFormatting.GOLD, "Teleport request from "), new FTC(TextFormatting.GREEN, tp.getRequester()), new FTC(TextFormatting.GOLD, " timed out.")});
        }
        if (tper != null) {
            QuickTeleportsMod.sendMessage((PlayerEntity)tper, new TextComponent[]{new FTC(TextFormatting.GOLD, "Your request to "), new FTC(TextFormatting.GREEN, tp.getSubject()), new FTC(TextFormatting.GOLD, " has timed out after not being accepted.")});
        }
    }

    public static void notifyCanceledTP(Teleport tp) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerPlayerEntity tper = server.func_184103_al().func_152612_a(tp.getRequester());
        ServerPlayerEntity target = server.func_184103_al().func_152612_a(tp.getSubject());
        if (target != null) {
            QuickTeleportsMod.sendMessage((PlayerEntity)target, new TextComponent[]{new FTC(TextFormatting.GOLD, "Teleport request from "), new FTC(TextFormatting.GREEN, tp.getRequester()), new FTC(TextFormatting.GOLD, " has been cancelled.")});
        }
        if (tper != null) {
            QuickTeleportsMod.sendMessage((PlayerEntity)tper, new TextComponent[]{new FTC(TextFormatting.GOLD, "Your request to "), new FTC(TextFormatting.GREEN, tp.getSubject()), new FTC(TextFormatting.GOLD, " has been cancelled.")});
        }
    }

    public static void sendMessage(CommandSource source, TextComponent ... styled) throws CommandSyntaxException {
        QuickTeleportsMod.sendMessage((PlayerEntity)source.func_197035_h(), styled);
    }

    public static void sendMessage(PlayerEntity source, TextComponent ... styled) {
        if (styled.length > 0) {
            TextComponent comp = styled[0];
            if (styled.length > 1) {
                for (int i = 1; i < styled.length; ++i) {
                    comp.func_230529_a_((ITextComponent)styled[i]);
                }
            }
            source.func_145747_a((ITextComponent)comp, Util.field_240973_b_);
        }
    }
}

