/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class CommonItemModelsProvider
extends ItemModelProvider {
    protected final Marker marker;
    protected final GenerationData data;
    protected final String modid;
    protected final DataGenerator generator;

    public CommonItemModelsProvider(GenerationData data) {
        super(data.getGenerator(), data.getModid(), data.getExistingFileHelper());
        this.data = data;
        this.modid = data.getModid();
        this.generator = data.getGenerator();
        this.marker = MarkerManager.getMarker((String)this.m_6055_());
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.generatedModels.clear();
        this.registerModels();
        this.generatedModels.values().forEach(model -> {
            try {
                ResourceLocation location = model.getLocation();
                CommonProvider.write(cache, (JsonElement)model.toJson(), this.generator.m_123916_().resolve("assets/" + location.m_135827_() + "/models/" + location.m_135815_() + ".json"));
            }
            catch (IOException ex) {
                CommonProvider.LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    public String m_6055_() {
        return "Item-Models";
    }

    protected void simpleGenerated(ItemLike provider) {
        this.simpleParent(provider, "item/generated");
    }

    protected void simpleHandheld(ItemLike provider) {
        this.simpleParent(provider, "item/handheld");
    }

    protected void spawnEgg(ItemLike provider) {
        this.withExistingParent(provider.m_5456_().getRegistryName().m_135815_(), "item/template_spawn_egg");
    }

    protected void simpleParent(ItemLike provider, String parent) {
        String registryPath = provider.m_5456_().getRegistryName().m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(registryPath)).parent((ModelFile)new ModelFile.UncheckedModelFile(parent))).texture("layer0", "item/" + registryPath);
    }

    protected void simpleBlock(Block block) {
        ResourceLocation registryName = block.getRegistryName();
        ((ItemModelBuilder)this.getBuilder(registryName.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(registryName.m_135827_(), "block/" + registryName.m_135815_())));
    }

    protected void iterateItems(Iterable<? extends Supplier<? extends Item>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected void iterateBlocks(Iterable<? extends RegistryObject<? extends Block>> iterable, Consumer<ItemLike> item) {
        Streams.stream(iterable).map(Supplier::get).forEach(item);
    }

    protected String getPath(ItemLike provider) {
        return provider.m_5456_().getRegistryName().m_135815_();
    }
}

