/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.GsonUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class CommonProvider
implements DataProvider {
    public static final Logger LOGGER = LogManager.getLogger((String)"DataGenerator");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Marker marker;
    protected final GenerationData data;
    protected final String modid;
    protected final DataGenerator generator;
    protected final Path path;

    public CommonProvider(GenerationData data) {
        this.data = data;
        this.generator = data.getGenerator();
        this.modid = data.getModid();
        this.path = this.generator.m_123916_();
        this.marker = MarkerManager.getMarker((String)this.m_6055_());
    }

    public ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.modid, path);
    }

    public ResourceLocation mcLoc(String path) {
        return new ResourceLocation(path);
    }

    public Path resolveModData() {
        return this.path.resolve("data").resolve(this.modid);
    }

    public Path resolveModAssets() {
        return this.path.resolve("assets").resolve(this.modid);
    }

    public Path resolveData(ResourceLocation location) {
        return this.path.resolve("data").resolve(location.m_135827_());
    }

    public Path resolveAssets(ResourceLocation location) {
        return this.path.resolve("assets").resolve(location.m_135827_());
    }

    public static void write(HashCache cache, JsonElement element, Path path) throws IOException {
        CommonProvider.write(cache, element, path, GSON);
    }

    public static void write(HashCache cache, JsonElement element, Path path, Gson gson) throws IOException {
        try (StringWriter writer = new StringWriter();
             JsonWriter jsonWriter = GsonUtil.createTabWriter(gson, writer);){
            GSON.toJson(element, jsonWriter);
            CommonProvider.write(cache, writer.toString(), path);
        }
        catch (IOException ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    public static void write(HashCache cache, String string, Path path) throws IOException {
        String hash = f_123918_.hashUnencodedChars((CharSequence)string).toString();
        if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(string);
            }
        }
        cache.m_123940_(path, hash);
    }
}

