/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.util.TagUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public abstract class CommonRecipesProvider
extends CommonProvider {
    public CommonRecipesProvider(GenerationData data) {
        super(data);
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.registerRecipes(recipe -> this.generateRecipe(cache, (FinishedRecipe)recipe, false));
        this.registerDefaultAdvancementsRecipes(recipe -> this.generateRecipe(cache, (FinishedRecipe)recipe, true));
    }

    public String m_6055_() {
        return "Recipes";
    }

    private void generateRecipe(HashCache cache, FinishedRecipe recipe, boolean vanillaAdvancement) {
        try {
            ResourceLocation recipeLocation = recipe.m_6445_();
            CommonRecipesProvider.write(cache, (JsonElement)recipe.m_125966_(), this.resolveData(recipeLocation).resolve("recipes").resolve(recipe.m_6445_().m_135815_() + ".json"));
            if (recipe.m_5860_() != null) {
                Path advancementPath;
                if (vanillaAdvancement) {
                    ResourceLocation advancementLocation = recipe.m_6448_();
                    advancementPath = this.resolveData(advancementLocation).resolve("advancements").resolve(advancementLocation.m_135815_() + ".json");
                } else {
                    advancementPath = this.resolveData(recipeLocation).resolve("advancements").resolve("recipes").resolve(recipeLocation.m_135815_() + ".json");
                }
                CommonRecipesProvider.write(cache, (JsonElement)recipe.m_5860_(), advancementPath);
            }
        }
        catch (IOException ex) {
            LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
        }
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    protected void registerDefaultAdvancementsRecipes(Consumer<FinishedRecipe> consumer) {
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tag) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemLike item) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public static Ingredient getIngredientOfTag(TagKey<Item> tag) {
        return TagUtil.getSerializableIngredientOfTag(tag);
    }
}

