/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.gui.elements.CheckboxButton;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;

public class ScalableCheckboxButton
extends CheckboxButton
implements Scalable,
ScaleProvider {
    protected float scale;

    public ScalableCheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, float scale) {
        this(x, y, width, height, text, checked, drawText, scale, EMTPY_PRESSABLE);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, float scale, Button.OnPress pessable) {
        this(x, y, width, height, text, checked, drawText, scale, pessable, EMPTY_TOOLTIP);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, float scale, Button.OnTooltip tooltip) {
        this(x, y, width, height, text, checked, drawText, scale, EMTPY_PRESSABLE, tooltip);
    }

    public ScalableCheckboxButton(int x, int y, int width, int height, Component text, boolean checked, boolean drawText, float scale, Button.OnPress pessable, Button.OnTooltip tooltip) {
        super(x, y, width, height, text, checked, drawText, pessable, tooltip);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.drawText) {
            Font font = this.getCurrentTextFont();
            Component message = this.getCurrentText();
            if (message != TextComponent.f_131282_) {
                float currentScale = this.getCurrentScale(poseStack, mouseX, mouseY, partialTicks);
                float positionFactor = 1.0f / currentScale;
                float yStart = (float)(this.f_93621_ + (int)((float)this.f_93619_ - 8.0f * currentScale) / 2) * positionFactor;
                float xStart = this.leftSideText ? ((float)this.f_93620_ - ((float)font.m_92852_((FormattedText)message) * currentScale + 4.0f)) * positionFactor : (float)(this.f_93620_ + this.f_93618_ + 4) * positionFactor;
                int color = this.getCurrentTextColor(poseStack, mouseX, mouseY, partialTicks).getColorARGB();
                poseStack.m_85836_();
                poseStack.m_85841_(currentScale, currentScale, 0.0f);
                if (this.dropShadow) {
                    font.m_92763_(poseStack, this.getCurrentText(), xStart, yStart, color);
                } else {
                    font.m_92889_(poseStack, this.getCurrentText(), xStart, yStart, color);
                }
                poseStack.m_85849_();
            }
        }
    }

    @Override
    public float getCurrentScale(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.scale;
    }
}

