/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.gui.elements.WidgetTextureProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.Slider;

public class USlider
extends Slider
implements PerspectiveRenderable,
BackgroundColorProvider,
TextProvider {
    protected static final Slider.ISlider EMTPY_SLIDER = slider -> {};
    protected static final Button.OnTooltip EMPTY_TOOLTIP = UButton.EMPTY_TOOLTIP;
    protected static final RGBA WHITE = UButton.WHITE;
    protected static final RGBA LIGHT_GRAY = UButton.LIGHT_GRAY;
    protected final boolean isInContainer;
    protected TextureProvider sliderBackgroundTextureProvider;
    protected RGBA sliderBackgroundColor;
    protected TextureProvider sliderTextureProvider;
    protected RGBA sliderColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, EMTPY_SLIDER);
    }

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Slider.ISlider slider) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, slider, EMPTY_TOOLTIP);
    }

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Button.OnTooltip tooltip) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, isInContainer, EMTPY_SLIDER, tooltip);
    }

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, boolean isInContainer, Slider.ISlider slider, Button.OnTooltip tooltip) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, UButton.EMTPY_PRESSABLE, slider);
        this.isInContainer = isInContainer;
        this.f_93718_ = tooltip;
        this.sliderBackgroundTextureProvider = new WidgetTextureProvider((AbstractWidget)this, hovered -> 0);
        this.sliderBackgroundColor = WHITE;
        this.sliderTextureProvider = new WidgetTextureProvider((AbstractWidget)this, hovered -> hovered != false ? 2 : 1);
        this.sliderColor = WHITE;
        this.textColor = WHITE;
        this.disabledTextColor = LIGHT_GRAY;
    }

    public void setSlider(Slider.ISlider slider) {
        this.parent = slider;
    }

    public void setSlider(Runnable runnable) {
        this.parent = slider -> runnable.run();
    }

    public void setTooltip(Button.OnTooltip tooltip) {
        this.f_93718_ = tooltip;
    }

    public RGBA getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public void setSliderBackgroundColor(RGBA sliderBackgroundColor) {
        this.sliderBackgroundColor = sliderBackgroundColor;
    }

    public RGBA getSliderColor() {
        return this.sliderColor;
    }

    public void setSliderColor(RGBA sliderColor) {
        this.sliderColor = sliderColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderButtonLikeWidget(this, this.sliderBackgroundTextureProvider, poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7906_(poseStack, Minecraft.m_91087_(), mouseX, mouseY);
        if (this.f_93624_) {
            RenderUtil.drawContinuousTexturedBox(poseStack, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)), this.f_93621_, this.sliderTextureProvider.getU(), this.sliderTextureProvider.getV(), 8, this.f_93619_, this.sliderBackgroundTextureProvider.getWidth(), this.sliderTextureProvider.getHeight(), 2, 3, 2, 2, this.m_93252_(), this.sliderTextureProvider.getTexture(), this.getCurrentSliderColor(poseStack, mouseX, mouseY, partialTicks));
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        WidgetUtil.renderText(this, poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderToolTip(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7428_(poseStack, mouseX, mouseY);
    }

    @Override
    public RGBA getCurrentBackgroundColor(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderBackgroundColor;
    }

    public RGBA getCurrentSliderColor(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.sliderColor;
    }

    @Override
    public Component getCurrentText() {
        return this.m_6035_();
    }

    @Override
    public RGBA getCurrentTextColor(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        return this.f_93623_ ? this.textColor : this.disabledTextColor;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.changeSliderValue(mouseX);
        if (this.isInContainer) {
            this.dragging = true;
        }
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.isInContainer) {
            this.changeSliderValue(mouseX);
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (this.m_198029_()) {
            super.m_7435_(Minecraft.m_91087_().m_91106_());
        }
        if (this.isInContainer) {
            this.dragging = false;
        }
    }

    protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isInContainer && this.f_93624_ && this.dragging) {
            this.changeSliderValue(mouseX);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float direction = flag ? -1.0f : 1.0f;
            this.setSliderValue(this.sliderValue + (double)(direction / (float)(this.f_93618_ - 8)));
        }
        return false;
    }

    public void m_7435_(SoundManager handler) {
    }

    protected void changeSliderValue(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
    }

    protected void setSliderValue(double value) {
        double oldValue = this.sliderValue;
        this.sliderValue = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.sliderValue) {
            this.updateSlider();
        }
    }
}

