/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.menu.FluidContainerMenu;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class ContainerSetFluidContentMessage {
    private final int containerId;
    private final int stateId;
    private final List<FluidStack> fluids;

    public ContainerSetFluidContentMessage(int containerId, int stateId, List<FluidStack> fluids) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.fluids = NonNullList.m_122780_((int)fluids.size(), (Object)FluidStack.EMPTY);
        for (int index = 0; index < fluids.size(); ++index) {
            this.fluids.set(index, fluids.get(index).copy());
        }
    }

    public static void encode(ContainerSetFluidContentMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeByte(message.containerId);
        byteBuf.m_130130_(message.stateId);
        byteBuf.m_178352_(message.fluids, IForgeFriendlyByteBuf::writeFluidStack);
    }

    public static ContainerSetFluidContentMessage decode(FriendlyByteBuf byteBuf) {
        byte containerId = byteBuf.readByte();
        int stateId = byteBuf.m_130242_();
        NonNullList fluids = (NonNullList)byteBuf.m_178371_(NonNullList::m_182647_, IForgeFriendlyByteBuf::readFluidStack);
        return new ContainerSetFluidContentMessage(containerId, stateId, (List<FluidStack>)fluids);
    }

    public static class Handler {
        public static void handle(ContainerSetFluidContentMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> Handler.testContainerMenu(Minecraft.m_91087_().f_91074_.f_36096_, message.containerId).ifPresent(menu -> menu.initializeFluidContents(message.stateId, message.fluids)));
            context.setPacketHandled(true);
        }

        private static final Optional<FluidContainerMenu> testContainerMenu(AbstractContainerMenu menu, int containerId) {
            if (menu instanceof FluidContainerMenu) {
                FluidContainerMenu fluidMenu = (FluidContainerMenu)menu;
                if (menu.f_38840_ == containerId) {
                    return Optional.of(fluidMenu);
                }
            }
            return Optional.empty();
        }
    }
}

