/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.menu.FluidContainerMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class ContainerSetFluidSlotMessage {
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final FluidStack stack;

    public ContainerSetFluidSlotMessage(int containerId, int stateId, int slot, FluidStack stack) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.stack = stack.copy();
    }

    public static void encode(ContainerSetFluidSlotMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeByte(message.containerId);
        byteBuf.m_130130_(message.stateId);
        byteBuf.writeShort(message.slot);
        byteBuf.writeFluidStack(message.stack);
    }

    public static ContainerSetFluidSlotMessage decode(FriendlyByteBuf byteBuf) {
        byte containerId = byteBuf.readByte();
        int stateId = byteBuf.m_130242_();
        short slot = byteBuf.readShort();
        FluidStack stack = byteBuf.readFluidStack();
        return new ContainerSetFluidSlotMessage(containerId, stateId, slot, stack);
    }

    public static class Handler {
        public static void handle(ContainerSetFluidSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> Handler.testContainerMenu(Minecraft.m_91087_().f_91074_.f_36096_, message.containerId).ifPresent(container -> container.setFluid(message.slot, message.stateId, message.stack)));
            context.setPacketHandled(true);
        }

        private static final Optional<FluidContainerMenu> testContainerMenu(AbstractContainerMenu container, int containerId) {
            if (container instanceof FluidContainerMenu) {
                FluidContainerMenu fluidMenu = (FluidContainerMenu)container;
                if (container.f_38840_ == containerId) {
                    return Optional.of(fluidMenu);
                }
            }
            return Optional.empty();
        }
    }
}

