/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public interface IBlockTypeRegistry<T extends IBlockType> {
    public T getFromNBT(String var1);

    public T getDefaultType();

    public Map<ResourceLocation, T> getTypes();

    public void registerBlockType(T var1);

    public Optional<T> scanAndGet(Block var1);

    public void addFinder(IBlockType.SetFinder<T> var1);

    public Collection<IBlockType.SetFinder<T>> getFinders();

    public void finalizeAndFreeze();

    default public void buildAll() {
        this.registerBlockType(this.getDefaultType());
        Collection<IBlockType.SetFinder<T>> finders = this.getFinders();
        finders.stream().map(IBlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
        for (Block b : ForgeRegistries.BLOCKS) {
            this.scanAndGet(b).ifPresent(this::registerBlockType);
        }
        this.finalizeAndFreeze();
    }
}

