/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.wood;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.mehvahdjukaar.selene.block_set.IBlockTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
implements IBlockTypeRegistry<WoodType> {
    public static WoodTypeRegistry INSTANCE;
    public static Map<ResourceLocation, WoodType> WOOD_TYPES;
    private boolean frozen = false;
    private final List<IBlockType.SetFinder<WoodType>> WOOD_FINDERS = new ArrayList<IBlockType.SetFinder<WoodType>>();
    private final List<WoodType> builder = new ArrayList<WoodType>();

    public WoodTypeRegistry() {
        INSTANCE = this;
    }

    @Override
    public WoodType getFromNBT(String name) {
        return this.getTypes().getOrDefault(new ResourceLocation(name), this.getDefaultType());
    }

    public static WoodType fromNBT(String name) {
        return WOOD_TYPES.getOrDefault(new ResourceLocation(name), WoodType.OAK_WOOD_TYPE);
    }

    @Override
    public WoodType getDefaultType() {
        return WoodType.OAK_WOOD_TYPE;
    }

    @Override
    public Map<ResourceLocation, WoodType> getTypes() {
        if (!this.frozen) {
            throw new UnsupportedOperationException("Tried to access wood types too early");
        }
        return WOOD_TYPES;
    }

    @Override
    public void registerBlockType(WoodType newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register wood types after registry events");
        }
        this.builder.add(newType);
    }

    @Override
    public void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Wood types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.builder.forEach(e -> {
            if (!linkedHashMap.containsKey(e.id)) {
                linkedHashMap.put(e.id, e);
            }
        });
        WOOD_TYPES = ImmutableMap.copyOf(linkedHashMap);
        this.builder.clear();
        this.frozen = true;
    }

    @Override
    public void addFinder(IBlockType.SetFinder<WoodType> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register wood type finder after registry events");
        }
        this.WOOD_FINDERS.add(finder);
    }

    @Override
    public List<IBlockType.SetFinder<WoodType>> getFinders() {
        return this.WOOD_FINDERS;
    }

    @Override
    public Optional<WoodType> scanAndGet(Block baseBlock) {
        ResourceLocation id;
        Block logBlock;
        Material mat;
        BlockState state;
        ResourceLocation baseRes = baseBlock.getRegistryName();
        String name = null;
        String path = baseRes.m_135815_();
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        if (!(name == null || (state = baseBlock.m_49966_()).m_61147_().size() > 2 || baseBlock instanceof SlabBlock || (mat = state.m_60767_()) != Material.f_76320_ && mat != Material.f_76321_ || (logBlock = WoodTypeRegistry.findLog(id = new ResourceLocation(baseRes.m_135827_(), name))) == null)) {
            return Optional.of(new WoodType(id, baseBlock, logBlock));
        }
        return Optional.empty();
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!ForgeRegistries.BLOCKS.containsKey(r)) continue;
            temp = (Block)ForgeRegistries.BLOCKS.getValue(r);
            break;
        }
        return temp;
    }

    static {
        WOOD_TYPES = new LinkedHashMap<ResourceLocation, WoodType>();
    }
}

