/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.VanillaResourceManager;
import net.mehvahdjukaar.selene.textures.Respriter;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ResourcePackAwareDynamicTextureProvider
implements PreparableReloadListener {
    private boolean hasBeenInitialized;

    public ResourcePackAwareDynamicTextureProvider() {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    public abstract DynamicTexturePack getDynamicPack();

    public abstract Logger getLogger();

    public abstract boolean hasTexturePackSupport();

    public abstract void regenerateTextures(ResourceManager var1);

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        Stopwatch watch = Stopwatch.createStarted();
        boolean resourcePackSupport = this.hasTexturePackSupport();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.generateStaticAssetsOnStartup(manager);
            if (!resourcePackSupport) {
                VanillaResourceManager vanillaManager = new VanillaResourceManager();
                this.regenerateTextures(vanillaManager);
                vanillaManager.close();
            }
        }
        if (resourcePackSupport) {
            this.regenerateTextures(manager);
        }
        this.getLogger().info("Generated runtime client resources for pack {} in: {} seconds", (Object)this.getDynamicPack().m_8017_(), (Object)watch.elapsed().toSeconds());
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected NativeImage recolorFromVanilla(ResourceManager manager, NativeImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (NativeImage scribbleMask = this.readImage(manager, vanillaMask);){
            NativeImage nativeImage;
            block14: {
                NativeImage template = this.readImage(manager, templateTexture);
                try {
                    Respriter respriter = new Respriter(template);
                    nativeImage = respriter.recolorImage(vanillaTexture, scribbleMask);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return nativeImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean alreadyHasTextureAtLocation(ResourceManager manager, ResourceLocation res) {
        ResourceLocation fullRes = RPUtils.resPath(res, RPUtils.ResType.TEXTURES);
        if (manager.m_7165_(fullRes)) {
            boolean bl;
            block9: {
                Resource r = manager.m_142591_(fullRes);
                try {
                    boolean bl2 = bl = !r.m_7816_().equals(this.getDynamicPack().m_8017_());
                    if (r == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                r.close();
            }
            return bl;
        }
        return false;
    }

    protected NativeImage readImage(ResourceManager manager, ResourceLocation resourceLocation) throws IOException {
        return NativeImage.m_85058_((InputStream)manager.m_142591_(resourceLocation).m_6679_());
    }

    @Nullable
    protected RPUtils.StaticResource getResOrLog(ResourceManager manager, ResourceLocation location) {
        try {
            return new RPUtils.StaticResource(manager.m_142591_(location));
        }
        catch (Exception e) {
            this.getLogger().error("Could not find resource {} while generating dynamic resource pack", (Object)location);
            return null;
        }
    }
}

