/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import pro.mikey.xray.Configuration;
import pro.mikey.xray.XRay;
import pro.mikey.xray.keybinding.KeyBindings;
import pro.mikey.xray.store.BlockStore;
import pro.mikey.xray.store.DiscoveryStorage;
import pro.mikey.xray.store.GameBlockStore;
import pro.mikey.xray.utils.BlockData;
import pro.mikey.xray.xray.Controller;

public class ClientController {
    public static GameBlockStore gameBlockStore = new GameBlockStore();
    public static DiscoveryStorage blockStore = new DiscoveryStorage();

    public static void setup() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientController::onSetup);
        eventBus.addListener(ClientController::onLoadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC);
        MinecraftForge.EVENT_BUS.register(KeyBindings.class);
    }

    private static void onSetup(FMLCommonSetupEvent event) {
        XRay.logger.debug(I18n.m_118938_((String)"xray.debug.init", (Object[])new Object[0]));
        KeyBindings.setup();
        List<BlockData.SerializableBlockData> data = blockStore.read();
        if (data.isEmpty()) {
            return;
        }
        ArrayList<BlockData> map = BlockStore.getFromSimpleBlockList(data);
        Controller.getBlockStore().setStore(map);
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        gameBlockStore.populate();
    }
}

