/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import pro.mikey.xray.ClientController;
import pro.mikey.xray.Configuration;
import pro.mikey.xray.XRay;
import pro.mikey.xray.gui.GuiHelp;
import pro.mikey.xray.gui.manage.GuiAddBlock;
import pro.mikey.xray.gui.manage.GuiBlockList;
import pro.mikey.xray.gui.manage.GuiEdit;
import pro.mikey.xray.gui.utils.GuiBase;
import pro.mikey.xray.gui.utils.ScrollingList;
import pro.mikey.xray.gui.utils.SupportButton;
import pro.mikey.xray.keybinding.KeyBindings;
import pro.mikey.xray.store.BlockStore;
import pro.mikey.xray.utils.BlockData;
import pro.mikey.xray.xray.Controller;

public class GuiSelectionScreen
extends GuiBase {
    private static final ResourceLocation CIRCLE = new ResourceLocation(XRay.PREFIX_GUI + "circle.png");
    private Button distButtons;
    private EditBox search;
    public ItemRenderer render;
    private String lastSearch = "";
    private ArrayList<BlockData> itemList;
    private ArrayList<BlockData> originalList;
    private ScrollingBlockList scrollList;

    public GuiSelectionScreen() {
        super(true);
        this.setSideTitle(I18n.m_118938_((String)"xray.single.tools", (Object[])new Object[0]));
        if (ClientController.blockStore.created) {
            List<BlockData.SerializableBlockData> blocks = ClientController.blockStore.populateDefault();
            Controller.getBlockStore().setStore(BlockStore.getFromSimpleBlockList(blocks));
            ClientController.blockStore.created = false;
        }
        this.itemList = new ArrayList<BlockData>(Controller.getBlockStore().getStore().values());
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.originalList = this.itemList;
    }

    public void m_7856_() {
        if (this.getMinecraft().f_91074_ == null) {
            return;
        }
        this.render = this.f_96542_;
        this.m_6702_().clear();
        this.scrollList = new ScrollingBlockList(this.getWidth() / 2 - 37, this.getHeight() / 2 + 10, 203, 185, this.itemList, this);
        this.m_142416_((GuiEventListener)this.scrollList);
        this.search = new EditBox(this.getFontRender(), this.getWidth() / 2 - 137, this.getHeight() / 2 - 105, 202, 18, TextComponent.f_131282_);
        this.search.m_94190_(true);
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 60, 120, 20, I18n.m_118938_((String)"xray.input.add", (Object[])new Object[0]), "xray.tooltips.add_block", button -> {
            this.getMinecraft().f_91074_.m_6915_();
            this.getMinecraft().m_91152_((Screen)new GuiBlockList());
        }));
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 38, 120, 20, I18n.m_118938_((String)"xray.input.add_hand", (Object[])new Object[0]), "xray.tooltips.add_block_in_hand", button -> {
            this.getMinecraft().f_91074_.m_6915_();
            ItemStack handItem = this.getMinecraft().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (!(handItem.m_41720_() instanceof BlockItem)) {
                this.getMinecraft().f_91074_.m_5661_((Component)new TextComponent("[XRay] " + I18n.m_118938_((String)"xray.message.invalid_hand", (Object[])new Object[]{handItem.m_41786_().getString()})), false);
                return;
            }
            this.getMinecraft().m_91152_((Screen)new GuiAddBlock(((BlockItem)handItem.m_41720_()).m_40614_(), GuiSelectionScreen::new));
        }));
        this.m_142416_((GuiEventListener)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 16, 120, 20, I18n.m_118938_((String)"xray.input.add_look", (Object[])new Object[0]), "xray.tooltips.add_block_looking_at", button -> {
            LocalPlayer player = this.getMinecraft().f_91074_;
            if (this.getMinecraft().f_91073_ == null || player == null) {
                return;
            }
            this.m_7379_();
            try {
                Vec3 look = player.m_20154_();
                Vec3 start = new Vec3((double)player.m_142538_().m_123341_(), (double)((float)player.m_142538_().m_123342_() + player.m_20192_()), (double)player.m_142538_().m_123343_());
                Vec3 end = new Vec3((double)player.m_142538_().m_123341_() + look.f_82479_ * 100.0, (double)((float)player.m_142538_().m_123342_() + player.m_20192_()) + look.f_82480_ * 100.0, (double)player.m_142538_().m_123343_() + look.f_82481_ * 100.0);
                ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
                BlockHitResult result = this.getMinecraft().f_91073_.m_45547_(context);
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    Block lookingAt = this.getMinecraft().f_91073_.m_8055_(result.m_82425_()).m_60734_();
                    player.m_6915_();
                    this.getMinecraft().m_91152_((Screen)new GuiAddBlock(lookingAt, GuiSelectionScreen::new));
                } else {
                    player.m_5661_((Component)new TextComponent("[XRay] " + I18n.m_118938_((String)"xray.message.nothing_infront", (Object[])new Object[0])), false);
                }
            }
            catch (NullPointerException ex) {
                player.m_5661_((Component)new TextComponent("[XRay] " + I18n.m_118938_((String)"xray.message.thats_odd", (Object[])new Object[0])), false);
            }
        }));
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 6, 120, 20, I18n.m_118938_((String)"xray.input.show-lava", (Object[])new Object[]{Controller.isLavaActive()}), "xray.tooltips.show_lava", button -> {
            Controller.toggleLava();
            button.m_93666_((Component)new TranslatableComponent("xray.input.show-lava", new Object[]{Controller.isLavaActive()}));
        });
        this.m_142416_((GuiEventListener)this.distButtons);
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 36, 120, 20, I18n.m_118938_((String)"xray.input.distance", (Object[])new Object[]{Controller.getVisualRadius()}), "xray.tooltips.distance", button -> {
            Controller.incrementCurrentDist();
            button.m_93666_((Component)new TranslatableComponent("xray.input.distance", new Object[]{Controller.getVisualRadius()}));
        });
        this.m_142416_((GuiEventListener)this.distButtons);
        this.m_142416_((GuiEventListener)new Button(this.getWidth() / 2 + 79, this.getHeight() / 2 + 58, 60, 20, (Component)new TranslatableComponent("xray.single.help"), button -> {
            this.getMinecraft().f_91074_.m_6915_();
            this.getMinecraft().m_91152_((Screen)new GuiHelp());
        }));
        this.m_142416_((GuiEventListener)new Button(this.getWidth() / 2 + 79 + 62, this.getHeight() / 2 + 58, 59, 20, (Component)new TranslatableComponent("xray.single.close"), button -> this.m_7379_()));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.search.m_93696_() && keyCode == KeyBindings.toggleGui.getKey().m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void updateSearch() {
        if (this.lastSearch.equals(this.search.m_94155_())) {
            return;
        }
        if (this.search.m_94155_().equals("")) {
            this.itemList = this.originalList;
            this.scrollList.updateEntries(this.itemList);
            this.lastSearch = "";
            return;
        }
        this.itemList = this.originalList.stream().filter(b -> b.getEntryName().toLowerCase().contains(this.search.m_94155_().toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.scrollList.updateEntries(this.itemList);
        this.lastSearch = this.search.m_94155_();
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.search != null) {
            this.search.m_94120_();
        }
        this.updateSearch();
    }

    public boolean m_6375_(double x, double y, int mouse) {
        if (this.search.m_6375_(x, y, mouse)) {
            this.m_7522_((GuiEventListener)this.search);
        }
        if (mouse == 1 && this.distButtons.m_5953_(x, y)) {
            Controller.decrementCurrentDist();
            this.distButtons.m_93666_((Component)new TranslatableComponent("xray.input.distance", new Object[]{Controller.getVisualRadius()}));
            this.distButtons.m_7435_(Minecraft.m_91087_().m_91106_());
        }
        return super.m_6375_(x, y, mouse);
    }

    @Override
    public void renderExtra(PoseStack stack, int x, int y, float partialTicks) {
        this.search.m_6305_(stack, x, y, partialTicks);
        this.scrollList.m_6305_(stack, x, y, partialTicks);
        if (!this.search.m_93696_() && this.search.m_94155_().equals("")) {
            Minecraft.m_91087_().f_91062_.m_92750_(stack, I18n.m_118938_((String)"xray.single.search", (Object[])new Object[0]), (float)this.getWidth() / 2.0f - 130.0f, (float)this.getHeight() / 2.0f - 101.0f, Color.GRAY.getRGB());
        }
    }

    public void m_7861_() {
        Configuration.store.radius.save();
        ClientController.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        Controller.requestBlockFinder(true);
        super.m_7861_();
    }

    static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;
        public GuiSelectionScreen parent;

        ScrollingBlockList(int x, int y, int width, int height, List<BlockData> blocks, GuiSelectionScreen parent) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
            this.parent = parent;
        }

        public void setSelected(@Nullable BlockSlot entry, int mouse) {
            if (entry == null) {
                return;
            }
            if (GuiSelectionScreen.m_96638_()) {
                Minecraft.m_91087_().f_91074_.m_6915_();
                Minecraft.m_91087_().m_91152_((Screen)new GuiEdit(entry.block));
                return;
            }
            Controller.getBlockStore().toggleDrawing(entry.block);
            ClientController.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        }

        void updateEntries(List<BlockData> blocks) {
            this.m_93516_();
            blocks.forEach(block -> this.m_7085_(new BlockSlot((BlockData)block, this)));
        }

        public static class BlockSlot
        extends AbstractSelectionList.Entry<BlockSlot> {
            BlockData block;
            ScrollingBlockList parent;

            BlockSlot(BlockData block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public BlockData getBlock() {
                return this.block;
            }

            public void m_6311_(PoseStack stack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                BlockData blockData = this.block;
                Font font = Minecraft.m_91087_().f_91062_;
                font.m_92883_(stack, blockData.getEntryName(), (float)(left + 35), (float)(top + 7), 0xFFFFFF);
                font.m_92883_(stack, blockData.isDrawing() ? "Enabled" : "Disabled", (float)(left + 35), (float)(top + 17), blockData.isDrawing() ? Color.GREEN.getRGB() : Color.RED.getRGB());
                Lighting.m_84931_();
                Minecraft.m_91087_().m_91291_().m_115203_(blockData.getItemStack(), left + 8, top + 7);
                Lighting.m_84930_();
                if (mouseX > left && mouseX < left + entryWidth && mouseY > top && mouseY < top + entryHeight && mouseY < this.parent.getTop() + this.parent.getHeight() && mouseY > this.parent.getTop()) {
                    this.parent.parent.m_96617_(stack, Language.m_128107_().m_128112_(Arrays.asList(new TranslatableComponent("xray.tooltips.edit1"), new TranslatableComponent("xray.tooltips.edit2"))), left + 15, entryIdx == this.parent.m_6702_().size() - 1 ? top - (entryHeight - 20) : top + (entryHeight + 15));
                }
                Color color = new Color(blockData.getColor());
                stack.m_85836_();
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157456_((int)0, (ResourceLocation)CIRCLE);
                RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                GuiComponent.m_93133_((PoseStack)stack, (int)(left + entryWidth - 35), (int)((int)((float)top + (float)entryHeight / 2.0f - 9.0f)), (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
                RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                GuiComponent.m_93133_((PoseStack)stack, (int)(left + entryWidth - 33), (int)((int)((float)top + (float)entryHeight / 2.0f - 7.0f)), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69461_();
                stack.m_85849_();
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int mouse) {
                this.parent.setSelected(this, mouse);
                return false;
            }
        }
    }

    static final class SupportButtonInner
    extends SupportButton {
        public SupportButtonInner(int widthIn, int heightIn, int width, int height, String text, String i18nKey, Button.OnPress onPress) {
            super(widthIn, heightIn, width, height, (Component)new TextComponent(text), new TranslatableComponent(i18nKey), onPress);
        }
    }
}

