/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.mikey.xray.XRay;
import pro.mikey.xray.utils.BlockData;

public class DiscoveryStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path STORE_FILE = Minecraft.m_91087_().f_91069_.toPath().resolve(String.format("config/%s/block_store.json", "xray"));
    private static final Random RANDOM = new Random();
    private static final Gson PRETTY_JSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean created = false;

    public DiscoveryStorage() {
        if (Files.exists(STORE_FILE, new LinkOption[0])) {
            return;
        }
        boolean createdPath = STORE_FILE.getParent().toFile().mkdirs();
        if (!createdPath) {
            LOGGER.error("Failed to create dirs for {}", (Object)STORE_FILE);
            return;
        }
        this.created = true;
        this.write((List<BlockData.SerializableBlockData>)new ArrayList<BlockData.SerializableBlockData>());
        LOGGER.info("Created block store");
    }

    public void write(ArrayList<BlockData> blockData) {
        ArrayList<BlockData.SerializableBlockData> simpleBlockData = new ArrayList<BlockData.SerializableBlockData>();
        blockData.forEach(e -> simpleBlockData.add(new BlockData.SerializableBlockData(e.getEntryName(), e.getBlockName(), e.getColor(), e.isDrawing(), e.getOrder())));
        this.write((List<BlockData.SerializableBlockData>)simpleBlockData);
    }

    private void write(List<BlockData.SerializableBlockData> simpleBlockData) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(STORE_FILE.toFile()));){
            PRETTY_JSON.toJson(simpleBlockData, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write json data to {}", (Object)STORE_FILE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BlockData.SerializableBlockData> read() {
        if (!Files.exists(STORE_FILE, new LinkOption[0])) {
            return new ArrayList<BlockData.SerializableBlockData>();
        }
        try {
            Type type = new TypeToken<List<BlockData.SerializableBlockData>>(){}.getType();
            try (BufferedReader reader = new BufferedReader(new FileReader(STORE_FILE.toFile()));){
                List list = (List)PRETTY_JSON.fromJson((Reader)reader, type);
                return list;
            }
            catch (JsonSyntaxException ex) {
                XRay.logger.log(Level.ERROR, "Failed to read json data from " + STORE_FILE);
                return new ArrayList<BlockData.SerializableBlockData>();
            }
        }
        catch (IOException e) {
            XRay.logger.log(Level.ERROR, "Failed to read json data from " + STORE_FILE);
        }
        return new ArrayList<BlockData.SerializableBlockData>();
    }

    public List<BlockData.SerializableBlockData> populateDefault() {
        ArrayList<BlockData.SerializableBlockData> oresData = new ArrayList<BlockData.SerializableBlockData>();
        ITagManager blockTags = ForgeRegistries.BLOCKS.tags();
        if (blockTags == null) {
            return List.of();
        }
        int orderTrack = 0;
        for (Block block : blockTags.getTag(Tags.Blocks.ORES)) {
            if (block.getRegistryName() == null) continue;
            oresData.add(new BlockData.SerializableBlockData(new TranslatableComponent(block.m_7705_()).getString(), block.getRegistryName().toString(), (RANDOM.nextInt(255) << 16) + (RANDOM.nextInt(255) << 8) + RANDOM.nextInt(255), false, orderTrack++));
        }
        LOGGER.info("Setting up default ores to the render list");
        this.write((List<BlockData.SerializableBlockData>)oresData);
        return oresData;
    }
}

