/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.xray;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import pro.mikey.xray.Configuration;
import pro.mikey.xray.store.BlockStore;
import pro.mikey.xray.utils.RenderBlockProps;
import pro.mikey.xray.xray.Render;
import pro.mikey.xray.xray.RenderEnqueue;

public class Controller {
    private static final int maxStepsToScan = 5;
    private static boolean isSearching = false;
    public static ArrayList<Block> blackList = new ArrayList<Block>(){
        {
            this.add(Blocks.f_50016_);
            this.add(Blocks.f_50752_);
            this.add(Blocks.f_50069_);
            this.add(Blocks.f_50034_);
            this.add(Blocks.f_50493_);
        }
    };
    private static ChunkPos lastChunkPos = null;
    public static final Set<RenderBlockProps> syncRenderList = Collections.synchronizedSet(new HashSet());
    private static BlockStore blockStore = new BlockStore();
    private static boolean xrayActive = false;
    private static boolean lavaActive = (Boolean)Configuration.store.lavaActive.get();

    public static BlockStore getBlockStore() {
        return blockStore;
    }

    public static boolean isXRayActive() {
        return xrayActive && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    public static void toggleXRay() {
        if (!xrayActive) {
            syncRenderList.clear();
            xrayActive = true;
            Controller.requestBlockFinder(true);
            if (!((Boolean)Configuration.general.showOverlay.get()).booleanValue() && Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("xray.toggle.activated"), false);
            }
        } else {
            if (!((Boolean)Configuration.general.showOverlay.get()).booleanValue() && Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("xray.toggle.deactivated"), false);
            }
            xrayActive = false;
        }
    }

    public static boolean isLavaActive() {
        return lavaActive;
    }

    public static void toggleLava() {
        lavaActive = !lavaActive;
        Configuration.store.lavaActive.set((Object)lavaActive);
    }

    public static int getRadius() {
        return Mth.m_14045_((int)((Integer)Configuration.store.radius.get()), (int)0, (int)5) * 3;
    }

    public static int getHalfRange() {
        return Math.max(0, Controller.getRadius() / 2);
    }

    public static int getVisualRadius() {
        return Math.max(1, Controller.getRadius());
    }

    public static void incrementCurrentDist() {
        if ((Integer)Configuration.store.radius.get() < 5) {
            Configuration.store.radius.set((Object)((Integer)Configuration.store.radius.get() + 1));
        } else {
            Configuration.store.radius.set((Object)0);
        }
    }

    public static void decrementCurrentDist() {
        if ((Integer)Configuration.store.radius.get() > 0) {
            Configuration.store.radius.set((Object)((Integer)Configuration.store.radius.get() - 1));
        } else {
            Configuration.store.radius.set((Object)5);
        }
    }

    private static boolean playerHasMoved() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        ChunkPos plyChunkPos = Minecraft.m_91087_().f_91074_.m_146902_();
        int range = Controller.getHalfRange();
        return lastChunkPos == null || plyChunkPos.f_45578_ > Controller.lastChunkPos.f_45578_ + range || plyChunkPos.f_45578_ < Controller.lastChunkPos.f_45578_ - range || plyChunkPos.f_45579_ > Controller.lastChunkPos.f_45579_ + range || plyChunkPos.f_45579_ < Controller.lastChunkPos.f_45579_ - range;
    }

    private static void updatePlayerPosition() {
        lastChunkPos = Minecraft.m_91087_().f_91074_.m_146902_();
    }

    public static synchronized void requestBlockFinder(boolean force) {
        if (Controller.isXRayActive() && (force || Controller.playerHasMoved()) && !isSearching) {
            Controller.updatePlayerPosition();
            Util.m_183991_().execute(() -> {
                isSearching = true;
                Set<RenderBlockProps> c = RenderEnqueue.blockFinder();
                syncRenderList.clear();
                syncRenderList.addAll(c);
                isSearching = false;
                Render.requestedRefresh = true;
            });
        }
    }
}

