/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.xray.xray;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.Pair;
import pro.mikey.xray.utils.BlockData;
import pro.mikey.xray.utils.RenderBlockProps;
import pro.mikey.xray.xray.Controller;
import pro.mikey.xray.xray.Render;

public class RenderEnqueue {
    public static Set<RenderBlockProps> blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty()) {
            return new HashSet<RenderBlockProps>();
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (world == null || player == null) {
            return new HashSet<RenderBlockProps>();
        }
        HashSet<RenderBlockProps> renderQueue = new HashSet<RenderBlockProps>();
        int range = Controller.getHalfRange();
        int cX = player.m_146902_().f_45578_;
        int cZ = player.m_146902_().f_45579_;
        for (int i = cX - range; i <= cX + range; ++i) {
            int chunkStartX = i << 4;
            for (int j = cZ - range; j <= cZ + range; ++j) {
                int chunkStartZ = j << 4;
                int height = Arrays.stream(world.m_6325_(i, j).m_7103_()).filter(Objects::nonNull).mapToInt(LevelChunkSection::m_63017_).max().orElse(0);
                for (int k = chunkStartX; k < chunkStartX + 16; ++k) {
                    for (int l = chunkStartZ; l < chunkStartZ + 16; ++l) {
                        for (int m = world.m_141937_(); m < height + 16; ++m) {
                            Pair<BlockData, UUID> dataWithUUID;
                            ResourceLocation block;
                            BlockPos pos = new BlockPos(k, m, l);
                            BlockState currentState = world.m_8055_(pos);
                            FluidState currentFluid = currentState.m_60819_();
                            if ((currentFluid.m_76152_() == Fluids.f_76195_ || currentFluid.m_76152_() == Fluids.f_76194_) && Controller.isLavaActive()) {
                                renderQueue.add(new RenderBlockProps(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0xFF0000));
                                continue;
                            }
                            if (Controller.blackList.contains(currentState.m_60734_()) || (block = currentState.m_60734_().getRegistryName()) == null || (dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getKey() == null || !((BlockData)dataWithUUID.getKey()).isDrawing()) continue;
                            renderQueue.add(new RenderBlockProps(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ((BlockData)dataWithUUID.getKey()).getColor()));
                        }
                    }
                }
            }
        }
        return renderQueue;
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.isXRayActive() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        if (!add) {
            boolean removed = Controller.syncRenderList.remove(new RenderBlockProps(pos, 0));
            if (removed) {
                Render.requestedRefresh = true;
            }
            return;
        }
        ResourceLocation block = state.m_60734_().getRegistryName();
        if (block == null) {
            return;
        }
        Pair<BlockData, UUID> dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString());
        if (dataWithUUID == null || dataWithUUID.getKey() == null || !((BlockData)dataWithUUID.getKey()).isDrawing()) {
            return;
        }
        Controller.syncRenderList.add(new RenderBlockProps(pos, ((BlockData)dataWithUUID.getKey()).getColor()));
        Render.requestedRefresh = true;
    }
}

