/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FABFunctions {
    private static final Map<Block, Map<Level, List<BlockPos>>> getMapFromBlock = new HashMap<Block, Map<Level, List<BlockPos>>>();
    private static final Map<Level, Map<Date, BlockPos>> timeoutpositions = new HashMap<Level, Map<Date, BlockPos>>();

    private static List<BlockEntity> getBlockEntitiesAroundPosition(Level world, BlockPos pos, Integer radius) {
        ArrayList<BlockEntity> blockentities = new ArrayList<BlockEntity>();
        int chunkradius = (int)Math.ceil((double)radius.intValue() / 16.0);
        int chunkPosX = pos.m_123341_() >> 4;
        int chunkPosZ = pos.m_123343_() >> 4;
        for (int x = chunkPosX - chunkradius; x < chunkPosX + chunkradius; ++x) {
            for (int z = chunkPosZ - chunkradius; z < chunkPosZ + chunkradius; ++z) {
                for (BlockEntity be : world.m_6325_(x, z).m_62954_().values()) {
                    if (blockentities.contains(be)) continue;
                    blockentities.add(be);
                }
            }
        }
        return blockentities;
    }

    public static List<BlockPos> getAllTileEntityPositionsNearbyEntity(BlockEntityType<?> tetype, Integer radius, Level world, Entity entity) {
        BlockPos entitypos = entity.m_142538_();
        ArrayList<BlockPos> nearbypositions = new ArrayList<BlockPos>();
        List<BlockEntity> blockentities = FABFunctions.getBlockEntitiesAroundPosition(world, entitypos, radius);
        for (BlockEntity loadedtileentity : blockentities) {
            BlockEntityType loadedtiletype = loadedtileentity.m_58903_();
            if (loadedtiletype == null || !loadedtiletype.equals(tetype)) continue;
            BlockPos ltepos = loadedtileentity.m_58899_();
            Vec3 vec3 = entity.m_20182_();
            if (!ltepos.m_123314_(new Vec3i(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_), (double)radius.intValue())) continue;
            nearbypositions.add(loadedtileentity.m_58899_());
        }
        return nearbypositions;
    }

    /*
     * WARNING - void declaration
     */
    public static BlockPos getRequestedBlockAroundEntitySpawn(Block rawqueryblock, Integer radius, Double radiusmodifier, Level world, Entity entity) {
        Map<Object, Object> timeouts;
        List<Object> currentblocks;
        Block requestedblock = FABFunctions.processCommonBlock(rawqueryblock);
        Map<Level, List<BlockPos>> worldblocks = FABFunctions.getMap(requestedblock);
        BlockPos epos = entity.m_142538_();
        Vec3i removeblockpos = null;
        if (worldblocks.containsKey(world)) {
            currentblocks = worldblocks.get(world);
            ArrayList<BlockPos> cbtoremove = new ArrayList<BlockPos>();
            for (BlockPos blockPos : currentblocks) {
                if (!world.m_7726_().m_5563_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!world.m_8055_(blockPos).m_60734_().equals(requestedblock)) {
                    cbtoremove.add(blockPos);
                    continue;
                }
                if (!blockPos.m_123314_((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                return blockPos.m_7949_();
            }
            if (cbtoremove.size() > 0) {
                for (BlockPos blockPos : cbtoremove) {
                    currentblocks.remove(blockPos);
                }
            }
        } else {
            currentblocks = new ArrayList();
        }
        if (timeoutpositions.containsKey(world)) {
            timeouts = timeoutpositions.get(world);
            ArrayList<Date> totoremove = new ArrayList<Date>();
            if (timeouts.size() > 0) {
                Date date = new Date();
                for (Date date2 : timeouts.keySet()) {
                    long ms;
                    BlockPos toepos = (BlockPos)timeouts.get(date2);
                    if (removeblockpos != null && toepos.m_123314_(removeblockpos, 64.0)) {
                        totoremove.add(date2);
                    }
                    if ((ms = date.getTime() - date2.getTime()) > (long)((Integer)ConfigHandler.COLLECTIVE.findABlockcheckAroundEntitiesDelayMs.get()).intValue()) {
                        totoremove.add(date2);
                        continue;
                    }
                    if (!toepos.m_123314_((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                    return null;
                }
            }
            if (totoremove.size() > 0) {
                for (Date date : totoremove) {
                    timeouts.remove(date);
                }
            }
        } else {
            timeouts = new HashMap();
        }
        if (GlobalVariables.blocksWithTileEntity.containsKey(requestedblock)) {
            List<BlockEntity> blockentities = FABFunctions.getBlockEntitiesAroundPosition(world, epos, radius);
            BlockEntityType<?> blockEntityType = GlobalVariables.blocksWithTileEntity.get(requestedblock);
            for (BlockEntity blockEntity : blockentities) {
                BlockPos ltepos;
                BlockEntityType loadedtiletype = blockEntity.m_58903_();
                if (loadedtiletype == null || !loadedtiletype.equals(blockEntityType) || !(ltepos = blockEntity.m_58899_()).m_123314_((Vec3i)epos, (double)radius.intValue() * radiusmodifier)) continue;
                currentblocks.add(ltepos.m_7949_());
                worldblocks.put(world, currentblocks);
                getMapFromBlock.put(requestedblock, worldblocks);
                return ltepos.m_7949_();
            }
        } else {
            void var12_22;
            int r = radius;
            int n = -r;
            while (var12_22 < r) {
                void var13_28;
                int n2 = -r;
                while (var13_28 < r) {
                    for (int i = -r; i < r; ++i) {
                        BlockPos cpos = epos.m_142385_((int)var12_22).m_142390_((int)var13_28).m_6630_(i);
                        BlockState state = world.m_8055_(cpos);
                        if (!state.m_60734_().equals(requestedblock)) continue;
                        currentblocks.add(cpos.m_7949_());
                        worldblocks.put(world, currentblocks);
                        getMapFromBlock.put(requestedblock, worldblocks);
                        return cpos.m_7949_();
                    }
                    ++var13_28;
                }
                ++var12_22;
            }
        }
        timeouts.put(new Date(), epos.m_7949_());
        timeoutpositions.put(world, timeouts);
        return null;
    }

    public static BlockPos updatePlacedBlock(Block requestedblock, BlockPos bpos, Level world) {
        BlockState state = world.m_8055_(bpos);
        if (state.m_60734_().equals(requestedblock)) {
            Map<Level, List<BlockPos>> worldblocks = FABFunctions.getMap(requestedblock);
            List<Object> currentblocks = worldblocks.containsKey(world) ? worldblocks.get(world) : new ArrayList();
            if (!currentblocks.contains(bpos)) {
                currentblocks.add(bpos);
                worldblocks.put(world, currentblocks);
                getMapFromBlock.put(requestedblock, worldblocks);
            }
            return bpos;
        }
        return null;
    }

    private static Map<Level, List<BlockPos>> getMap(Block requestedblock) {
        Map<Object, Object> worldblocks = getMapFromBlock.containsKey(requestedblock) ? getMapFromBlock.get(requestedblock) : new HashMap();
        return worldblocks;
    }

    private static Block processCommonBlock(Block requestedblock) {
        Block blocktoreturn = requestedblock;
        if (requestedblock instanceof StandingSignBlock || requestedblock instanceof WallSignBlock) {
            blocktoreturn = Blocks.f_50095_;
        }
        return blocktoreturn;
    }
}

