/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class BlackboardBakedModel
implements IDynamicBakedModel {
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ItemOverrides overrides;
    private final BakedModel back;

    public BlackboardBakedModel(BakedModel unbaked, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
        this.back = unbaked;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(this.owner.resolveTexture("particle"));
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.getQuads(state, direction, random, data));
        if (data != EmptyModelData.INSTANCE && state != null && direction == null) {
            Direction dir = (Direction)state.m_61143_((Property)BlackboardBlock.FACING);
            BlackboardTextureManager.BlackboardKey key = (BlackboardTextureManager.BlackboardKey)data.getData(BlackboardBlockTile.BLACKBOARD);
            if (key != null) {
                quads.addAll(BlackboardTextureManager.INSTANCE.getBlackboardInstance(key).getModel(dir, b -> this.generateQuads((byte[][])b, this.modelTransform)));
            }
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(byte[][] pixels, ModelState modelTransform) {
        TextureAtlasSprite black = this.spriteGetter.apply(this.owner.resolveTexture("black"));
        TextureAtlasSprite white = this.spriteGetter.apply(this.owner.resolveTexture("white"));
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Transformation rotation = modelTransform.m_6189_();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            byte prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Byte current = null;
                if (y < pixels[x].length) {
                    byte b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                int tint = BlackboardBlock.colorFromByte(prevColor);
                TextureAtlasSprite sprite = prevColor == 0 ? black : white;
                quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.6875f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    private static BakedQuad createPixelQuad(float x, float y, float z, float width, float height, TextureAtlasSprite sprite, int color, Transformation transform) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, -1.0f);
        BlackboardBakedModel.applyModelRotation(normal, transform);
        float tu = (float)sprite.m_118405_() * width;
        float tv = (float)sprite.m_118408_() * height;
        float u0 = x * 16.0f;
        float v0 = y * 16.0f;
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122372_((float)normal.m_122239_(), (float)normal.m_122260_(), (float)normal.m_122269_()));
        BlackboardBakedModel.putVertex(builder, normal, x + width, y + height, z, u0 + tu, v0 + tv, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x + width, y, z, u0 + tu, v0, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x, y, z, u0, v0, sprite, color, transform);
        BlackboardBakedModel.putVertex(builder, normal, x, y + height, z, u0, v0 + tv, sprite, color, transform);
        return builder.build();
    }

    private static void putVertex(BakedQuadBuilder builder, Vector3f normal, float x, float y, float z, float u, float v, TextureAtlasSprite sprite, int color, Transformation transformation) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    Vector3f posV = new Vector3f(x, y, z);
                    BlackboardBakedModel.applyModelRotation(posV, transformation);
                    builder.put(j, new float[]{posV.m_122239_(), posV.m_122260_(), posV.m_122269_(), 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    public static void applyModelRotation(Vector3f pPos, Transformation pTransform) {
        if (pTransform != Transformation.m_121093_()) {
            BlackboardBakedModel.rotateVertexBy(pPos, new Vector3f(0.5f, 0.5f, 0.5f), pTransform.m_121104_());
        }
    }

    private static void rotateVertexBy(Vector3f pPos, Vector3f pOrigin, Matrix4f pTransform) {
        Vector4f vector4f = new Vector4f(pPos.m_122239_() - pOrigin.m_122239_(), pPos.m_122260_() - pOrigin.m_122260_(), pPos.m_122269_() - pOrigin.m_122269_(), 1.0f);
        vector4f.m_123607_(pTransform);
        pPos.m_122245_(vector4f.m_123601_() + pOrigin.m_122239_(), vector4f.m_123615_() + pOrigin.m_122260_(), vector4f.m_123616_() + pOrigin.m_122269_());
    }
}

