/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BlackboardTextureManager {
    public static BlackboardTextureManager INSTANCE = null;
    private final TextureManager textureManager;
    private long lastID = 0L;
    private final LoadingCache<BlackboardKey, TextureInstance> blackboardTextures = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<BlackboardKey, TextureInstance>(){

        public TextureInstance load(BlackboardKey key) {
            return null;
        }
    });

    public long bindNextID() {
        return ++this.lastID;
    }

    public static void init(TextureManager textureManager) {
        INSTANCE = new BlackboardTextureManager(textureManager);
    }

    public BlackboardTextureManager(TextureManager textureManager) {
        this.textureManager = textureManager;
    }

    public TextureInstance getBlackboardInstance(BlackboardKey key) {
        TextureInstance textureInstance = (TextureInstance)this.blackboardTextures.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new TextureInstance(BlackboardBlockTile.unpackPixels(key.values), this.bindNextID());
            this.blackboardTextures.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public TextureInstance getBlackboardInstance(long[] packed) {
        return this.getBlackboardInstance(new BlackboardKey(packed));
    }

    public TextureInstance getBlackboardInstance(BlackboardBlockTile tile) {
        return this.getBlackboardInstance(tile.getTextureKey());
    }

    private static int getColoredPixel(byte i, int x, int y) {
        int offset = i > 0 ? 16 : 0;
        int tint = BlackboardBlock.colorFromByte(i);
        TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
        TextureAtlasSprite sprite = textureMap.m_118316_(Textures.BLACKBOARD_TEXTURE);
        return BlackboardTextureManager.getTintedColor(sprite, x, y, offset, tint);
    }

    private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
        if (sprite == null || sprite.m_118415_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int pixel = sprite.getPixelRGBA(0, Math.min(sprite.m_118405_() - 1, x + offset), Math.min(sprite.m_118408_() - 1, y));
        int totalB = pixel >> 16 & 0xFF;
        int totalG = pixel >> 8 & 0xFF;
        int totalR = pixel & 0xFF;
        return NativeImage.m_84992_((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
    }

    public class TextureInstance
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final byte[][] pixels;
        private final long id;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;
        private Map<Direction, List<BakedQuad>> models = new HashMap<Direction, List<BakedQuad>>();

        private TextureInstance(byte[][] pixels, long id) {
            this.pixels = pixels;
            this.id = id;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            for (int y = 0; y < this.pixels.length && y < 16; ++y) {
                for (int x = 0; x < this.pixels[y].length && x < 16; ++x) {
                    this.texture.m_117991_().m_84988_(x, y, BlackboardTextureManager.getColoredPixel(this.pixels[x][y], x, y));
                }
            }
            this.texture.m_117985_();
            this.textureLocation = BlackboardTextureManager.this.textureManager.m_118490_("blackboard/" + Long.toHexString(this.id), this.texture);
            this.renderType = RenderType.m_110446_((ResourceLocation)this.textureLocation);
        }

        @Nonnull
        public List<BakedQuad> getModel(Direction dir, Function<byte[][], List<BakedQuad>> modelFactory) {
            if (!this.models.containsKey(dir)) {
                this.models.put(dir, modelFactory.apply(this.pixels));
            }
            return this.models.get(dir);
        }

        @Nonnull
        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nonnull
        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }

    public static class BlackboardKey {
        private final long[] values;

        public BlackboardKey(long[] packed) {
            this.values = packed;
        }

        public BlackboardKey(byte[][] pixels) {
            this.values = BlackboardBlockTile.packPixels(pixels);
        }

        public byte[][] unpackValues() {
            return BlackboardBlockTile.unpackPixels(this.values);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            BlackboardKey key = (BlackboardKey)another;
            return Arrays.equals(this.values, key.values);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

