/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class RendererUtil {
    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                RendererUtil.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, new Random(), 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }

    public static void renderBlockModel(ResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        blockRenderer.m_110937_().m_111067_(matrixStack.m_85850_(), buffer.m_6299_(cutout ? Sheets.m_110790_() : Sheets.m_110789_()), null, blockRenderer.m_110907_().m_110881_().getModel(modelLocation), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        RendererUtil.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, int combinedOverlayIn, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        RendererUtil.addCube(builder, matrixStackIn, uOff, vOff, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY, boolean wrap) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_() + atlasScaleU * uOff;
        float minV = sprite.m_118411_() + atlasScaleV * vOff;
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * h;
        float maxV2 = minV + atlasScaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        float hh = h / 2.0f;
        if (up) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minU, minV, maxU, maxV2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            RendererUtil.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minU, minV, maxU, maxV2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        float inc = 0.0f;
        if (wrap) {
            inc = atlasScaleU * w;
        }
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minU, minV, maxU, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minU + inc, minV, maxU + inc, maxV, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minU + 2.0f * inc, minV, maxU + 2.0f * inc, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minU + 3.0f * inc, minV, maxU + 3.0f * inc, maxV, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static int setColorForAge(float age, float phase) {
        float a = (age + phase) % 1.0f;
        float[] col = ColorHelper.getBubbleColor(a);
        return FastColor.ARGB32.m_13660_((int)255, (int)((int)(col[0] * 255.0f)), (int)((int)(col[1] * 255.0f)), (int)((int)(col[2] * 255.0f)));
    }

    public static void renderBubble(VertexConsumer builder, PoseStack matrixStackIn, float w, TextureAtlasSprite sprite, int combinedLightIn, boolean flippedY, BlockPos pos, Level level, float partialTicks) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * w;
        float maxV2 = minV + atlasScaleV * w;
        long t = level == null ? System.currentTimeMillis() / 50L : level.m_46467_();
        float time = ((float)Math.floorMod((long)(pos.m_123341_() * 7 + pos.m_123342_() * 9 + pos.m_123343_() * 13) + t, 100L) + partialTicks) / 100.0f;
        int cUnw = RendererUtil.setColorForAge(time, 0.0f);
        int cUne = RendererUtil.setColorForAge(time, 0.15f);
        int cUse = RendererUtil.setColorForAge(time, 0.55f);
        int cUsw = RendererUtil.setColorForAge(time, 0.35f);
        int cDnw = RendererUtil.setColorForAge(time, 0.45f);
        int cDne = RendererUtil.setColorForAge(time, 0.85f);
        int cDse = RendererUtil.setColorForAge(time, 1.0f);
        int cDsw = RendererUtil.setColorForAge(time, 0.65f);
        float amp = ClientConfigs.cached.BUBBLE_BLOCK_WOBBLE;
        w -= 2.0f * amp;
        float unw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.0f)));
        float une = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.25f)));
        float use = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.5f)));
        float usw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.75f)));
        float dnw = use;
        float dne = usw;
        float dse = unw;
        float dsw = une;
        float l = w / 2.0f;
        RendererUtil.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, minU, maxV2, cUsw, lu, lv, 0.0f, 1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + use, l + use, l + use, maxU, maxV2, cUse, lu, lv, 0.0f, 1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 0.0f, 1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, 0.0f, 1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, minU, maxV2, cDnw, lu, lv, 0.0f, -1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, maxU, maxV2, cDne, lu, lv, 0.0f, -1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, maxU, minV, cDse, lu, lv, 0.0f, -1.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, minU, minV, cDsw, lu, lv, 0.0f, -1.0f, 0.0f);
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        RendererUtil.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, minU, maxV, cDne, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, maxU, maxV, cDnw, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, maxU, minV, cUnw, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + une, l + une, -l - une, minU, minV, cUne, lu, lv, 0.0f, 0.0f, 1.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dnw, -l - dnw, -l - dnw, minU, maxV, cDnw, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, maxU, maxV, cDsw, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, maxU, minV, cUsw, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, -1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - dsw, -l - dsw, l + dsw, minU, maxV, cDsw, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, maxU, maxV, cDse, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + use, l + use, l + use, maxU, minV, cUse, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addVert(builder, matrixStackIn, -l - usw, l + usw, l + usw, minU, minV, cUsw, lu, lv, 0.0f, 0.0f, -1.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + dse, -l - dse, l + dse, minU, maxV, cDse, lu, lv, 1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + dne, -l - dne, -l - dne, maxU, maxV, cDne, lu, lv, 1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 1.0f, 0.0f, 0.0f);
        RendererUtil.addVert(builder, matrixStackIn, l + use, l + use, l + use, minU, minV, cUse, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_193479_(color).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        u0 = RendererUtil.getRelativeU(sprite, u0);
        u1 = RendererUtil.getRelativeU(sprite, u1);
        v0 = RendererUtil.getRelativeV(sprite, v0);
        v1 = RendererUtil.getRelativeV(sprite, v1);
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        RendererUtil.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        RendererUtil.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz, TextureAtlasSprite sprite) {
        builder.m_85982_(matrixStackIn.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, a).m_7421_(RendererUtil.getRelativeU(sprite, u), RendererUtil.getRelativeV(sprite, v)).m_86008_(OverlayTexture.f_118083_).m_7120_(lu, lv).m_85977_(matrixStackIn.m_85850_().m_85864_(), nx, ny, nz).m_5752_();
    }

    public static float getRelativeU(TextureAtlasSprite sprite, float u) {
        float f = sprite.m_118410_() - sprite.m_118409_();
        return sprite.m_118409_() + f * u;
    }

    public static float getRelativeV(TextureAtlasSprite sprite, float v) {
        float f = sprite.m_118412_() - sprite.m_118411_();
        return sprite.m_118411_() + f * v;
    }

    public static void renderFish(VertexConsumer builder, PoseStack matrixStackIn, float wo, float ho, int fishType, int combinedLightIn) {
        int textW = 64;
        int textH = 32;
        int fishW = 5;
        int fishH = 4;
        int fishv = fishType % (textH / fishH);
        int fishu = fishType / (textH / fishH);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(Textures.FISHIES_TEXTURE);
        float w = (float)fishW / (float)textW;
        float h = (float)fishH / (float)textH;
        float hw = 4.0f * w / 2.0f;
        float hh = 2.0f * h / 2.0f;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasscaleV = sprite.m_118412_() - sprite.m_118411_();
        float minu = sprite.m_118409_() + atlasscaleU * (float)fishu * w;
        float minv = sprite.m_118411_() + atlasscaleV * (float)fishv * h;
        float maxu = atlasscaleU * w + minu;
        float maxv = atlasscaleV * h + minv;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), -hh + ho, wo, minu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), -hh + ho, -wo, maxu, maxv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, -hw + Math.abs(wo / 2.0f), hh + ho, -wo, maxu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                RendererUtil.addVert(builder, matrixStackIn, hw - Math.abs(wo / 2.0f), hh + ho, wo, minu, minv, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
                matrixStackIn.m_85845_(RotHlpr.Y180);
                float temp = minu;
                minu = maxu;
                maxu = temp;
            }
            lu = 240;
            minu += atlasscaleU / 2.0f;
            maxu += atlasscaleU / 2.0f;
        }
    }

    private static int getFormatLength(TextureAtlasSprite sprite) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        return builder.getVertexFormat().m_86017_();
    }

    public static List<BakedQuad> swapSprite(List<BakedQuad> quads, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> newList = new ArrayList<BakedQuad>();
        for (BakedQuad q : quads) {
            TextureAtlasSprite oldSprite = q.m_173410_();
            int formatLength = RendererUtil.getFormatLength(oldSprite);
            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
            for (int i = 0; i < v.length / formatLength; ++i) {
                float originalU = Float.intBitsToFloat(v[i * formatLength + 4]);
                float originalV = Float.intBitsToFloat(v[i * formatLength + 5]);
                v[i * formatLength + 4] = Float.floatToIntBits(originalU - oldSprite.m_118409_() + sprite.m_118409_());
                v[i * formatLength + 5] = Float.floatToIntBits(originalV - oldSprite.m_118411_() + sprite.m_118411_());
            }
            newList.add(new BakedQuad(v, q.m_111305_(), q.m_111306_(), sprite, q.m_111307_()));
        }
        return newList;
    }

    public static void transformVertices(int[] v, TextureAtlasSprite sprite, Matrix3f transform) {
        int formatLength = RendererUtil.getFormatLength(sprite);
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]) - 0.5f;
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]) - 0.5f;
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]) - 0.5f;
            Vector3f vector3f = new Vector3f(originalX, originalY, originalZ);
            vector3f.m_122249_(transform);
            v[i * formatLength] = Float.floatToIntBits(vector3f.m_122239_() + 0.5f);
            v[i * formatLength + 1] = Float.floatToIntBits(vector3f.m_122260_() + 0.5f);
            v[i * formatLength + 2] = Float.floatToIntBits(vector3f.m_122269_() + 0.5f);
        }
    }

    public static void rotateVerticesY(int[] v, TextureAtlasSprite sprite, Rotation rot) {
        Matrix3f matrix = rot.m_55948_().m_174948_();
        RendererUtil.transformVertices(v, sprite, matrix);
    }

    public static void moveVertices(int[] v, Direction dir, float amount, TextureAtlasSprite sprite) {
        int formatLength = RendererUtil.getFormatLength(sprite);
        int axis = dir.m_122434_().ordinal();
        float step = amount * (float)dir.m_122421_().m_122540_();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float original = Float.intBitsToFloat(v[i * formatLength + axis]);
            v[i * formatLength + axis] = Float.floatToIntBits(original + step);
        }
    }

    public static void moveVertices(int[] v, float x, float y, float z, TextureAtlasSprite sprite) {
        int formatLength = RendererUtil.getFormatLength(sprite);
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX + x);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY + y);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ + z);
        }
    }

    public static void scaleVertices(int[] v, float scale, TextureAtlasSprite sprite) {
        int formatLength = RendererUtil.getFormatLength(sprite);
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX * scale);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY * scale);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ * scale);
        }
    }

    public static void transformVertices(int[] v, PoseStack stack, TextureAtlasSprite sprite) {
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.m_123607_(stack.m_85850_().m_85861_());
        RendererUtil.moveVertices(v, vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), sprite);
    }

    public static void renderGuiItemRelative(ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, Boolean> movement) {
        RendererUtil.renderGuiItemRelative(stack, x, y, renderer, movement, 0xF000F0, OverlayTexture.f_118083_);
    }

    public static void renderGuiItemRelative(ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, Boolean> movement, int combinedLight, int pCombinedOverlay) {
        boolean flag;
        BakedModel model = renderer.m_174264_(stack, null, null, 0);
        renderer.f_115093_ += 50.0f;
        Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, (double)(100.0f + renderer.f_115093_));
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        ItemTransforms.TransformType pTransformType = ItemTransforms.TransformType.GUI;
        matrixStack.m_85836_();
        if (stack.m_150930_(Items.f_42713_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
        } else if (stack.m_150930_(Items.f_151059_)) {
            model = renderer.m_115103_().m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
        }
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)matrixStack, (BakedModel)model, (ItemTransforms.TransformType)pTransformType, (boolean)false);
        movement.accept(matrixStack, model.m_7539_() && stack.m_41720_() != ModRegistry.FLUTE_ITEM.get());
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        if (!(model.m_7521_() || stack.m_150930_(Items.f_42713_) && !flag)) {
            if (model.isLayered()) {
                ForgeHooksClient.drawItemLayered((ItemRenderer)renderer, (BakedModel)model, (ItemStack)stack, (PoseStack)matrixStack, (MultiBufferSource)bufferSource, (int)combinedLight, (int)pCombinedOverlay, (boolean)true);
            } else {
                VertexConsumer vertexconsumer;
                RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true);
                if (stack.m_150930_(Items.f_42522_) && stack.m_41790_()) {
                    matrixStack.m_85836_();
                    PoseStack.Pose pose = matrixStack.m_85850_();
                    pose.m_85861_().m_27630_(0.5f);
                    vertexconsumer = ItemRenderer.m_115207_((MultiBufferSource)bufferSource, (RenderType)rendertype, (PoseStack.Pose)pose);
                    matrixStack.m_85849_();
                } else {
                    vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_());
                }
                renderer.m_115189_(model, stack, combinedLight, pCombinedOverlay, matrixStack, vertexconsumer);
            }
        } else {
            RenderProperties.get((ItemStack)stack).getItemStackRenderer().m_108829_(stack, pTransformType, matrixStack, (MultiBufferSource)bufferSource, combinedLight, pCombinedOverlay);
        }
        matrixStack.m_85849_();
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        renderer.f_115093_ -= 50.0f;
    }
}

