/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.api.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CandleSkullBlock
extends AbstractCandleBlock
implements EntityBlock {
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        map.defaultReturnValue((Object)ImmutableList.of());
        map.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5)));
        map.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 0.94, 0.5), (Object)new Vec3(0.625, 1.0, 0.44)));
        map.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.813, 0.625), (Object)new Vec3(0.375, 0.94, 0.5), (Object)new Vec3(0.56, 1.0, 0.44)));
        map.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 0.813, 0.56), (Object)new Vec3(0.625, 0.94, 0.56), (Object)new Vec3(0.375, 0.94, 0.375), (Object)new Vec3(0.56, 1.0, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
    });
    protected static final VoxelShape BASE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape ONE_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private static final VoxelShape TWO_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0));
    private static final VoxelShape THREE_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)11.0));
    private static final VoxelShape FOUR_AABB = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)10.0));
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final IntegerProperty CANDLES = BlockStateProperties.f_155994_;
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;

    public CandleSkullBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(CandleBlock.f_152793_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(1))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{CANDLES, LIT, ROTATION});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CandleSkullBlockTile(pPos, pState);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)((Object)object);
            List loot = ((BlockState)tile.getCandle().m_61124_((Property)CANDLES, (Comparable)((Integer)state.m_61143_((Property)CANDLES)))).m_60724_(builder);
            BlockEntity skullTile = tile.getSkullTile();
            if (skullTile != null) {
                BlockState skull = skullTile.m_58900_();
                builder = builder.m_78984_(LootContextParams.f_81462_, (Object)skullTile);
                loot.addAll(skull.m_60724_(builder));
            }
            return loot;
        }
        return super.m_7381_(state, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult hitResult, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            double y = hitResult.m_82450_().f_82480_;
            boolean up = y % (double)((int)y) > 0.5;
            return up ? tile.getCandle().m_60734_().getCloneItemStack(state, hitResult, world, pos, player) : tile.getSkullItem();
        }
        return super.getCloneItemStack(state, hitResult, world, pos, player);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Integer)pState.m_61143_((Property)CANDLES)) {
            default -> ONE_AABB;
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
        };
    }

    protected Iterable<Vec3> m_142199_(BlockState pState) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)pState.m_61143_((Property)CANDLES)).intValue());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHit) {
        if (player.m_150110_().f_35938_) {
            Item item2;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_204117_(ItemTags.f_144319_) && (item2 = stack.m_41720_()) instanceof BlockItem) {
                CandleSkullBlockTile tile;
                BlockEntity blockEntity;
                BlockItem blockItem = (BlockItem)item2;
                int count = (Integer)state.m_61143_((Property)CANDLES);
                if (count < 4 && ServerConfigs.cached.SKULL_CANDLES_MULTIPLE && (blockEntity = level.m_7702_(pos)) instanceof CandleSkullBlockTile && (tile = (CandleSkullBlockTile)blockEntity).getCandle().m_60734_().m_5456_() == stack.m_41720_()) {
                    SoundType sound = blockItem.m_40614_().m_49966_().getSoundType((LevelReader)level, pos, (Entity)player);
                    level.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, stack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(count + 1)), 2);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            }
            if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                Item item3 = stack.m_41720_();
                if (item3 instanceof FlintAndSteelItem || stack.m_204117_(ModTags.FIRE_SOURCES)) {
                    if (this.lightUp((Entity)player, state, pos, (LevelAccessor)level, ILightable.FireSound.FLINT_AND_STEEL)) {
                        stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                } else if (item3 instanceof FireChargeItem) {
                    if (this.lightUp((Entity)player, state, pos, (LevelAccessor)level, ILightable.FireSound.FIRE_CHANGE)) {
                        stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                } else if (item3 instanceof PotionItem && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                    CandleSkullBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                    Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (stack.m_41619_()) {
                CandleSkullBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSound sound) {
        state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        if (!world.m_5776_()) {
            world.m_7731_(pos, state, 11);
            sound.play(world, pos);
        }
        world.m_142346_(player, GameEvent.f_157792_, pos);
        return true;
    }
}

