/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.HangingSignBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HangingSignBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final EnumProperty<BlockProperties.SignAttachment> ATTACHMENT = BlockProperties.SIGN_ATTACHMENT;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public final WoodType woodType;

    public HangingSignBlock(BlockBehaviour.Properties properties, WoodType woodType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(ATTACHMENT, (Comparable)((Object)BlockProperties.SignAttachment.BLOCK_BLOCK))).m_61124_(AXIS, (Comparable)Direction.Axis.Z));
        this.woodType = woodType;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!level.f_46443_) {
            HangingSignBlockTile tile;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HangingSignBlockTile && (tile = (HangingSignBlockTile)blockEntity).isAccessibleBy(player)) {
                ItemStack handItem = player.m_21120_(handIn);
                InteractionResult result = tile.textHolder.playerInteract(level, pos, player, handIn, tile);
                if (result != InteractionResult.PASS) {
                    return result;
                }
                if (handIn == InteractionHand.MAIN_HAND) {
                    if (!tile.isEmpty()) {
                        if (handItem.m_41619_()) {
                            ItemStack it = tile.removeStackFromSlot(0);
                            player.m_21008_(handIn, it);
                            tile.m_6596_();
                            return InteractionResult.CONSUME;
                        }
                    } else {
                        if (!handItem.m_41619_()) {
                            ItemStack it = handItem.m_41777_();
                            it.m_41764_(1);
                            tile.setItems((NonNullList<ItemStack>)NonNullList.m_122780_((int)1, (Object)it));
                            if (!player.m_7500_()) {
                                handItem.m_41774_(1);
                            }
                            level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.95f);
                            tile.m_6596_();
                        } else {
                            tile.sendOpenGuiPacket(level, pos, player);
                        }
                        return InteractionResult.CONSUME;
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockProperties.SignAttachment attachment = (BlockProperties.SignAttachment)((Object)state.m_61143_(ATTACHMENT));
        if (attachment == BlockProperties.SignAttachment.CEILING) {
            return worldIn.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)worldIn, pos.m_7494_(), Direction.DOWN);
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        if (axis == Direction.Axis.X) {
            return worldIn.m_8055_(pos.m_142300_(Direction.EAST)).m_60767_().m_76333_() || worldIn.m_8055_(pos.m_142300_(Direction.WEST)).m_60767_().m_76333_();
        }
        return worldIn.m_8055_(pos.m_142300_(Direction.NORTH)).m_60767_().m_76333_() || worldIn.m_8055_(pos.m_142300_(Direction.SOUTH)).m_60767_().m_76333_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        BlockProperties.SignAttachment attachment = (BlockProperties.SignAttachment)((Object)stateIn.m_61143_(ATTACHMENT));
        if (attachment == BlockProperties.SignAttachment.CEILING) {
            if (facing == Direction.UP) {
                return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
            }
            return stateIn;
        }
        return facing.m_122434_() == stateIn.m_61143_(AXIS) ? (!stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : HangingSignBlock.getConnectedState(stateIn, facingState, worldIn, facingPos, facing.m_122424_())) : stateIn;
    }

    public static BlockState getConnectedState(BlockState state, BlockState facingState, LevelAccessor world, BlockPos pos, Direction clickedFace) {
        BlockProperties.BlockAttachment attachment = BlockProperties.BlockAttachment.get(facingState, pos, (LevelReader)world, clickedFace);
        BlockProperties.SignAttachment old = (BlockProperties.SignAttachment)((Object)state.m_61143_(ATTACHMENT));
        return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)old.withAttachment(clickedFace.m_122421_() == Direction.AxisDirection.NEGATIVE, attachment)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(AXIS) == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ATTACHMENT});
        builder.m_61104_(new Property[]{AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState s = super.m_5573_(context);
        if (s == null) {
            return null;
        }
        Direction clickedFace = context.m_43719_();
        Direction.Axis axis = clickedFace.m_122434_();
        if (clickedFace.m_122434_() == Direction.Axis.Y) {
            axis = context.m_8125_().m_122428_().m_122434_();
            s = (BlockState)s.m_61124_(AXIS, (Comparable)axis);
            if (clickedFace == Direction.DOWN) {
                s = (BlockState)s.m_61124_(ATTACHMENT, (Comparable)((Object)BlockProperties.SignAttachment.CEILING));
                return s;
            }
        } else {
            s = (BlockState)s.m_61124_(AXIS, (Comparable)axis);
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (dir.m_122434_() != axis) continue;
            BlockPos relative = blockpos.m_142300_(dir.m_122424_());
            BlockState facingState = world.m_8055_(relative);
            s = HangingSignBlock.getConnectedState(s, facingState, (LevelAccessor)world, relative, dir);
        }
        return s;
    }

    public boolean m_5568_() {
        return true;
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity2) {
        return BlockPathTypes.OPEN;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof HangingSignBlockTile) {
                HangingSignBlockTile tile = (HangingSignBlockTile)blockEntity;
                ItemStack itemstack = tile.getStackInSlot(0);
                ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                world.m_7967_((Entity)itementity);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new HangingSignBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtils.getTicker(pBlockEntityType, (BlockEntityType)ModRegistry.HANGING_SIGN_TILE.get(), pLevel.f_46443_ ? SwayingBlockTile::clientTick : null);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtils.addOptionalOwnership(placer, worldIn, pos);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        if (pRot != Rotation.CLOCKWISE_180) {
            return (BlockState)pState.m_61122_(AXIS);
        }
        return pState;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity2) {
        super.m_7892_(state, world, pos, entity2);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SwayingBlockTile) {
            SwayingBlockTile tile = (SwayingBlockTile)blockEntity;
            tile.hitByEntity(entity2, state);
        }
    }
}

