/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.entities.FallingLanternEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightableLanternBlock
extends LanternBlock {
    public static final VoxelShape SHAPE_DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    public static final VoxelShape SHAPE_UP = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0));
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public LightableLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_153460_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_153459_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_153475_, BlockPos p_153476_, CollisionContext p_153477_) {
        return (Boolean)state.m_61143_((Property)f_153459_) != false ? SHAPE_UP : SHAPE_DOWN;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Optional<BlockState> optional = LightableLanternBlock.toggleLight(state, worldIn, pos, player, handIn);
        if (optional.isPresent()) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, optional.get());
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Optional<BlockState> toggleLight(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        if (player.m_150110_().f_35938_ && handIn == InteractionHand.MAIN_HAND) {
            ItemStack item2 = player.m_21120_(handIn);
            if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                if (item2.m_41720_() instanceof FlintAndSteelItem) {
                    worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, worldIn.m_5822_().nextFloat() * 0.4f + 0.8f);
                    state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
                    item2.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                    return Optional.of(state);
                }
                if (item2.m_41720_() instanceof FireChargeItem) {
                    worldIn.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (worldIn.m_5822_().nextFloat() - worldIn.m_5822_().nextFloat()) * 0.2f + 1.0f);
                    state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
                    if (!player.m_7500_()) {
                        item2.m_41774_(1);
                    }
                    return Optional.of(state);
                }
            } else if (item2.m_41619_()) {
                worldIn.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
                return Optional.of(state);
            }
        }
        return Optional.empty();
    }

    public static boolean canSurviveCeiling(BlockState state, BlockPos pos, LevelReader worldIn) {
        if (!RopeBlock.isSupportingCeiling(pos.m_7494_(), worldIn) && worldIn instanceof Level) {
            Level l = (Level)worldIn;
            if (l.m_8055_(pos).m_60713_(state.m_60734_())) {
                return LightableLanternBlock.createFallingLantern(state, pos, l);
            }
            return false;
        }
        return true;
    }

    public static boolean createFallingLantern(BlockState state, BlockPos pos, Level level) {
        if (FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_() && state.m_61138_((Property)LanternBlock.f_153459_)) {
            double maxY = state.m_60808_((BlockGetter)level, (BlockPos)pos).m_83215_().f_82292_;
            state = (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(false));
            double yOffset = maxY - state.m_60808_((BlockGetter)level, (BlockPos)pos).m_83215_().f_82292_;
            FallingLanternEntity.fall(level, pos, state, yOffset);
            return true;
        }
        return false;
    }
}

