/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.enchantedbooks.EnchantedBookRedesignRenderer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BookPileBlockTile
extends ItemDisplayTile {
    public final boolean horizontal;
    private float enchantPower = 0.0f;
    public final List<VisualBook> books = new ArrayList<VisualBook>();
    private static final BookColor[] VALID_RANDOM_COLORS = new BookColor[]{BookColor.BROWN, BookColor.ORANGE, BookColor.YELLOW, BookColor.RED, BookColor.DARK_GREEN, BookColor.LIME, BookColor.TEAL, BookColor.BLUE, BookColor.PURPLE};

    public BookPileBlockTile(BlockPos pos, BlockState state) {
        this(pos, state, false);
    }

    public BookPileBlockTile(BlockPos pos, BlockState state, boolean horizontal) {
        super((BlockEntityType)ModRegistry.BOOK_PILE_TILE.get(), pos, state, 4);
        this.horizontal = horizontal;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("EnchantPower", this.enchantPower);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.enchantPower = compound.m_128457_("EnchantPower");
    }

    public void updateTileOnInventoryChanged() {
        int b = (int)this.m_7086_().stream().filter(i -> !i.m_41619_()).count();
        if (b != (Integer)this.m_58900_().m_61143_((Property)BookPileBlock.BOOKS)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BookPileBlock.BOOKS, (Comparable)Integer.valueOf(b)), 2);
        }
        this.enchantPower = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            Item item2 = this.m_8020_(i2).m_41720_();
            if (BookPileBlock.isNormalBook(item2)) {
                this.enchantPower += ServerConfigs.cached.BOOK_POWER / 4.0f;
                continue;
            }
            if (BookPileBlock.isQuarkTome(item2)) {
                this.enchantPower += ServerConfigs.cached.BOOK_POWER / 4.0f * 2.0f;
                continue;
            }
            if (!BookPileBlock.isEnchantedBook(item2)) continue;
            this.enchantPower += ServerConfigs.cached.ENCHANTED_BOOK_POWER / 4.0f;
        }
    }

    public void updateClientVisualsOnLoad() {
        ItemStack stack;
        this.books.clear();
        ArrayList<BookColor> colors = new ArrayList<BookColor>(Arrays.asList(VALID_RANDOM_COLORS));
        for (int i = 0; i < 4 && !(stack = this.m_8020_(i)).m_41619_(); ++i) {
            BookColor last = i == 0 ? null : this.books.get((int)(i - 1)).color;
            this.books.add(i, new VisualBook(stack, this.f_58858_, i, colors, last));
        }
    }

    public float getEnchantPower() {
        return this.enchantPower;
    }

    protected Component m_6820_() {
        return new TextComponent("block.supplementaries.book_pile");
    }

    public static enum BookColor {
        BROWN(DyeColor.BROWN, 1),
        WHITE(DyeColor.WHITE, 1),
        BLACK(DyeColor.BLACK, 1),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY),
        GRAY(DyeColor.GRAY),
        ORANGE(DyeColor.ORANGE),
        YELLOW(DyeColor.YELLOW),
        LIME(DyeColor.LIME),
        DARK_GREEN("green", 3129655),
        TEAL("cyan", 1502399),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE),
        BLUE(DyeColor.BLUE),
        PURPLE(DyeColor.PURPLE),
        MAGENTA(DyeColor.MAGENTA),
        PINK(DyeColor.PINK),
        RED(DyeColor.RED);

        private final String name;
        private final float hue;
        private final float angle;

        private BookColor(String s, int rgb, int angle) {
            this.name = s;
            float[] col = ColorHelper.rgbToHsl(rgb);
            this.hue = col[0];
            this.angle = angle < 0 ? this.getAllowedHueShift(col) : (float)Math.max(1, angle);
        }

        private BookColor(DyeColor color, int angle) {
            this(color.m_41065_(), ColorHelper.pack(color.m_41068_()), angle);
        }

        private BookColor(String name, int color) {
            this(name, color, -1);
        }

        private BookColor(DyeColor color) {
            this(color.m_41065_(), ColorHelper.pack(color.m_41068_()), -1);
        }

        public static BookColor byName(String name) {
            for (BookColor c : BookColor.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return BROWN;
        }

        public boolean looksGoodNextTo(BookColor other) {
            float diff = Math.abs(Mth.m_14118_((float)(this.hue * 360.0f), (float)(other.hue * 360.0f)) / 360.0f);
            return diff < (other.angle + this.angle) / 2.0f;
        }

        private float getAllowedHueShift(float[] col) {
            float l = col[2];
            float s = ColorHelper.oneToOneSaturation(col[1], l);
            float minAngle = 0.25f;
            float addAngle = 0.18055555f;
            float distLightSq = 2.0f;
            float distDarkSq = s * s + l * l;
            float distSq = Math.min(1.0f, Math.min(distDarkSq, distLightSq));
            return minAngle + (1.0f - distSq) * addAngle;
        }

        public static BookColor rand(Random r) {
            return BookColor.values()[r.nextInt(BookColor.values().length)];
        }

        public String getName() {
            return this.name;
        }
    }

    public static class VisualBook {
        private final float angle;
        @Nullable
        private final BookColor color;
        private final Material material;
        private final ItemStack stack;
        private final boolean isEnchanted;

        public VisualBook(ItemStack stack, BlockPos pos, int index, List<BookColor> colors, @Nullable BookColor lastColor) {
            this.stack = stack;
            Random rand = new Random(pos.m_121878_());
            for (int j = 0; j < index; ++j) {
                rand.nextInt();
            }
            Item item2 = stack.m_41720_();
            this.angle = (float)((double)rand.nextInt(32) * Math.PI / 16.0);
            if (item2 instanceof BookItem) {
                if (lastColor == null) {
                    this.color = colors.get(rand.nextInt(colors.size()));
                } else {
                    List c = colors.stream().filter(b -> b.looksGoodNextTo(lastColor)).collect(Collectors.toList());
                    this.color = (BookColor)((Object)c.get(rand.nextInt(c.size())));
                }
                colors.remove((Object)this.color);
                this.material = Materials.BOOK_MATERIALS.get((Object)this.color);
                this.isEnchanted = false;
            } else if (item2.getRegistryName().m_135827_().equals("inspirations")) {
                String colName = item2.getRegistryName().m_135815_().replace("_book", "");
                this.color = BookColor.byName(colName);
                this.material = Materials.BOOK_MATERIALS.get((Object)this.color);
                this.isEnchanted = false;
            } else if (BookPileBlock.isWrittenBook(item2)) {
                this.color = null;
                this.material = item2 instanceof WritableBookItem ? Materials.BOOK_AND_QUILL_MATERIAL : Materials.BOOK_WRITTEN_MATERIAL;
                this.isEnchanted = false;
            } else {
                this.color = null;
                this.material = BookPileBlock.isQuarkTome(item2) ? Materials.BOOK_TOME_MATERIAL : Materials.BOOK_ENCHANTED_MATERIAL;
                this.isEnchanted = true;
            }
        }

        public VertexConsumer getBuilder(MultiBufferSource buffer) {
            if (this.isEnchanted && ClientConfigs.cached.BOOK_GLINT) {
                VertexConsumer foilBuilder = null;
                if (CompatHandler.enchantedbookredesign) {
                    foilBuilder = EnchantedBookRedesignRenderer.getColoredFoil(this.stack, buffer);
                }
                if (foilBuilder == null) {
                    foilBuilder = buffer.m_6299_(RenderType.m_110496_());
                }
                return VertexMultiConsumer.m_86168_((VertexConsumer)foilBuilder, (VertexConsumer)this.material.m_119194_(buffer, RenderType::m_110446_));
            }
            return this.material.m_119194_(buffer, RenderType::m_110446_);
        }

        public float getAngle() {
            return this.angle;
        }

        public boolean isEnchanted() {
            return this.isEnchanted;
        }
    }
}

