/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.client.gui.HangingSignGui;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.util.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class HangingSignBlockTile
extends SwayingBlockTile
implements IMapDisplay,
ITextHolderProvider,
IOwnerProtected {
    public static final int MAX_LINES = 7;
    public final WoodType woodType;
    private UUID owner = null;
    public TextHolder textHolder;
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public HangingSignBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.HANGING_SIGN_TILE.get(), pos, state);
        this.textHolder = new TextHolder(7);
        Block block2 = this.m_58900_().m_60734_();
        if (block2 instanceof HangingSignBlock) {
            HangingSignBlock block3 = (HangingSignBlock)block2;
            this.woodType = block3.woodType;
        } else {
            this.woodType = WoodType.OAK_WOOD_TYPE;
        }
    }

    @Override
    public boolean isAlwaysFast() {
        return ClientConfigs.cached.FAST_SIGNS;
    }

    @Override
    public boolean isFlipped() {
        return this.m_58900_().m_61143_(HangingSignBlock.AXIS) != Direction.Axis.Z;
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    @Override
    public void openScreen(Level level, BlockPos pos, Player player) {
        HangingSignGui.open(this);
    }

    @Override
    public ItemStack getMapStack() {
        return this.getStackInSlot(0);
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        super.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.stacks = NonNullList.m_122780_((int)this.getSizeInventory(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        this.textHolder.read(compound);
        this.loadOwner(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
        this.textHolder.write(tag);
        this.saveOwner(tag);
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int getSizeInventory() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public ItemStack removeStackFromSlot(int index) {
        return ContainerHelper.m_18966_(this.getItems(), (int)index);
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    @Override
    public Vec3i getNormalRotationAxis(BlockState state) {
        return state.m_61143_(HangingSignBlock.AXIS) == Direction.Axis.X ? new Vec3i(0, 0, -1) : new Vec3i(1, 0, 0);
    }

    static {
        maxSwingAngle = 45.0f;
        minSwingAngle = 2.5f;
        maxPeriod = 25.0f;
        angleDamping = 150.0f;
        periodDamping = 100.0f;
    }
}

