/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.configs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.RequestConfigReloadPacket;
import net.mehvahdjukaar.supplementaries.common.network.SyncConfigsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ConfigHandler {
    public static ModConfig CLIENT_CONFIG_OBJECT;
    public static ModConfig SERVER_CONFIG_OBJECT;
    public static ModConfig REGISTRY_CONFIG_OBJECT;
    public static final Predicate<Object> STRING_CHECK;
    public static final Predicate<Object> LIST_STRING_CHECK;
    public static final Predicate<Object> COLOR_CHECK;

    public static void registerBus(IEventBus modBus) {
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        CLIENT_CONFIG_OBJECT = new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigs.CLIENT_SPEC, modContainer);
        SERVER_CONFIG_OBJECT = new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)ServerConfigs.SERVER_SPEC, modContainer);
        REGISTRY_CONFIG_OBJECT = new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)RegistryConfigs.REGISTRY_CONFIG, modContainer, "supplementaries-registry.toml");
        modContainer.addConfig(CLIENT_CONFIG_OBJECT);
        modContainer.addConfig(SERVER_CONFIG_OBJECT);
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedOut);
        modBus.addListener(ConfigHandler::reloadConfigsEvent);
    }

    public static void openModConfigs() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)((ConfigGuiHandler.ConfigGuiFactory)((ModContainer)ModList.get().getModContainerById("supplementaries").get()).getCustomExtension(ConfigGuiHandler.ConfigGuiFactory.class).get()).screenFunction().apply(mc, mc.f_91080_));
    }

    public static <T> void resetConfigValue(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<T> value) {
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(value.getPath());
        if (valueSpec == null) {
            Supplementaries.LOGGER.throwing((Throwable)new Exception("No such config value: " + value + "in config " + spec));
        }
        value.set(valueSpec.getDefault());
    }

    public static <T> T safeGetListString(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<T> value) {
        Object o = value.get();
        try {
            Object object = o;
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn((Object)new Exception("Resetting erroneous config value: " + value + "in config " + spec));
            ConfigHandler.resetConfigValue(spec, value);
        }
        return (T)value.get();
    }

    public static void reloadConfigsEvent(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ServerConfigs.SERVER_SPEC) {
            ConfigHandler.sendSyncedConfigsToAllPlayers();
            ServerConfigs.cached.refresh();
        } else if (event.getConfig().getSpec() == ClientConfigs.CLIENT_SPEC) {
            ClientConfigs.cached.refresh();
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_) {
            ConfigHandler.syncServerConfigs((ServerPlayer)event.getPlayer());
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().f_19853_.f_46443_) {
            ServerConfigs.cached.refresh();
        }
    }

    public static Path getServerConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("supplementaries-common.toml").toAbsolutePath();
    }

    public static void clientRequestServerConfigReload() {
        NetworkHandler.INSTANCE.sendToServer((Object)new RequestConfigReloadPacket());
    }

    public static void sendSyncedConfigsToAllPlayers() {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            PlayerList playerList = currentServer.m_6846_();
            for (ServerPlayer player : playerList.m_11314_()) {
                ConfigHandler.syncServerConfigs(player);
            }
        }
    }

    public static void syncServerConfigs(ServerPlayer player) {
        try {
            byte[] configData = Files.readAllBytes(ConfigHandler.getServerConfigPath());
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncConfigsPacket(configData));
        }
        catch (IOException e) {
            Supplementaries.LOGGER.error("supplementaries: Failed to sync common configs", (Throwable)e);
        }
    }

    static {
        STRING_CHECK = o -> o instanceof String;
        LIST_STRING_CHECK = s -> {
            if (s instanceof List) {
                return ((Collection)s).stream().allMatch(o -> o instanceof String);
            }
            return false;
        };
        COLOR_CHECK = s -> {
            try {
                Integer.parseUnsignedInt(((String)s).replace("0x", ""), 16);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    public static class CachedConfigValue<T, C extends ForgeConfigSpec.ConfigValue<T>> {
        private T cached;
        private final C config;

        public CachedConfigValue(C config) {
            this.config = config;
            this.refresh();
        }

        public T get() {
            return this.cached;
        }

        public void refresh() {
            this.cached = this.config.get();
        }
    }
}

