/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.world.data.map.CMDreg;
import net.mehvahdjukaar.supplementaries.common.world.generation.structure.StructureLocator;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.village.VillagerTradesEvent;

public class AdventurerMapsHandler {
    private static final int SEARCH_RADIUS = 100;
    private static final List<TradeData> CUSTOM_MAPS_TRADES = new ArrayList<TradeData>();
    private static final Map<TagKey<ConfiguredStructureFeature<?, ?>>, Pair<CustomDecorationType<?, ?>, Integer>> DEFAULT_STRUCTURE_MARKERS = new HashMap();

    private static Pair<CustomDecorationType<?, ?>, Integer> getVanillaMarker(Holder<ConfiguredStructureFeature<?, ?>> structure) {
        for (Map.Entry<TagKey<ConfiguredStructureFeature<?, ?>>, Pair<CustomDecorationType<?, ?>, Integer>> v : DEFAULT_STRUCTURE_MARKERS.entrySet()) {
            if (!structure.m_203656_(v.getKey())) continue;
            return v.getValue();
        }
        return Pair.of((Object)MapDecorationHandler.GENERIC_STRUCTURE_TYPE, (Object)-1);
    }

    private static Pair<CustomDecorationType<?, ?>, Integer> getVanillaMarker(TagKey<ConfiguredStructureFeature<?, ?>> tag) {
        return DEFAULT_STRUCTURE_MARKERS.getOrDefault(tag, Pair.of((Object)MapDecorationHandler.GENERIC_STRUCTURE_TYPE, (Object)-1));
    }

    public static void loadCustomTrades() {
        if (!CUSTOM_MAPS_TRADES.isEmpty()) {
            return;
        }
        try {
            List<? extends List<String>> tradeData = ConfigHandler.safeGetListString(ServerConfigs.SERVER_SPEC, ServerConfigs.tweaks.CUSTOM_ADVENTURER_MAPS_TRADES);
            for (List<String> list : tradeData) {
                int s = list.size();
                if (s <= 0) continue;
                try {
                    String res = list.get(0);
                    if (res.isEmpty()) continue;
                    ResourceLocation structure = new ResourceLocation(res);
                    int level = 2;
                    int minPrice = 7;
                    int maxPrice = 13;
                    String mapName = null;
                    int mapColor = 0xFFFFFF;
                    ResourceLocation marker = null;
                    if (s > 1) {
                        level = Integer.parseInt(list.get(1));
                    }
                    if (level < 1 || level > 5) {
                        Supplementaries.LOGGER.warn("skipping configs 'custom_adventurer_maps' (" + list + "): invalid level, must be between 1 and 5");
                        continue;
                    }
                    if (s > 2) {
                        minPrice = Integer.parseInt(list.get(2));
                    }
                    if (s > 3) {
                        maxPrice = Integer.parseInt(list.get(3));
                    }
                    if (s > 4) {
                        mapName = list.get(4);
                    }
                    if (s > 5) {
                        mapColor = Integer.parseInt(list.get(5).replace("0x", ""), 16);
                    }
                    if (s > 6) {
                        marker = new ResourceLocation(list.get(6));
                    }
                    CUSTOM_MAPS_TRADES.add(new TradeData(structure, level, minPrice, maxPrice, mapName, mapColor, marker));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("wrong formatting for configs 'custom_adventurer_maps'(" + list + "), skipping it :" + e);
                }
            }
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps', skipping them.");
        }
    }

    public static void addTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_) {
            Int2ObjectMap trades = event.getTrades();
            for (TradeData data : CUSTOM_MAPS_TRADES) {
                if (data == null) continue;
                try {
                    ((List)trades.get(data.level)).add(new AdventureMapTrade(data));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("failed to load custom adventurer map trade map for structure " + data.structure.toString());
                }
            }
            if (((Boolean)ServerConfigs.tweaks.RANDOM_ADVENTURER_MAPS.get()).booleanValue()) {
                ((List)trades.get(2)).add(new RandomAdventureMapTrade());
            }
        }
    }

    public static ItemStack createStructureMap(Level world, BlockPos pos, ResourceLocation structureName, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        TagKey destination = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)structureName);
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos toPos = serverLevel.m_207561_(destination, pos, 100, true);
            if (toPos == null) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = MapItem.m_42886_((Level)world, (int)toPos.m_123341_(), (int)toPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)stack);
            if (structureName.m_135815_().equals("ocean_monument")) {
                MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MONUMENT);
            } else if (structureName.m_135815_().equals("woodland_mansion")) {
                MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
            } else {
                int color;
                Pair<CustomDecorationType<?, ?>, Integer> decoration = AdventurerMapsHandler.getVanillaMarker(destination);
                int n = color = mapColor == 0xFFFFFF ? (Integer)decoration.getSecond() : mapColor;
                if (mapMarker == null) {
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (CustomDecorationType)((CustomDecorationType)decoration.getFirst()), (int)color);
                } else {
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (ResourceLocation)mapMarker, (int)color);
                }
            }
            TranslatableComponent name = new TranslatableComponent((String)(mapName == null ? "filled_map." + structureName.m_135815_().toLowerCase(Locale.ROOT) : mapName));
            stack.m_41714_((Component)name);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    static {
        DEFAULT_STRUCTURE_MARKERS.put(ConfiguredStructureTags.f_207639_, Pair.of(CMDreg.SHIPWRECK_TYPE, (Object)3416079));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.IGLOO, Pair.of(CMDreg.IGLOO_TYPE, (Object)10075586));
        DEFAULT_STRUCTURE_MARKERS.put(ConfiguredStructureTags.f_207640_, Pair.of(CMDreg.RUINED_PORTAL_TYPE, (Object)6238389));
        DEFAULT_STRUCTURE_MARKERS.put(ConfiguredStructureTags.f_207637_, Pair.of(CMDreg.VILLAGE_TYPE, (Object)12224341));
        DEFAULT_STRUCTURE_MARKERS.put(ConfiguredStructureTags.f_207641_, Pair.of(CMDreg.OCEAN_RUIN_TYPE, (Object)3828045));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.PILLAGER_OUTPOST, Pair.of(CMDreg.PILLAGER_OUTPOST_TYPE, (Object)0x1F1100));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.DESERT_PYRAMID, Pair.of(CMDreg.DESERT_PYRAMID_TYPE, (Object)8416575));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.JUNGLE_TEMPLE, Pair.of(CMDreg.JUNGLE_TEMPLE_TYPE, (Object)5400120));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.BASTION_REMNANT, Pair.of(CMDreg.BASTION_TYPE, (Object)2894127));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.END_CITY, Pair.of(CMDreg.END_CITY_TYPE, (Object)10253227));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.SWAMP_HUT, Pair.of(CMDreg.SWAMP_HUT_TYPE, (Object)1786143));
        DEFAULT_STRUCTURE_MARKERS.put(ModTags.NETHER_FORTRESS, Pair.of(CMDreg.NETHER_FORTRESS, (Object)3934219));
        DEFAULT_STRUCTURE_MARKERS.put(ConfiguredStructureTags.f_207638_, Pair.of(CMDreg.MINESHAFT_TYPE, (Object)0x808080));
    }

    private record TradeData(ResourceLocation structure, int level, int minPrice, int maxPrice, @Nullable String mapName, int mapColor, @Nullable ResourceLocation marker) {
    }

    private static class AdventureMapTrade
    implements VillagerTrades.ItemListing {
        public final TradeData tradeData;

        private AdventureMapTrade(TradeData data) {
            this.tradeData = data;
        }

        public MerchantOffer m_5670_(@Nonnull Entity entity2, @Nonnull Random random) {
            int i = Math.max(1, random.nextInt(Math.max(1, this.tradeData.maxPrice - this.tradeData.minPrice)) + this.tradeData.minPrice);
            ItemStack itemstack = AdventurerMapsHandler.createStructureMap(entity2.f_19853_, entity2.m_142538_(), this.tradeData.structure, this.tradeData.mapName, this.tradeData.mapColor, this.tradeData.marker);
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, Math.max(1, 5 * (this.tradeData.level - 1)), 0.2f);
        }
    }

    private static class RandomAdventureMapTrade
    implements VillagerTrades.ItemListing {
        private RandomAdventureMapTrade() {
        }

        public MerchantOffer m_5670_(@Nonnull Entity entity2, @Nonnull Random random) {
            int maxPrice = 13;
            int minPrice = 7;
            int level = 2;
            int i = random.nextInt(maxPrice - minPrice + 1) + minPrice;
            ItemStack itemstack = this.createMap(entity2.f_19853_, entity2.m_142538_());
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, 5, 0.2f);
        }

        private ItemStack createMap(Level level, BlockPos pos) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!serverLevel.m_142572_().m_129910_().m_5961_().m_64657_()) {
                    return ItemStack.f_41583_;
                }
                Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> found = StructureLocator.findNearestRandomMapFeature(serverLevel, ModTags.ADVENTURE_MAP_DESTINATIONS, pos, 250, true);
                if (found != null) {
                    BlockPos toPos = (BlockPos)found.getFirst();
                    ItemStack stack = MapItem.m_42886_((Level)level, (int)toPos.m_123341_(), (int)toPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)stack);
                    Pair<CustomDecorationType<?, ?>, Integer> decoration = AdventurerMapsHandler.getVanillaMarker((Holder)found.getSecond());
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (CustomDecorationType)((CustomDecorationType)decoration.getFirst()), (int)7869722);
                    stack.m_41714_((Component)new TranslatableComponent("filled_map.adventure"));
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }
    }
}

