/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CandleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.DoubleSkullBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.common.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.common.items.ItemsUtil;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemsOverrideHandler {
    private static final Map<Item, ItemUseOnBlockOverride> HP_ON_BLOCK_OVERRIDES = new HashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOnBlockOverride> ON_BLOCK_OVERRIDES = new HashMap<Item, ItemUseOnBlockOverride>();
    private static final Map<Item, ItemUseOverride> ITEM_USE_OVERRIDES = new HashMap<Item, ItemUseOverride>();
    private static final Map<Block, BlockInteractedWithOverride> BLOCK_USE_OVERRIDES = new HashMap<Block, BlockInteractedWithOverride>();

    public static boolean hasBlockPlacementAssociated(Item item2) {
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item2);
        return override != null && override.getPlacedBlock(item2) != null;
    }

    public static void registerOverrides() {
        ArrayList<ItemUseOnBlockOverride> HPItemActionOnBlock = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOnBlockOverride> itemActionOnBlock = new ArrayList<ItemUseOnBlockOverride>();
        ArrayList<ItemUseOverride> itemAction = new ArrayList<ItemUseOverride>();
        ArrayList<BlockInteractedWithOverride> actionOnBlock = new ArrayList<BlockInteractedWithOverride>();
        actionOnBlock.add(new DirectionalCakeConversionBehavior());
        actionOnBlock.add(new BellChainBehavior());
        itemAction.add(new ThrowableBrickBehavior());
        itemAction.add(new ClockItemBehavior());
        HPItemActionOnBlock.add(new AntiqueInkBehavior());
        HPItemActionOnBlock.add(new WrenchBehavior());
        HPItemActionOnBlock.add(new WallLanternBehavior());
        itemActionOnBlock.add(new BookPileBehavior());
        itemActionOnBlock.add(new SkullPileBehavior());
        itemActionOnBlock.add(new SkullCandlesBehavior());
        itemActionOnBlock.add(new EnhancedCakeBehavior());
        itemActionOnBlock.add(new MapMarkerBehavior());
        itemActionOnBlock.add(new XpBottlingBehavior());
        block8: for (Item i : ForgeRegistries.ITEMS) {
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : itemActionOnBlock) {
                try {
                    if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                    Block block2 = itemUseOnBlockOverride.getPlacedBlock(i);
                    if (block2 != null && itemUseOnBlockOverride.shouldBlockMapToItem(i)) {
                        Item.f_41373_.put(block2, i);
                    }
                    ON_BLOCK_OVERRIDES.put(i, itemUseOnBlockOverride);
                    break;
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("failed to register for override " + itemUseOnBlockOverride.getClass().getSimpleName() + " for " + i.getRegistryName() + " with exception: " + e);
                }
            }
            for (ItemUseOverride itemUseOverride : itemAction) {
                try {
                    if (!itemUseOverride.appliesToItem(i)) continue;
                    ITEM_USE_OVERRIDES.put(i, itemUseOverride);
                    break;
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("failed to register for override " + itemUseOverride.getClass().getSimpleName() + " for " + i.getRegistryName() + " with exception: " + e);
                }
            }
            for (ItemUseOnBlockOverride itemUseOnBlockOverride : HPItemActionOnBlock) {
                try {
                    if (!itemUseOnBlockOverride.appliesToItem(i)) continue;
                    HP_ON_BLOCK_OVERRIDES.put(i, itemUseOnBlockOverride);
                    continue block8;
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("failed to register for override " + itemUseOnBlockOverride.getClass().getSimpleName() + " for " + i.getRegistryName() + " with exception: " + e);
                }
            }
        }
        block12: for (Block block3 : ForgeRegistries.BLOCKS) {
            for (BlockInteractedWithOverride blockInteractedWithOverride : actionOnBlock) {
                try {
                    if (!blockInteractedWithOverride.appliesToBlock(block3)) continue;
                    BLOCK_USE_OVERRIDES.put(block3, blockInteractedWithOverride);
                    continue block12;
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("failed to register for override " + blockInteractedWithOverride.getClass().getSimpleName() + " for " + block3.getRegistryName() + " with exception: " + e);
                }
            }
        }
    }

    public static void tryHighPriorityClickedBlockOverride(PlayerInteractEvent.RightClickBlock event, ItemStack stack) {
        InteractionResult result;
        Item item2 = stack.m_41720_();
        ItemUseOnBlockOverride override = HP_ON_BLOCK_OVERRIDES.get(item2);
        if (override != null && override.isEnabled() && (result = override.tryPerformingAction(event.getWorld(), event.getPlayer(), event.getHand(), stack, event.getHitVec(), false)) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static void tryPerformClickedBlockOverride(PlayerInteractEvent.RightClickBlock event, ItemStack stack, boolean isRanged) {
        InteractionResult result;
        BlockPos pos;
        Level world;
        BlockState state;
        BlockInteractedWithOverride o;
        InteractionResult result2;
        Item item2 = stack.m_41720_();
        Player player = event.getPlayer();
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item2);
        if (override != null && override.isEnabled() && (result2 = override.tryPerformingAction(event.getWorld(), player, event.getHand(), stack, event.getHitVec(), isRanged)) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result2);
            return;
        }
        if (!player.m_6144_() && (o = BLOCK_USE_OVERRIDES.get((state = (world = event.getWorld()).m_8055_(pos = event.getPos())).m_60734_())) != null && o.isEnabled() && (result = o.tryPerformingAction(state, pos, world, player, event.getHand(), stack, event.getHitVec())) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static void tryPerformClickedItemOverride(PlayerInteractEvent.RightClickItem event, ItemStack stack) {
        InteractionResult result;
        Item item2 = stack.m_41720_();
        ItemUseOverride override = ITEM_USE_OVERRIDES.get(item2);
        if (override != null && override.isEnabled() && (result = override.tryPerformingAction(event.getWorld(), event.getPlayer(), event.getHand(), stack, null, false)) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static void addOverrideTooltips(ItemTooltipEvent event) {
        Item item2 = event.getItemStack().m_41720_();
        ItemUseOnBlockOverride override = ON_BLOCK_OVERRIDES.get(item2);
        if (override != null && override.isEnabled()) {
            List tooltip = event.getToolTip();
            BaseComponent t = override.getTooltip();
            if (t != null) {
                tooltip.add(t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        } else {
            ItemUseOverride o = ITEM_USE_OVERRIDES.get(item2);
            if (o != null && o.isEnabled()) {
                List tooltip = event.getToolTip();
                BaseComponent t = o.getTooltip();
                if (t != null) {
                    tooltip.add(t.m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    private static InteractionResult paceBlockOverride(Item itemOverride, Player player, InteractionHand hand, ItemStack heldStack, Level world, BlockHitResult raytrace, boolean isRanged) {
        BlockPos pos = raytrace.m_82425_();
        InteractionResult result = InteractionResult.PASS;
        if (!player.m_6144_() && !isRanged) {
            BlockState blockstate = world.m_8055_(pos);
            BlockInteractedWithOverride o = BLOCK_USE_OVERRIDES.get(blockstate.m_60734_());
            if (o != null && o.isEnabled()) {
                result = o.tryPerformingAction(blockstate, pos, world, player, hand, heldStack, raytrace);
            }
            if (result == InteractionResult.PASS) {
                result = blockstate.m_60664_(world, player, hand, raytrace);
            }
        }
        if (!result.m_19077_()) {
            BlockPlaceContext ctx = new BlockPlaceContext(world, player, hand, heldStack, raytrace);
            if (itemOverride instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)itemOverride;
                result = blockItem.m_40576_(ctx);
            }
        }
        if (result.m_19077_() && player instanceof ServerPlayer && !isRanged) {
            CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, heldStack);
        }
        if (result == InteractionResult.FAIL) {
            return InteractionResult.PASS;
        }
        return result;
    }

    private static InteractionResult paceBlockOverride(Block blockOverride, Player player, InteractionHand hand, ItemStack heldStack, Level world, BlockHitResult raytrace, boolean isRanged) {
        BlockPos pos = raytrace.m_82425_();
        InteractionResult result = InteractionResult.PASS;
        if (!player.m_6144_() && !isRanged) {
            BlockState blockstate = world.m_8055_(pos);
            BlockInteractedWithOverride o = BLOCK_USE_OVERRIDES.get(blockstate.m_60734_());
            if (o != null && o.isEnabled()) {
                result = o.tryPerformingAction(blockstate, pos, world, player, hand, heldStack, raytrace);
            }
            if (result == InteractionResult.PASS) {
                result = blockstate.m_60664_(world, player, hand, raytrace);
            }
        }
        if (!result.m_19077_()) {
            BlockPlaceContext ctx = new BlockPlaceContext(world, player, hand, heldStack, raytrace);
            SoundType placeSound = null;
            Item item2 = heldStack.m_41720_();
            if (item2 instanceof BlockItem) {
                BlockItem bi = (BlockItem)item2;
                placeSound = bi.m_40614_().m_49966_().getSoundType((LevelReader)world, pos, (Entity)player);
            }
            result = ItemsUtil.place(ctx, blockOverride, placeSound);
        }
        if (result.m_19077_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!isRanged) {
                CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, heldStack);
            }
        }
        if (result == InteractionResult.FAIL) {
            return InteractionResult.PASS;
        }
        return result;
    }

    private static InteractionResult replaceSimilarBlock(Block blockOverride, Player player, ItemStack stack, BlockPos pos, Level world, BlockState replaced, boolean isRanged, @Nullable SoundType sound, Property<?> ... properties) {
        BlockState newState = blockOverride.m_49966_();
        for (Property<?> p : properties) {
            newState = BlockUtils.replaceProperty(replaced, newState, p);
        }
        if (newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            FluidState fluidstate = world.m_6425_(pos);
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8));
        }
        if (!world.m_7731_(pos, newState, 3)) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
        }
        world.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        if (sound == null) {
            sound = newState.getSoundType((LevelReader)world, pos, (Entity)player);
        }
        world.m_5594_(player, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!isRanged) {
                CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, stack);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static abstract class ItemUseOnBlockOverride
    extends ItemUseOverride {
        private ItemUseOnBlockOverride() {
        }

        public boolean shouldBlockMapToItem(Item item2) {
            return this.appliesToItem(item2);
        }

        @Nullable
        public Block getPlacedBlock(Item i) {
            return null;
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return null;
        }
    }

    private static class DirectionalCakeConversionBehavior
    extends BlockInteractedWithOverride {
        private DirectionalCakeConversionBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.DIRECTIONAL_CAKE;
        }

        @Override
        public boolean appliesToBlock(Block block2) {
            return block2 == Blocks.f_50145_ || block2.m_204297_().m_203656_(BlockTags.f_144268_);
        }

        @Override
        public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
            if (state.m_60713_(Blocks.f_50145_) && (stack.m_204117_(ItemTags.f_144319_) || player.m_6350_() == Direction.EAST || (Integer)state.m_61143_((Property)CakeBlock.f_51180_) != 0)) {
                return InteractionResult.PASS;
            }
            if (!ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT || !stack.m_150930_(Items.f_42502_)) {
                BlockState newState = ((Block)ModRegistry.DIRECTIONAL_CAKE.get()).m_49966_();
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    Block.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                    Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null).forEach(d -> {
                        if (d.m_41720_() != Items.f_42502_) {
                            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)d);
                        }
                    });
                    state.m_60612_(serverLevel, pos, ItemStack.f_41583_);
                    world.m_7731_(pos, newState, 4);
                }
                BlockHitResult raytrace = new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), hit.m_82434_(), pos, false);
                return newState.m_60664_(world, player, hand, raytrace);
            }
            return InteractionResult.PASS;
        }
    }

    private static class BellChainBehavior
    extends BlockInteractedWithOverride {
        private BellChainBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.BELL_CHAIN;
        }

        @Override
        public boolean appliesToBlock(Block block2) {
            return block2 instanceof ChainBlock;
        }

        @Override
        public InteractionResult tryPerformingAction(BlockState state, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
            if (stack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                if (RopeBlock.findAndRingBell(world, pos, player, 0, s -> s.m_60734_() instanceof ChainBlock && s.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.Y)) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    private static class ThrowableBrickBehavior
    extends ItemUseOverride {
        private ThrowableBrickBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.THROWABLE_BRICKS_ENABLED;
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.throwable_brick");
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isBrick(item2);
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.m_21187_().nextFloat() * 0.4f + 0.8f));
            if (!world.f_46443_) {
                ThrowableBrickEntity brickEntity = new ThrowableBrickEntity(world, (LivingEntity)player);
                brickEntity.m_37446_(stack);
                float pow = 0.7f;
                brickEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f * pow, 1.0f * pow);
                world.m_7967_((Entity)brickEntity);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }

    private static class ClockItemBehavior
    extends ItemUseOverride {
        private ClockItemBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ClientConfigs.cached.CLOCK_CLICK;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.f_42524_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (world.f_46443_) {
                ClockBlock.displayCurrentHour(world, player);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
    }

    private static class AntiqueInkBehavior
    extends ItemUseOnBlockOverride {
        private AntiqueInkBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return CapabilityHandler.ANTIQUE_CAP_ENABLED;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.f_42532_ || item2 == ModRegistry.ANTIQUE_INK.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                IOwnerProtected op;
                boolean newState = !stack.m_150930_(Items.f_42532_);
                BlockPos pos = hit.m_82425_();
                BlockEntity tile = world.m_7702_(pos);
                if (tile != null && (!(tile instanceof IOwnerProtected) || (op = (IOwnerProtected)tile).isAccessibleBy(player))) {
                    LazyOptional cap = tile.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP);
                    AtomicBoolean success = new AtomicBoolean(false);
                    cap.ifPresent(c -> {
                        if (c.hasAntiqueInk() != newState) {
                            c.setAntiqueInk(newState);
                            tile.m_6596_();
                            if (world instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)world;
                                NetworkHandler.sendToAllInRangeClients(pos, serverLevel, 256.0, new ClientBoundSyncAntiqueInk(pos, newState));
                            }
                            success.set(true);
                        }
                    });
                    if (success.get()) {
                        if (newState) {
                            world.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            world.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static class WrenchBehavior
    extends ItemUseOnBlockOverride {
        private WrenchBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return (Boolean)RegistryConfigs.reg.WRENCH_ENABLED.get();
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == ModRegistry.WRENCH.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            ServerConfigs.Hands h;
            if (player.m_150110_().f_35938_ && ((h = ServerConfigs.cached.WRENCH_BYPASS) == ServerConfigs.Hands.MAIN_HAND && hand == InteractionHand.MAIN_HAND || h == ServerConfigs.Hands.OFF_HAND && hand == InteractionHand.OFF_HAND || h == ServerConfigs.Hands.BOTH)) {
                return stack.m_41661_(new UseOnContext(player, hand, hit));
            }
            return InteractionResult.PASS;
        }
    }

    private static class WallLanternBehavior
    extends ItemUseOnBlockOverride {
        private WallLanternBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.wall_lantern");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.WALL_LANTERN.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.WALL_LANTERN_PLACEMENT;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isLantern(item2);
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                double y;
                if (CompatHandler.torchslab && (y = hit.m_82450_().m_7098_() % 1.0) < 0.5) {
                    return InteractionResult.PASS;
                }
                return ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.WALL_LANTERN.get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class BookPileBehavior
    extends ItemUseOnBlockOverride {
        private BookPileBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.BOOK_PILE.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_BOOKS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return BookPileBlock.isQuarkTome(item2);
        }

        @Override
        public boolean shouldBlockMapToItem(Item item2) {
            return item2 == Items.f_42690_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                if (BookPileBlock.isWrittenBook(stack.m_41720_()) && !player.m_6144_()) {
                    return InteractionResult.PASS;
                }
                return ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.BOOK_PILE.get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class SkullPileBehavior
    extends ItemUseOnBlockOverride {
        private SkullPileBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.double_cake");
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.SKULL_PILES;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            SkullBlock skull;
            BlockItem bi;
            Block block2;
            return item2 instanceof BlockItem && (block2 = (bi = (BlockItem)item2).m_40614_()) instanceof SkullBlock && (skull = (SkullBlock)block2).m_48754_() != SkullBlock.Types.DRAGON;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            SkullBlock skullBlock;
            SkullBlockEntity oldTile;
            BlockState state;
            Block block2;
            BlockPos pos;
            BlockEntity blockEntity;
            if (player.m_150110_().f_35938_ && (blockEntity = world.m_7702_(pos = hit.m_82425_())) instanceof SkullBlockEntity && (block2 = (state = (oldTile = (SkullBlockEntity)blockEntity).m_58900_()).m_60734_()) instanceof SkullBlock && (skullBlock = (SkullBlock)block2).m_48754_() != SkullBlock.Types.DRAGON) {
                BlockEntity blockEntity2;
                ItemStack copy = stack.m_41777_();
                InteractionResult result = ItemsOverrideHandler.replaceSimilarBlock((Block)ModRegistry.SKULL_PILE.get(), player, stack, pos, world, state, isRanged, null, new Property[]{SkullBlock.f_56314_});
                if (result.m_19077_() && (blockEntity2 = world.m_7702_(pos)) instanceof DoubleSkullBlockTile) {
                    DoubleSkullBlockTile tile = (DoubleSkullBlockTile)blockEntity2;
                    tile.initialize(oldTile, skullBlock, copy, player, hand);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class SkullCandlesBehavior
    extends ItemUseOnBlockOverride {
        private SkullCandlesBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.SKULL_CANDLES;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2.m_204114_().m_203656_(ItemTags.f_144319_) && item2.getRegistryName().m_135827_().equals("minecraft");
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            SkullBlock skullBlock;
            SkullBlockEntity oldTile;
            BlockState state;
            Block block2;
            BlockPos pos;
            BlockEntity te;
            if (player.m_150110_().f_35938_ && (te = world.m_7702_(pos = hit.m_82425_())) instanceof SkullBlockEntity && (block2 = (state = (oldTile = (SkullBlockEntity)te).m_58900_()).m_60734_()) instanceof SkullBlock && (skullBlock = (SkullBlock)block2).m_48754_() != SkullBlock.Types.DRAGON) {
                BlockEntity blockEntity;
                ItemStack copy = stack.m_41777_();
                InteractionResult result = ItemsOverrideHandler.replaceSimilarBlock((Block)ModRegistry.SKULL_CANDLE.get(), player, stack, pos, world, state, isRanged, SoundType.f_154653_, new Property[]{SkullBlock.f_56314_});
                if (result.m_19077_() && (blockEntity = world.m_7702_(pos)) instanceof CandleSkullBlockTile) {
                    CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
                    tile.initialize(oldTile, skullBlock, copy, player, hand);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class EnhancedCakeBehavior
    extends ItemUseOnBlockOverride {
        private EnhancedCakeBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.double_cake");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.DOUBLE_CAKE.get();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isCake(item2);
        }

        private InteractionResult placeDoubleCake(Player player, ItemStack stack, BlockPos pos, Level world, BlockState state, boolean isRanged) {
            boolean isDirectional;
            boolean bl = isDirectional = state.m_60734_() == ModRegistry.DIRECTIONAL_CAKE.get();
            if (isDirectional && (Integer)state.m_61143_((Property)DirectionalCakeBlock.f_51180_) == 0 || state == Blocks.f_50145_.m_49966_()) {
                return ItemsOverrideHandler.replaceSimilarBlock((Block)ModRegistry.DOUBLE_CAKE.get(), player, stack, pos, world, state, isRanged, null, new Property[]{DoubleCakeBlock.FACING});
            }
            return InteractionResult.PASS;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos;
            BlockState state;
            Block b;
            if (player.m_150110_().f_35938_ && ((b = (state = world.m_8055_(pos = hit.m_82425_())).m_60734_()) == Blocks.f_50145_ || b == ModRegistry.DIRECTIONAL_CAKE.get())) {
                InteractionResult result = InteractionResult.FAIL;
                if (ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT) {
                    result = this.placeDoubleCake(player, stack, pos, world, state, isRanged);
                }
                if (!result.m_19077_() && ServerConfigs.cached.DIRECTIONAL_CAKE) {
                    result = ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.DIRECTIONAL_CAKE.get(), player, hand, stack, world, hit, isRanged);
                }
                return result;
            }
            return InteractionResult.PASS;
        }
    }

    private static class MapMarkerBehavior
    extends ItemUseOnBlockOverride {
        private MapMarkerBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.MAP_MARKERS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 instanceof MapItem;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos = hit.m_82425_();
            if (!MapDecorationHandler.getMarkersFromWorld((BlockGetter)world, (BlockPos)pos).isEmpty()) {
                if (!world.f_46443_) {
                    MapItemSavedData data = null;
                    if (stack.m_41720_() instanceof MapItem) {
                        data = MapItem.m_42853_((ItemStack)stack, (Level)world);
                    }
                    if (data instanceof ExpandedMapData) {
                        ExpandedMapData expandedMapData = (ExpandedMapData)data;
                        expandedMapData.toggleCustomDecoration((LevelAccessor)world, pos);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
    }

    private static class XpBottlingBehavior
    extends ItemUseOnBlockOverride {
        private static final JarBlockTile DUMMY_JAR_TILE = new JarBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.JAR_TINTED.get()).m_49966_());

        private XpBottlingBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.BOTTLE_XP;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.f_42590_ || item2 instanceof JarItem || item2 == Items.f_42612_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            BlockPos pos = hit.m_82425_();
            Item i = stack.m_41720_();
            if (world.m_8055_(pos).m_60734_() instanceof EnchantmentTableBlock) {
                ItemStack returnStack = null;
                if (i == Items.f_42612_) {
                    return InteractionResult.FAIL;
                }
                if (player.f_36078_ > 0 || player.m_7500_()) {
                    if (i == Items.f_42590_) {
                        returnStack = new ItemStack((ItemLike)Items.f_42612_);
                    } else if (i instanceof JarItem) {
                        ItemStack tempStack;
                        ItemStack temp;
                        DUMMY_JAR_TILE.resetHolders();
                        CompoundTag tag = stack.m_41737_("BlockEntityTag");
                        if (tag != null) {
                            DUMMY_JAR_TILE.m_142466_(tag);
                        }
                        if (DUMMY_JAR_TILE.canInteractWithFluidHolder() && (temp = XpBottlingBehavior.DUMMY_JAR_TILE.fluidHolder.interactWithItem(tempStack = new ItemStack((ItemLike)Items.f_42612_), null, null, false)) != null && temp.m_41720_() == Items.f_42590_) {
                            returnStack = ((JarBlock)((BlockItem)i).m_40614_()).getJarItem(DUMMY_JAR_TILE);
                        }
                    }
                    if (returnStack != null) {
                        player.m_6469_(CommonUtil.BOTTLING_DAMAGE, (float)ServerConfigs.cached.BOTTLING_COST);
                        Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                        if (!player.m_7500_()) {
                            player.m_6756_(-Utils.getXPinaBottle((int)1, (Random)world.f_46441_));
                        }
                        if (world.f_46443_) {
                            Minecraft.m_91087_().f_91061_.m_107332_((Entity)player, (ParticleOptions)ModRegistry.BOTTLING_XP_PARTICLE.get(), 1);
                        }
                        world.m_5594_(null, player.m_142538_(), SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static abstract class ItemUseOverride {
        private ItemUseOverride() {
        }

        public abstract boolean isEnabled();

        public abstract boolean appliesToItem(Item var1);

        @Nullable
        public BaseComponent getTooltip() {
            return null;
        }

        public abstract InteractionResult tryPerformingAction(Level var1, Player var2, InteractionHand var3, ItemStack var4, BlockHitResult var5, boolean var6);
    }

    private static abstract class BlockInteractedWithOverride {
        private BlockInteractedWithOverride() {
        }

        public abstract boolean isEnabled();

        public abstract boolean appliesToBlock(Block var1);

        public abstract InteractionResult tryPerformingAction(BlockState var1, BlockPos var2, Level var3, Player var4, InteractionHand var5, ItemStack var6, BlockHitResult var7);
    }

    private static class BookPileHorizontalBehavior
    extends ItemUseOnBlockOverride {
        private static final Item BOOK_PILE_H_ITEM = new BlockItem((Block)ModRegistry.BOOK_PILE_H.get(), new Item.Properties().m_41491_(null));

        private BookPileHorizontalBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.BOOK_PILE_H.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_BOOKS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return BookPileBlock.isNormalBook(item2);
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                if (BookPileBlock.isWrittenBook(stack.m_41720_()) && !player.m_6144_()) {
                    return InteractionResult.PASS;
                }
                return ItemsOverrideHandler.paceBlockOverride(BOOK_PILE_H_ITEM, player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class PlaceableGunpowderBehavior
    extends ItemUseOnBlockOverride {
        private PlaceableGunpowderBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.GUNPOWDER_BLOCK.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_GUNPOWDER;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.f_42403_;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                return ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.GUNPOWDER_BLOCK.get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class SoapClearBehavior
    extends ItemUseOnBlockOverride {
        boolean enabled = (Boolean)RegistryConfigs.reg.SOAP_ENABLED.get();

        private SoapClearBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == ModRegistry.SOAP.get();
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                boolean newState = !stack.m_150930_(Items.f_42532_);
                BlockPos pos = hit.m_82425_();
                BlockEntity tile = world.m_7702_(pos);
                if (tile != null) {
                    LazyOptional cap = tile.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP);
                    AtomicBoolean success = new AtomicBoolean(false);
                    cap.ifPresent(c -> {
                        if (c.hasAntiqueInk() != newState) {
                            c.setAntiqueInk(newState);
                            tile.m_6596_();
                            if (world instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)world;
                                NetworkHandler.sendToAllInRangeClients(pos, serverLevel, 256.0, new ClientBoundSyncAntiqueInk(pos, newState));
                            }
                            success.set(true);
                        }
                    });
                    if (success.get()) {
                        if (newState) {
                            world.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            world.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.m_19078_((boolean)world.f_46443_);
                    }
                }
            }
            return InteractionResult.PASS;
        }
    }

    private static class PlaceableRodsBehavior
    extends PlaceableSticksBehavior {
        private PlaceableRodsBehavior() {
            super(ModRegistry.BLAZE_ROD_BLOCK, Items.f_42585_);
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_RODS;
        }
    }

    private static class PlaceableSticksBehavior<T extends Block>
    extends ItemUseOnBlockOverride {
        private final Supplier<T> block;
        private final Item item;

        private PlaceableSticksBehavior(Supplier<T> block2, Item item2) {
            this.block = block2;
            this.item = item2;
        }

        private static <A extends Block> Optional<PlaceableSticksBehavior<A>> optional(Supplier<A> block2, Item item2) {
            if (item2 != null && item2 != Items.f_41852_) {
                return Optional.of(new PlaceableSticksBehavior<A>(block2, item2));
            }
            return Optional.empty();
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)this.block.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_STICKS;
        }

        @Override
        public boolean appliesToItem(Item i) {
            return i == this.item;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                return ItemsOverrideHandler.paceBlockOverride((Block)this.block.get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class HangingPotBehavior
    extends ItemUseOnBlockOverride {
        private HangingPotBehavior() {
        }

        @Override
        @Nullable
        public BaseComponent getTooltip() {
            return new TranslatableComponent("message.supplementaries.hanging_pot");
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            return (Block)ModRegistry.HANGING_FLOWER_POT.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.HANGING_POT_PLACEMENT;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isPot(item2);
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                return ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.HANGING_FLOWER_POT.get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }

    private static class CeilingBannersBehavior
    extends ItemUseOnBlockOverride {
        private CeilingBannersBehavior() {
        }

        @Override
        @Nullable
        public Block getPlacedBlock(Item i) {
            if (i instanceof BannerItem) {
                return (Block)ModRegistry.CEILING_BANNERS.get(((BannerItem)i).m_40545_()).get();
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.CEILING_BANNERS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 instanceof BannerItem;
        }

        @Override
        public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, boolean isRanged) {
            if (player.m_150110_().f_35938_) {
                return ItemsOverrideHandler.paceBlockOverride((Block)ModRegistry.CEILING_BANNERS.get(((BannerItem)stack.m_41720_()).m_40545_()).get(), player, hand, stack, world, hit, isRanged);
            }
            return InteractionResult.PASS;
        }
    }
}

