/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BlockPlacerItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ItemsUtil {
    @Nullable
    public static BlockState getPlacementState(BlockPlaceContext context, Block block2) {
        return ((BlockPlacerItem)ModRegistry.BLOCK_PLACER.get()).mimicGetPlacementState(context, block2);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace) {
        return ItemsUtil.place(context, blockToPlace, null);
    }

    public static InteractionResult place(BlockPlaceContext context, Block blockToPlace, @Nullable SoundType placeSound) {
        return ((BlockPlacerItem)ModRegistry.BLOCK_PLACER.get()).mimicPlace(context, blockToPlace, placeSound);
    }

    public static boolean tryInteractingWithContainerItem(ItemStack containerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean inSlot) {
        if (action != ClickAction.PRIMARY) {
            if (incoming.m_41619_()) {
                if (!inSlot) {
                    return ItemsUtil.removeItemFromHandler(player, containerStack, slot);
                }
            } else if (ItemsUtil.addItemToHandler(player, containerStack, incoming, slot, true, inSlot)) {
                return ItemsUtil.addItemToHandler(player, containerStack, incoming, slot, false, inSlot);
            }
        }
        return false;
    }

    @Nullable
    public static boolean addItemToHandler(Player player, ItemStack containerStack, ItemStack stack, Slot slot, boolean simulate, boolean inSlot) {
        Pair<IItemHandler, BlockEntity> handlerAndTe;
        if (slot.m_8010_(player) && (handlerAndTe = ItemsUtil.getItemHandler(containerStack, player)) != null) {
            boolean success;
            IItemHandler handler = (IItemHandler)handlerAndTe.getFirst();
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate);
            boolean bl = success = result.m_41619_() || result.m_41613_() != stack.m_41613_();
            if (success) {
                if (simulate) {
                    return true;
                }
                CompoundTag newTag = new CompoundTag();
                newTag.m_128365_("BlockEntityTag", (Tag)((BlockEntity)handlerAndTe.getSecond()).m_187482_());
                if (inSlot) {
                    stack.m_41764_(result.m_41613_());
                    ItemStack newStack = containerStack.m_41777_();
                    if (slot.m_5857_(newStack)) {
                        newStack.m_41751_(newTag);
                        slot.m_5852_(newStack);
                        return true;
                    }
                } else {
                    int i = stack.m_41613_() - result.m_41613_();
                    slot.m_150647_(i, i, player);
                    containerStack.m_41751_(newTag);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static boolean removeItemFromHandler(Player player, ItemStack containerStack, Slot slot) {
        Pair<IItemHandler, BlockEntity> handlerAndTe;
        if (slot.m_8010_(player) && (handlerAndTe = ItemsUtil.getItemHandler(containerStack, player)) != null) {
            IItemHandler handler = (IItemHandler)handlerAndTe.getFirst();
            for (int s = 0; s < handler.getSlots(); ++s) {
                ItemStack selected = handler.getStackInSlot(s);
                if (selected.m_41619_()) continue;
                ItemStack dropped = handler.extractItem(s, 1, false);
                if (slot.m_5857_(dropped)) {
                    slot.m_5852_(dropped);
                    CompoundTag newTag = new CompoundTag();
                    newTag.m_128365_("BlockEntityTag", (Tag)((BlockEntity)handlerAndTe.getSecond()).m_187482_());
                    containerStack.m_41751_(newTag);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    public static Pair<IItemHandler, BlockEntity> getItemHandler(ItemStack containerStack, Player player) {
        BlockEntity te;
        CompoundTag tag = containerStack.m_41784_();
        CompoundTag cmp = tag.m_128469_("BlockEntityTag");
        if (!cmp.m_128441_("LootTable") && (te = ItemsUtil.loadBlockEntityFromItem(cmp.m_6426_(), containerStack.m_41720_())) != null) {
            SafeBlockTile safe;
            if (te instanceof SafeBlockTile && !(safe = (SafeBlockTile)te).canPlayerOpen(player, false)) {
                return null;
            }
            LazyOptional handlerHolder = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (handlerHolder.isPresent()) {
                return Pair.of((Object)((IItemHandler)handlerHolder.orElseGet(EmptyHandler::new)), (Object)te);
            }
        }
        return null;
    }

    @Nullable
    public static BlockEntity loadBlockEntityFromItem(CompoundTag tag, Item item2) {
        BlockItem blockItem;
        Block block2;
        if (item2 instanceof BlockItem && (block2 = (blockItem = (BlockItem)item2).m_40614_()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block2;
            BlockEntity te = entityBlock.m_142194_(BlockPos.f_121853_, block2.m_49966_());
            if (te != null) {
                te.m_142466_(tag);
            }
            return te;
        }
        return null;
    }

    public record InventoryTooltip(CompoundTag tag, Item item, int size) implements TooltipComponent
    {
    }
}

