/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.mojang.blaze3d.platform.NativeImage;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.AssetGenerators;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.ResourcePackAwareDynamicTextureProvider;
import net.mehvahdjukaar.selene.textures.Palette;
import net.mehvahdjukaar.selene.textures.Respriter;
import net.mehvahdjukaar.selene.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.WallLanternStuff;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.common.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends ResourcePackAwareDynamicTextureProvider {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();
    public static final DynamicTexturePack DYNAMIC_TEXTURE_PACK = new DynamicTexturePack(Supplementaries.res("virtual_resourcepack"));

    public static void registerBus(IEventBus bus) {
        DYNAMIC_TEXTURE_PACK.registerPack(bus);
        ClientDynamicResourcesHandler.DYNAMIC_TEXTURE_PACK.generateDebugResources = (Boolean)RegistryConfigs.reg.DEBUG_RESOURCES.get();
    }

    public DynamicTexturePack getDynamicPack() {
        return DYNAMIC_TEXTURE_PACK;
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean hasTexturePackSupport() {
        return (Boolean)ClientConfigs.general.RESOURCE_PACK_SUPPORT.get();
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        AssetGenerators.LangBuilder langBuilder = new AssetGenerators.LangBuilder();
        RPUtils.StaticResource hsBlockState = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.BLOCKSTATES));
        RPUtils.StaticResource hsModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_signs/hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.BLOCK_MODELS));
        RPUtils.StaticResource hsLoader = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_signs/loader_template"), (RPUtils.ResType)RPUtils.ResType.BLOCK_MODELS));
        RPUtils.StaticResource hsItemModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("hanging_sign_oak"), (RPUtils.ResType)RPUtils.ResType.ITEM_MODELS));
        for (Map.Entry<WoodType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
            WoodType wood = e.getKey();
            HangingSignBlock v = e.getValue();
            String id = wood.getVariantId("hanging_sign");
            langBuilder.addEntry((Block)v, wood.getNameForTranslation("hanging_sign"));
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsBlockState, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign blockstate definition for {} : {}", (Object)v, (Object)ex);
            }
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign block model for {} : {}", (Object)v, (Object)ex);
            }
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(hsItemModel, "hanging_sign_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign item model for {} : {}", (Object)v, (Object)ex);
            }
            try {
                String logTexture;
                try {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)Objects.requireNonNull(wood.logBlock), s -> !s.contains("top"));
                }
                catch (Exception e1) {
                    logTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.plankBlock, s -> true);
                    this.getLogger().error("Could not properly generate Hanging Sign model for {}. Falling back to planks texture : {}", (Object)v, (Object)e1);
                }
                this.addHangingSignLoaderModel(Objects.requireNonNull(hsLoader), id, logTexture);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Hanging Sign loader model for {} : {}", (Object)v, (Object)ex);
            }
        }
        RPUtils.StaticResource spItemModel = this.getResOrLog(manager, RPUtils.resPath((ResourceLocation)Supplementaries.res("sign_post_oak"), (RPUtils.ResType)RPUtils.ResType.ITEM_MODELS));
        for (Map.Entry<WoodType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
            WoodType wood = e.getKey();
            if (wood.isVanilla()) {
                // empty if block
            }
            SignPostItem v = e.getValue();
            langBuilder.addEntry((Item)v, e.getKey().getNameForTranslation("sign_post"));
            try {
                DYNAMIC_TEXTURE_PACK.addSimilarJsonResource(spItemModel, "sign_post_oak", wood.getVariantId("sign_post"));
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)v, (Object)ex);
            }
        }
        DYNAMIC_TEXTURE_PACK.addLang(Supplementaries.res("en_us"), langBuilder.build());
    }

    public void addHangingSignLoaderModel(RPUtils.StaticResource resource, String woodTextPath, String logTexture) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        string = string.replace("wood_type", woodTextPath);
        string = string.replace("log_texture", logTexture);
        ResourceLocation newRes = Supplementaries.res("hanging_signs/" + woodTextPath + "_loader");
        DYNAMIC_TEXTURE_PACK.addBytes(newRes, string.getBytes(), RPUtils.ResType.BLOCK_MODELS);
    }

    public void regenerateTextures(ResourceManager manager) {
        SignPostItem v;
        ResourceLocation textureRes;
        WoodType wood;
        Respriter respriter;
        Palette targetPalette;
        HangingSignBlock v2;
        ResourceLocation textureRes2;
        WoodType wood2;
        Respriter respriter2;
        Palette palette;
        NativeImage template;
        WallLanternStuff.onResourceReload(manager);
        try {
            template = this.readImage(manager, Supplementaries.res("textures/blocks/hanging_signs/hanging_sign_oak.png"));
            try (NativeImage mask = this.readImage(manager, Supplementaries.res("textures/blocks/hanging_signs/board_mask.png"));){
                palette = Palette.fromImage((NativeImage)template, (NativeImage)mask);
                respriter2 = new Respriter(template, palette);
                for (Map.Entry<WoodType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
                    wood2 = e.getKey();
                    textureRes2 = Supplementaries.res(String.format("blocks/hanging_signs/%s", wood2.getVariantId("hanging_sign")));
                    if (this.alreadyHasTextureAtLocation(manager, textureRes2)) continue;
                    v2 = e.getValue();
                    try {
                        NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood2.plankBlock);
                        try {
                            targetPalette = SpriteUtils.extrapolateSignBlockPalette((NativeImage)plankPalette);
                            NativeImage newImage = respriter2.recolorImage(targetPalette);
                            DYNAMIC_TEXTURE_PACK.addTexture(textureRes2, newImage);
                        }
                        finally {
                            if (plankPalette == null) continue;
                            plankPalette.close();
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Hanging Sign block texture for for {} : {}", (Object)v2, (Object)ex);
                    }
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Hanging Sign block texture : ", (Throwable)ex);
        }
        try (NativeImage boardTemplate = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/template.png"));
             NativeImage boardMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/board_mask.png"));){
            palette = Palette.fromImage((NativeImage)boardTemplate, (NativeImage)boardMask);
            respriter2 = new Respriter(boardTemplate, palette);
            for (Map.Entry<WoodType, HangingSignBlock> e : ModRegistry.HANGING_SIGNS.entrySet()) {
                wood2 = e.getKey();
                textureRes2 = Supplementaries.res(String.format("items/hanging_signs/%s", wood2.getVariantId("hanging_sign")));
                if (this.alreadyHasTextureAtLocation(manager, textureRes2)) continue;
                v2 = e.getValue();
                NativeImage newImage = null;
                if (wood2.signItem != null) {
                    try (NativeImage vanillaSign = RPUtils.findFirstItemTexture((ResourceManager)manager, (Item)((Item)wood2.signItem.get()));
                         NativeImage signMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/sign_board_mask.png"));){
                        Palette targetPalette2 = Palette.fromImage((NativeImage)vanillaSign, (NativeImage)signMask);
                        newImage = respriter2.recolorImage(targetPalette2);
                        try (NativeImage scribbles = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_scribbles_mask.png"), Supplementaries.res("textures/items/hanging_signs/scribbles_template.png"));){
                            SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{scribbles});
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not properly color Hanging Sign texture for {} : {}", (Object)v2, (Object)ex);
                        }
                        try (NativeImage stick = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_stick_mask.png"), Supplementaries.res("textures/items/hanging_signs/stick_template.png"));){
                            SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{stick});
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not properly color Hanging Sign item texture for {} : {}", (Object)v2, (Object)ex);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Could not find sign texture for wood type {}. Using plank texture : {}", (Object)wood2, (Object)ex);
                    }
                }
                if (newImage == null) {
                    try (NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood2.plankBlock);){
                        Palette targetPalette3 = SpriteUtils.extrapolateWoodItemPalette((NativeImage)plankPalette);
                        newImage = respriter2.recolorImage(targetPalette3);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Hanging Sign item texture for for {} : {}", (Object)v2, (Object)ex);
                    }
                }
                if (newImage == null) continue;
                DYNAMIC_TEXTURE_PACK.addTexture(textureRes2, newImage);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Hanging Sign item texture : ", (Throwable)ex);
        }
        try {
            template = this.readImage(manager, Supplementaries.res("textures/items/sign_posts/template.png"));
            try {
                respriter = new Respriter(template);
                for (Map.Entry<WoodType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
                    wood = e.getKey();
                    textureRes = Supplementaries.res(String.format("items/sign_posts/%s", wood.getVariantId("sign_post")));
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) continue;
                    v = e.getValue();
                    NativeImage newImage = null;
                    if (wood.signItem != null) {
                        try (NativeImage vanillaSign = RPUtils.findFirstItemTexture((ResourceManager)manager, (Item)((Item)wood.signItem.get()));
                             NativeImage signMask = this.readImage(manager, Supplementaries.res("textures/items/hanging_signs/sign_board_mask.png"));){
                            targetPalette = Palette.fromImage((NativeImage)vanillaSign, (NativeImage)signMask);
                            newImage = respriter.recolorImage(targetPalette);
                            try (NativeImage scribbles = this.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("textures/items/hanging_signs/sign_scribbles_mask.png"), Supplementaries.res("textures/items/sign_posts/scribbles_template.png"));){
                                SpriteUtils.mergeImages((NativeImage)newImage, (NativeImage[])new NativeImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)v, (Object)ex);
                            }
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not find sign texture for wood type {}. Using plank texture : {}", (Object)wood, (Object)ex);
                        }
                    }
                    if (newImage == null) {
                        try (NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood.plankBlock);){
                            Palette targetPalette4 = SpriteUtils.extrapolateWoodItemPalette((NativeImage)plankPalette);
                            newImage = respriter.recolorImage(targetPalette4);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)v, (Object)ex);
                        }
                    }
                    if (newImage == null) continue;
                    DYNAMIC_TEXTURE_PACK.addTexture(textureRes, newImage);
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = this.readImage(manager, Supplementaries.res("textures/entity/sign_posts/sign_post_oak.png"));
            try {
                respriter = new Respriter(template);
                for (Map.Entry<WoodType, SignPostItem> e : ModRegistry.SIGN_POST_ITEMS.entrySet()) {
                    wood = e.getKey();
                    textureRes = Supplementaries.res(String.format("entity/sign_posts/%s", wood.getVariantId("sign_post")));
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) continue;
                    v = e.getValue();
                    try {
                        NativeImage plankPalette = RPUtils.findFirstBlockTexture((ResourceManager)manager, (Block)wood.plankBlock);
                        try {
                            NativeImage newImage = respriter.recolorImage(plankPalette, null);
                            DYNAMIC_TEXTURE_PACK.addTexture(textureRes, newImage);
                        }
                        finally {
                            if (plankPalette == null) continue;
                            plankPalette.close();
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)v, (Object)ex);
                    }
                }
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }
}

