/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class SupplementariesJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Supplementaries.res("jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(SupplementariesJEIPlugin.createTippedBambooSpikesRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createBlackboardDuplicate(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createRopeArrowCreateRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createRopeArrowAddRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createFlagFromBanner(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createAntiqueMaoRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createBubbleBlowerChargeRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createSoapCleanShulkerRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.createSoapCleanPresentRecipe(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.makePresentCloringRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        registry.addRecipes(SupplementariesJEIPlugin.makeTrappedPresentRecipes(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get(), (IIngredientSubtypeInterpreter)SpikesSubtypeInterpreter.INSTANCE);
    }

    public static List<Recipe<?>> createAntiqueMaoRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.antique_map";
        ItemStack stack = new ItemStack((ItemLike)Items.f_42573_);
        stack.m_41714_((Component)new TranslatableComponent("filled_map.antique"));
        Ingredient ink = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.ANTIQUE_INK.get())});
        Ingredient map = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42573_)});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{map, ink});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_antique_map_create");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, stack, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> createRopeArrowCreateRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.rope_arrow";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get());
        ropeArrow.m_41721_(ropeArrow.m_41776_() - 4);
        Ingredient arrow = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42412_)});
        Ingredient rope = Ingredient.m_204132_(ModTags.ROPES);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{arrow, rope, rope, rope, rope});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_rope_arrow_create");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, ropeArrow, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> createRopeArrowAddRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.rope_arrow";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.ROPE_ARROW_ITEM.get());
        ItemStack ropeArrow2 = ropeArrow.m_41777_();
        ropeArrow2.m_41721_(8);
        Ingredient arrow = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ropeArrow2});
        Ingredient rope = Ingredient.m_204132_(ModTags.ROPES);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{rope, rope, rope, rope, arrow, rope, rope, rope, rope});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_rope_arrow_add");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, ropeArrow, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> createSoapCleanPresentRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.soap";
        ItemStack output = new ItemStack((ItemLike)ModRegistry.PRESENTS.get(null).get());
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_204132_(ModTags.PRESENTS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SOAP.get()})});
        ResourceLocation id = Supplementaries.res("jei_soap_clean_present");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, output, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> createSoapCleanShulkerRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.soap";
        ItemStack output = new ItemStack((ItemLike)Items.f_42265_);
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_204132_(ModTags.SHULKER_BOXES), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SOAP.get()})});
        ResourceLocation id = Supplementaries.res("jei_soap_clean_shulker");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, output, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> makeTrappedPresentRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.presents";
        for (DyeColor color : DyeColor.values()) {
            Ingredient baseShulkerIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS_ITEMS.get(color).get()});
            ItemStack output = ((Item)ModRegistry.TRAPPED_PRESENTS_ITEMS.get(color).get()).m_7968_();
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseShulkerIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42109_})});
            ResourceLocation id = Supplementaries.res("jei_trapped_present_" + color.m_41065_());
            recipes.add((Recipe<?>)new ShapelessRecipe(id, group, output, inputs));
        }
        Ingredient baseShulkerIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS_ITEMS.get(null).get()});
        ItemStack output = ((Item)ModRegistry.TRAPPED_PRESENTS_ITEMS.get(null).get()).m_7968_();
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseShulkerIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42109_})});
        ResourceLocation id = Supplementaries.res("jei_trapped_present");
        recipes.add((Recipe<?>)new ShapelessRecipe(id, group, output, inputs));
        return recipes;
    }

    public static List<Recipe<?>> makePresentCloringRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.presents";
        Ingredient baseShulkerIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.PRESENTS_ITEMS.get(null).get()});
        for (DyeColor color : DyeColor.values()) {
            DyeItem dye = DyeItem.m_41082_((DyeColor)color);
            ItemStack output = ((Item)ModRegistry.PRESENTS_ITEMS.get(color).get()).m_7968_();
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseShulkerIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{dye})});
            ResourceLocation id = Supplementaries.res("jei_present_" + color.m_41065_());
            recipes.add((Recipe<?>)new ShapelessRecipe(id, group, output, inputs));
        }
        return recipes;
    }

    public static List<Recipe<?>> createBubbleBlowerChargeRecipe() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.bubble_blower";
        ItemStack ropeArrow = new ItemStack((ItemLike)ModRegistry.BUBBLE_BLOWER.get());
        ItemStack empty = ropeArrow.m_41777_();
        empty.m_41721_(empty.m_41776_());
        Ingredient base = Ingredient.m_43927_((ItemStack[])new ItemStack[]{empty});
        Ingredient soap = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.SOAP.get()});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{base, soap});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_bubble_blower_charge");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, ropeArrow, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static List<Recipe<?>> createTippedBambooSpikesRecipes() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.tipped_spikes";
        for (Potion potionType : ForgeRegistries.POTIONS.getValues()) {
            if (potionType.m_43488_().isEmpty() || !BambooSpikesTippedItem.areEffectsValid(potionType.m_43488_())) continue;
            recipes.add((Recipe<?>)SupplementariesJEIPlugin.makeSpikeRecipe(potionType, group));
        }
        return recipes;
    }

    private static ShapelessRecipe makeSpikeRecipe(Potion potionType, String group) {
        ItemStack spikes = new ItemStack((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get());
        ItemStack lingeringPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potionType);
        Ingredient spikeIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{spikes});
        Ingredient potionIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{lingeringPotion});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{spikeIngredient, potionIngredient});
        ItemStack output = BambooSpikesTippedItem.makeSpikeItem(potionType);
        ResourceLocation id = new ResourceLocation("supplementaries", potionType.m_43492_("jei.tipped_spikes."));
        return new ShapelessRecipe(id, group, output, inputs);
    }

    public static List<Recipe<?>> createFlagFromBanner() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.flag_from_banner";
        for (DyeColor color : DyeColor.values()) {
            ItemStack banner = new ItemStack((ItemLike)BannerBlock.m_49014_((DyeColor)color).m_5456_());
            ItemStack fullFlag = new ItemStack((ItemLike)ModRegistry.FLAGS.get(color).get());
            ListTag list = new ListTag();
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("Pattern", ((BannerPatternItem)Items.f_42723_).m_40555_().m_58579_());
            compoundTag.m_128405_("Color", color == DyeColor.WHITE ? DyeColor.BLACK.m_41060_() : DyeColor.WHITE.m_41060_());
            list.add((Object)compoundTag);
            CompoundTag com = banner.m_41698_("BlockEntityTag");
            com.m_128365_("Patterns", (Tag)list);
            CompoundTag com2 = fullFlag.m_41698_("BlockEntityTag");
            com2.m_128365_("Patterns", (Tag)list);
            Ingredient emptyFlag = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.FLAGS.get(color).get())});
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{emptyFlag, Ingredient.m_43927_((ItemStack[])new ItemStack[]{banner})});
            ResourceLocation id = new ResourceLocation("supplementaries", "jei_flag_from_banner");
            ShapelessRecipe recipe = new ShapelessRecipe(id, group, fullFlag, inputs);
            recipes.add((Recipe<?>)recipe);
        }
        return recipes;
    }

    public static List<Recipe<?>> createBlackboardDuplicate() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_duplicate";
        ItemStack blackboard = new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundTag com = new CompoundTag();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}};
        com.m_128388_("Pixels", BlackboardBlockTile.packPixels(pixels));
        blackboard.m_41700_("BlockEntityTag", (Tag)com);
        Ingredient emptyBoard = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get())});
        Ingredient fullBoard = Ingredient.m_43927_((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_blackboard_duplicate");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, blackboard, inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static ItemStack getSans() {
        ItemStack blackboard = new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get());
        CompoundTag com = new CompoundTag();
        byte[][] pixels = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 0, 3, 3, 3, 3, 0, 0, 1, 0, 1, 0, 1}, {0, 1, 0, 0, 3, 0, 3, 0, 3, 0, 0, 1, 1, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 3, 3, 3, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0}};
        com.m_128388_("Pixels", BlackboardBlockTile.packPixels(pixels));
        blackboard.m_41700_("BlockEntityTag", (Tag)com);
        return blackboard;
    }

    public static List<Recipe<?>> createBlackboardClear() {
        ArrayList recipes = new ArrayList();
        String group = "supplementaries.jei.blackboard_clear";
        ItemStack blackboard = SupplementariesJEIPlugin.getSans();
        Ingredient emptyBoard = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42447_)});
        Ingredient fullBoard = Ingredient.m_43927_((ItemStack[])new ItemStack[]{blackboard});
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{emptyBoard, fullBoard});
        ResourceLocation id = new ResourceLocation("supplementaries", "jei_blackboard_clear");
        ShapelessRecipe recipe = new ShapelessRecipe(id, group, new ItemStack((ItemLike)ModRegistry.BLACKBOARD_ITEM.get()), inputs);
        recipes.add((Recipe<?>)recipe);
        return recipes;
    }

    public static class SpikesSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final SpikesSubtypeInterpreter INSTANCE = new SpikesSubtypeInterpreter();

        private SpikesSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack, UidContext uidContext) {
            Potion potionType = PotionUtils.m_43579_((ItemStack)itemStack);
            String potionTypeString = potionType.m_43492_("");
            StringBuilder stringBuilder = new StringBuilder(potionTypeString);
            List effects = PotionUtils.m_43547_((ItemStack)itemStack);
            for (MobEffectInstance effect : effects) {
                stringBuilder.append(";").append(effect);
            }
            return stringBuilder.toString();
        }
    }
}

