/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import com.google.common.base.Stopwatch;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.capabilities.mobholder.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.entities.trades.VillagerTradesHandler;
import net.mehvahdjukaar.supplementaries.common.events.ItemsOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.commands.ModCommands;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.world.data.map.CMDreg;
import net.mehvahdjukaar.supplementaries.common.world.data.map.WeatheredMap;
import net.mehvahdjukaar.supplementaries.common.world.generation.WorldGenHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.setup.CauldronRegistry;
import net.mehvahdjukaar.supplementaries.setup.DispenserRegistry;
import net.mehvahdjukaar.supplementaries.setup.LootTableStuff;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.setup.PresentRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="supplementaries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModSetup {
    private static boolean hasFinishedSetup = false;
    private static int setupStage = 0;
    public static boolean firstTagLoad = false;

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                Stopwatch watch = Stopwatch.createStarted();
                WorldGenHandler.onInit();
                ++setupStage;
                CompatHandler.init();
                ++setupStage;
                CMDreg.init(event);
                ++setupStage;
                WeatheredMap.init();
                ++setupStage;
                FlowerPotHandler.init();
                ++setupStage;
                CapturedMobsHelper.refresh();
                ++setupStage;
                ModSoftFluids.init();
                ++setupStage;
                NetworkHandler.registerMessages();
                ++setupStage;
                LootTableStuff.init();
                ++setupStage;
                ModSetup.registerCompostables();
                ++setupStage;
                ModSetup.registerMobFoods();
                ++setupStage;
                CauldronRegistry.registerInteractions();
                ++setupStage;
                PresentRegistry.registerBehaviors();
                ++setupStage;
                hasFinishedSetup = true;
                Supplementaries.LOGGER.info("Finished mod setup in: {} seconds", (Object)watch.elapsed().toSeconds());
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error((Object)e);
                ModSetup.terminateWhenSetupFails();
            }
        });
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerMobFoods() {
        ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>(List.of(Chicken.f_28233_.m_43908_()));
        chickenFood.add(new ItemStack((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()));
        Chicken.f_28233_ = Ingredient.m_43921_(chickenFood.stream());
        ArrayList<ItemStack> horseFood = new ArrayList<ItemStack>(List.of(new ItemStack((ItemLike)ModRegistry.FLAX_ITEM.get()), new ItemStack((ItemLike)ModRegistry.FLAX_BLOCK_ITEM.get())));
        horseFood.addAll(List.of(AbstractHorse.f_30527_.m_43908_()));
        AbstractHorse.f_30527_ = Ingredient.m_43921_(horseFood.stream());
    }

    private static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_ITEM.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_WILD_ITEM.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModRegistry.FLAX_BLOCK_ITEM.get()), 1.0f);
    }

    @SubscribeEvent
    public static void onTagLoad(TagsUpdatedEvent event) {
        if (!firstTagLoad) {
            firstTagLoad = true;
            if (!hasFinishedSetup) {
                ModSetup.terminateWhenSetupFails();
            }
            Stopwatch watch = Stopwatch.createStarted();
            DispenserRegistry.registerBehaviors();
            ItemsOverrideHandler.registerOverrides();
            Supplementaries.LOGGER.info("Finished additional setup in {} seconds", (Object)watch.elapsed().toSeconds());
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityHandler.register(event);
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent event) {
        VillagerTradesHandler.registerVillagerTrades(event);
    }

    @SubscribeEvent
    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        VillagerTradesHandler.registerWanderingTraderTrades(event);
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent e) {
        LootTableStuff.injectLootTables(e);
    }
}

