/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.StaminaWheelConstants;
import tictim.paraglider.client.StaminaWheelRenderer;

public class BargainScreenStaminaWheelRenderer
extends StaminaWheelRenderer {
    private int internalStamina;
    private long lastUpdateTimestamp;
    private long timeSinceFull;
    private boolean gainedStamina;

    public BargainScreenStaminaWheelRenderer(int internalStamina) {
        this.internalStamina = internalStamina;
        this.lastUpdateTimestamp = System.currentTimeMillis();
    }

    @Override
    protected void makeWheel(PlayerMovement h) {
        int maxStamina = h.getMaxStamina();
        long newTimestamp = System.currentTimeMillis();
        long timePassed = newTimestamp - this.lastUpdateTimestamp;
        this.lastUpdateTimestamp = newTimestamp;
        if (this.internalStamina > maxStamina) {
            this.internalStamina = Math.max(this.internalStamina - this.getStaminaChange(timePassed), maxStamina);
            this.timeSinceFull = 0L;
            this.gainedStamina = false;
        } else if (this.internalStamina < maxStamina) {
            this.internalStamina = Math.min(this.internalStamina + this.getStaminaChange(timePassed), maxStamina);
            this.timeSinceFull = 0L;
            this.gainedStamina = true;
        } else {
            this.timeSinceFull += timePassed;
        }
        if (this.internalStamina > maxStamina) {
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(maxStamina), StaminaWheelConstants.IDLE);
                this.addWheel(t, t.getProportion(maxStamina), t.getProportion(this.internalStamina), StaminaWheelConstants.EVIL_GLOW);
            }
        } else if (this.internalStamina < maxStamina) {
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(this.internalStamina), StaminaWheelConstants.IDLE);
            }
        } else if (this.gainedStamina && this.timeSinceFull < 250L) {
            int stamina = ModCfg.maxStamina(h.getStaminaVessels() - 1);
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(stamina), StaminaWheelConstants.IDLE);
                this.addWheel(t, t.getProportion(stamina), t.getProportion(maxStamina), StaminaWheelConstants.GLOW.blend(StaminaWheelConstants.IDLE, (float)this.timeSinceFull / 250.0f));
            }
        } else {
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(maxStamina), StaminaWheelConstants.IDLE);
            }
        }
    }

    private int getStaminaChange(long timePassed) {
        return (int)((double)timePassed * 0.4);
    }
}

