/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;

public final class ModVillageStructures {
    private ModVillageStructures() {
    }

    public static void addVillageStructures() {
        if (!ModCfg.enableStructures()) {
            return;
        }
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ModVillageStructures.appendPool(new ResourceLocation("village/desert/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:gerudo_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:desert_village_horned_statue"), (Object)1));
        ModVillageStructures.appendPool(new ResourceLocation("village/plains/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:hateno_village_goddess_statue"), (Object)1), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:plains_village_horned_statue"), (Object)1));
        ModVillageStructures.appendPool(new ResourceLocation("village/savanna/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:rito_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:savanna_village_horned_statue"), (Object)1));
        ModVillageStructures.appendPool(new ResourceLocation("village/snowy/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:snowy_village_horned_statue"), (Object)1));
        ModVillageStructures.appendPool(new ResourceLocation("village/taiga/houses"), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:kakariko_village_goddess_statue"), (Object)3), Pair.of((Object)StructurePoolElement.m_210507_((String)"paraglider:taiga_village_horned_statue"), (Object)1));
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    @SafeVarargs
    private static void appendPool(ResourceLocation pool, Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> ... elementToWeight) {
        StructureTemplatePool old = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        if (old == null || old == Pools.m_206434_().m_203334_()) {
            ParagliderMod.LOGGER.warn("Template pool '{}' doesn't exists", (Object)pool);
            return;
        }
        if (elementToWeight.length == 0) {
            return;
        }
        ArrayList<Pair> newWeightedPool = new ArrayList<Pair>(old.f_210559_.size() + elementToWeight.length);
        newWeightedPool.addAll(old.f_210559_);
        for (Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> p : elementToWeight) {
            newWeightedPool.add(Pair.of((Object)((StructurePoolElement)((Function)p.getFirst()).apply(StructureTemplatePool.Projection.RIGID)), (Object)((Integer)p.getSecond())));
        }
        ((WritableRegistry)BuiltinRegistries.f_123864_).m_203384_(OptionalInt.of(BuiltinRegistries.f_123864_.m_7447_((Object)old)), ResourceKey.m_135785_((ResourceKey)Registry.f_122884_, (ResourceLocation)pool), (Object)new StructureTemplatePool(pool, old.m_210587_(), newWeightedPool), Lifecycle.stable());
        ParagliderMod.LOGGER.debug("Added {} elements to template pool '{}'", (Object)elementToWeight.length, (Object)pool);
    }
}

