/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import tictim.paraglider.contents.ModStructures;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class NetherHornedStatue
extends StructureFeature<RangeConfiguration> {
    public NetherHornedStatue() {
        super(RangeConfiguration.f_191320_, NetherHornedStatue::createGenerator);
    }

    private static Optional<PieceGenerator<RangeConfiguration>> createGenerator(PieceGeneratorSupplier.Context<RangeConfiguration> c) {
        WorldgenRandom r = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        ChunkPos chunkPos = c.f_197355_();
        r.m_190068_(c.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_);
        int x = chunkPos.m_45604_() + r.nextInt(12);
        int z = chunkPos.m_45605_() + r.nextInt(12);
        int seaLevel = c.f_197352_().m_6337_();
        WorldGenerationContext wgc = new WorldGenerationContext(c.f_197352_(), c.f_197357_());
        int wat = ((RangeConfiguration)c.f_197356_()).f_191321_.m_142233_((Random)r, wgc);
        NoiseColumn noise = c.f_197352_().m_141914_(x, z, c.f_197357_());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(x, wat, z);
        while (wat > seaLevel) {
            BlockState s = noise.m_183556_(wat);
            BlockState s2 = noise.m_183556_(--wat);
            if (!s.m_60795_() || !s2.m_60713_(Blocks.f_50135_) && !s2.m_60783_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.m_142448_(wat), Direction.UP)) continue;
            break;
        }
        if (wat <= seaLevel || !c.f_197358_().test(c.f_197352_().m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)wat), QuartPos.m_175400_((int)z)))) {
            return Optional.empty();
        }
        BlockPos pos2 = new BlockPos(x, wat - 1, z);
        return Optional.of((builder, context) -> builder.m_142679_((StructurePiece)new Piece(c.f_197359_(), Rotation.m_55956_((Random)r), pos2)));
    }

    public static StructurePieceType.StructureTemplateType pieceType() {
        return Piece::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class Piece
    extends BaseHornedStatuePiece {
        private static final ResourceLocation TEMPLATE = new ResourceLocation("paraglider", "nether_horned_statue");
        private static final BlockPos PIVOT = new BlockPos(2, 1, 2);

        public Piece(StructureManager structureManager, Rotation rotation, BlockPos templatePos) {
            super(ModStructures.NETHER_HORNED_STATUE_PIECE_TYPE, structureManager, TEMPLATE, rotation, templatePos);
            this.f_73657_.m_74385_(PIVOT);
        }

        public Piece(StructureManager structureManager, CompoundTag tag) {
            super(ModStructures.NETHER_HORNED_STATUE_PIECE_TYPE, structureManager, tag);
            this.f_73657_.m_74385_(PIVOT);
        }

        public void m_183269_(WorldGenLevel level, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            int y;
            int seaLevel = chunkGenerator.m_6337_();
            NoiseColumn baseColumn = chunkGenerator.m_141914_(this.f_73658_.m_123341_(), this.f_73658_.m_123343_(), (LevelHeightAccessor)level);
            BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(this.f_73658_.m_123341_(), y, this.f_73658_.m_123343_());
            for (y = seaLevel + random.nextInt(chunkGenerator.m_6331_() - 2 - seaLevel); y > seaLevel; --y) {
                BlockState state = baseColumn.m_183556_(y);
                BlockState downState = baseColumn.m_183556_(y - 1);
                if (state.m_60795_() && (downState.m_60713_(Blocks.f_50135_) || downState.m_60783_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.m_142448_(y - 1), Direction.UP))) break;
            }
            if (y > seaLevel) {
                this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), y, this.f_73658_.m_123343_());
                super.m_183269_(level, structureFeatureManager, chunkGenerator, random, box, chunkPos, pos);
            }
        }
    }
}

