/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import com.mojang.blaze3d.platform.Window;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.DisableStaminaRender;
import tictim.paraglider.client.InGameStaminaWheelRenderer;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.client.screen.ParagliderSettingScreen;
import tictim.paraglider.client.screen.StatueBargainScreen;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private static KeyMapping paragliderSettingsKey;
    private static final DecimalFormat PERCENTAGE;
    private static final StaminaWheelRenderer STAMINA_WHEEL_RENDERER;

    private ParagliderClientEventHandler() {
    }

    public static KeyMapping paragliderSettingsKey() {
        return paragliderSettingsKey;
    }

    public static void setParagliderSettingsKey(KeyMapping keyBinding) {
        if (paragliderSettingsKey != null) {
            throw new IllegalStateException("no");
        }
        paragliderSettingsKey = keyBinding;
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)player);
        if (m != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameOverlayTextRender(RenderGameOverlayEvent.Text event) {
        PlayerMovement h;
        LocalPlayer p;
        if (ModCfg.debugPlayerMovement() && (p = Minecraft.m_91087_().f_91074_) != null && (h = PlayerMovement.of((ICapabilityProvider)p)) != null) {
            ArrayList right = event.getRight();
            ArrayList<Object> arr = new ArrayList<Object>();
            arr.add("State: " + h.getState());
            arr.add((Serializable)(h.isDepleted() ? ChatFormatting.RED : "") + "Stamina: " + h.getStamina() + " / " + h.getMaxStamina());
            arr.add(h.getStaminaVessels() + " Stamina Vessels, " + h.getHeartContainers() + " Heart Containers");
            arr.add(h.getRecoveryDelay() + " Recovery Delay");
            arr.add("Paragliding: " + h.isParagliding());
            arr.add("Stamina Wheel X: " + PERCENTAGE.format(ModCfg.staminaWheelX()) + ", Stamina Wheel Y: " + PERCENTAGE.format(ModCfg.staminaWheelY()));
            if (!right.isEmpty()) {
                arr.add("");
            }
            right.addAll(0, arr);
        }
    }

    @SubscribeEvent
    public static void afterGameOverlayRender(RenderGameOverlayEvent.Post event) {
        if (Minecraft.m_91087_().f_91080_ instanceof DisableStaminaRender || event.getType() != RenderGameOverlayEvent.ElementType.ALL || !ModCfg.paraglidingConsumesStamina() && !ModCfg.runningConsumesStamina()) {
            return;
        }
        Window window = event.getWindow();
        int x = Mth.m_14045_((int)((int)Math.round(ModCfg.staminaWheelX() * (double)window.m_85445_())), (int)11, (int)(window.m_85445_() - 2 - 10));
        int y = Mth.m_14045_((int)((int)Math.round(ModCfg.staminaWheelY() * (double)window.m_85446_())), (int)11, (int)(window.m_85446_() - 2 - 10));
        STAMINA_WHEEL_RENDERER.renderStamina(event.getMatrixStack(), x, y, 25.0);
    }

    @SubscribeEvent
    public static void beforeGameOverlayLayerRender(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay() == ForgeIngameGui.CROSSHAIR_ELEMENT && Minecraft.m_91087_().f_91080_ instanceof StatueBargainScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ == null && ParagliderClientEventHandler.paragliderSettingsKey().m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ParagliderSettingScreen());
        }
    }

    static {
        PERCENTAGE = new DecimalFormat("#.#%");
        STAMINA_WHEEL_RENDERER = new InGameStaminaWheelRenderer();
    }
}

