/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.RemotePlayerMovement;
import tictim.paraglider.client.screen.StatueBargainScreen;
import tictim.paraglider.contents.ModAdvancements;
import tictim.paraglider.network.BargainMsg;
import tictim.paraglider.network.StatueDialogMsg;
import tictim.paraglider.network.SyncLookAtMsg;
import tictim.paraglider.network.SyncMovementMsg;
import tictim.paraglider.network.SyncParaglidingMsg;
import tictim.paraglider.network.SyncVesselMsg;
import tictim.paraglider.network.SyncWindMsg;
import tictim.paraglider.network.UpdateBargainPreviewMsg;
import tictim.paraglider.recipe.bargain.BargainResult;
import tictim.paraglider.recipe.bargain.StatueBargain;
import tictim.paraglider.recipe.bargain.StatueBargainContainer;
import tictim.paraglider.wind.Wind;

public final class ModNet {
    public static final String NETVERSION = "1.0";
    public static final SimpleChannel NET = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("paraglider", "master"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    private ModNet() {
    }

    public static void init() {
        NET.registerMessage(0, SyncMovementMsg.class, SyncMovementMsg::write, SyncMovementMsg::read, Client::handleSetMovement, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(1, SyncParaglidingMsg.class, SyncParaglidingMsg::write, SyncParaglidingMsg::read, Client::handleSetParagliding, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(2, SyncVesselMsg.class, SyncVesselMsg::write, SyncVesselMsg::read, Client::handleSetVessel, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(3, SyncWindMsg.class, SyncWindMsg::write, SyncWindMsg::read, Client::handleSyncWind, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(4, BargainMsg.class, BargainMsg::write, BargainMsg::read, ModNet::handleBargain, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NET.registerMessage(5, UpdateBargainPreviewMsg.class, UpdateBargainPreviewMsg::write, UpdateBargainPreviewMsg::read, Client::handleUpdateBargainPreview, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(6, StatueDialogMsg.class, StatueDialogMsg::write, StatueDialogMsg::read, Client::handleStatueDialog, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NET.registerMessage(7, SyncLookAtMsg.class, SyncLookAtMsg::write, SyncLookAtMsg::read, Client::handleSyncLookAt, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private static void handleBargain(BargainMsg msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ParagliderMod.LOGGER.error("Cannot handle BargainMsg: Wrong side");
                return;
            }
            AbstractContainerMenu patt3415$temp = player.f_36096_;
            if (!(patt3415$temp instanceof StatueBargainContainer)) {
                return;
            }
            StatueBargainContainer c = (StatueBargainContainer)patt3415$temp;
            for (StatueBargain bargain : c.getBargains()) {
                ResourceLocation a;
                if (!bargain.m_6423_().equals((Object)msg.bargain())) continue;
                BargainResult result = bargain.bargain((Player)player, false);
                if (result.isSuccess() && (a = c.getAdvancement()) != null) {
                    ModAdvancements.give(player, a, "bargain");
                }
                c.sendDialog(bargain, result);
                return;
            }
            ParagliderMod.LOGGER.info("Ignoring invalid bargain {}", (Object)msg.bargain());
        });
    }

    private static final class Client {
        private Client() {
        }

        public static void handleSetMovement(SyncMovementMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            PlayerMovement h = PlayerMovement.of((ICapabilityProvider)player);
            if (h != null) {
                if (ModCfg.traceMovementPacket()) {
                    ParagliderMod.LOGGER.debug("Received {}", (Object)msg);
                }
                msg.copyTo(h);
            } else {
                ParagliderMod.LOGGER.error("Couldn't handle packet {}, capability not found", (Object)msg);
            }
        }

        public static void handleSetParagliding(SyncParaglidingMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            Player player = world.m_46003_(msg.playerId());
            if (player != null) {
                PlayerMovement h = PlayerMovement.of((ICapabilityProvider)player);
                if (h != null) {
                    if (h instanceof RemotePlayerMovement) {
                        if (ModCfg.traceParaglidingPacket()) {
                            ParagliderMod.LOGGER.debug("Received {}", (Object)msg);
                        }
                        ((RemotePlayerMovement)h).setParagliding(msg.paragliding());
                    } else {
                        ParagliderMod.LOGGER.error("Couldn't handle packet {}, capability is found but not remote", (Object)msg);
                    }
                } else {
                    ParagliderMod.LOGGER.error("Couldn't handle packet {}, capability not found", (Object)msg);
                }
            } else {
                ParagliderMod.LOGGER.error("Couldn't find player with UUID {}", (Object)msg.playerId());
            }
        }

        public static void handleSetVessel(SyncVesselMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            PlayerMovement h = PlayerMovement.of((ICapabilityProvider)player);
            if (h != null) {
                h.setHeartContainers(msg.heartContainers());
                h.setStaminaVessels(msg.staminaVessels());
                h.setStamina(msg.stamina());
            } else {
                ParagliderMod.LOGGER.error("Couldn't handle packet {}, capability not found", (Object)msg);
            }
        }

        public static void handleSyncWind(SyncWindMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            Wind wind = Wind.of((ICapabilityProvider)world);
            if (wind != null) {
                wind.put(msg.windChunk());
            }
        }

        public static void handleUpdateBargainPreview(UpdateBargainPreviewMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                AbstractContainerMenu container = player.f_36096_;
                if (!(container instanceof StatueBargainContainer)) {
                    return;
                }
                StatueBargainContainer c = (StatueBargainContainer)container;
                for (Map.Entry<ResourceLocation, UpdateBargainPreviewMsg.Data> e : msg.getUpdated().entrySet()) {
                    c.setCanBargain(e.getKey(), e.getValue().canBargain());
                    if (e.getValue().demands() == null) continue;
                    c.setDemandPreview(e.getKey(), e.getValue().demands());
                }
            });
        }

        public static void handleStatueDialog(StatueDialogMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (!(screen instanceof StatueBargainScreen)) {
                    return;
                }
                StatueBargainScreen s = (StatueBargainScreen)screen;
                s.setDialog(msg.text());
            });
        }

        public static void handleSyncLookAt(SyncLookAtMsg msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().setPacketHandled(true);
            ctx.get().enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                AbstractContainerMenu container = player.f_36096_;
                if (!(container instanceof StatueBargainContainer)) {
                    return;
                }
                StatueBargainContainer c = (StatueBargainContainer)container;
                c.setLookAt(msg.lookAt());
            });
        }
    }
}

