/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import tictim.paraglider.recipe.bargain.StatueBargainContainer;

public class UpdateBargainPreviewMsg {
    private final Map<ResourceLocation, Data> updated = new HashMap<ResourceLocation, Data>();

    public static UpdateBargainPreviewMsg read(FriendlyByteBuf buf) {
        UpdateBargainPreviewMsg msg = new UpdateBargainPreviewMsg();
        int size = buf.readUnsignedByte();
        for (int i = 0; i < size; ++i) {
            msg.add(buf.m_130281_(), Data.readData(buf));
        }
        return msg;
    }

    public void add(ResourceLocation key, StatueBargainContainer.Preview preview, boolean includeItemDemands) {
        if (this.updated.size() >= 256) {
            throw new IllegalArgumentException("Too many recipes have been written in single packet");
        }
        this.updated.put(key, new Data(preview.canBargain(), includeItemDemands ? preview.getDemands() : null));
    }

    public void add(ResourceLocation key, Data data) {
        this.updated.put(key, data);
    }

    public Map<ResourceLocation, Data> getUpdated() {
        return this.updated;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.updated.size());
        for (Map.Entry<ResourceLocation, Data> e : this.updated.entrySet()) {
            buf.m_130085_(e.getKey());
            e.getValue().write(buf);
        }
    }

    public record Data(boolean canBargain, @Nullable StatueBargainContainer.ItemDemand[] demands) {
        private static Data readData(FriendlyByteBuf buf) {
            StatueBargainContainer.ItemDemand[] demands;
            boolean canBargain = buf.readBoolean();
            if (buf.readBoolean()) {
                demands = new StatueBargainContainer.ItemDemand[buf.m_130242_()];
                for (int i = 0; i < demands.length; ++i) {
                    demands[i] = Data.readItemDemand(buf);
                }
            } else {
                demands = null;
            }
            return new Data(canBargain, demands);
        }

        private static StatueBargainContainer.ItemDemand readItemDemand(FriendlyByteBuf buf) {
            ItemStack[] previewItems = new ItemStack[buf.m_130242_()];
            for (int i = 0; i < previewItems.length; ++i) {
                previewItems[i] = buf.m_130267_();
            }
            int quantity = buf.m_130242_();
            int count = buf.m_130242_();
            return new StatueBargainContainer.ItemDemand(previewItems, quantity, count);
        }

        private static void writeItemDemand(StatueBargainContainer.ItemDemand itemDemand, FriendlyByteBuf buf) {
            buf.m_130130_(itemDemand.getPreviewItems().length);
            for (ItemStack s : itemDemand.getPreviewItems()) {
                buf.m_130055_(s);
            }
            buf.m_130130_(itemDemand.getQuantity());
            buf.m_130130_(itemDemand.getCount());
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.canBargain);
            buf.writeBoolean(this.demands != null);
            if (this.demands != null) {
                buf.m_130130_(this.demands.length);
                for (StatueBargainContainer.ItemDemand d : this.demands) {
                    Data.writeItemDemand(d, buf);
                }
            }
        }
    }
}

