/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import tictim.paraglider.wind.WindNode;

public final class WindChunk {
    private final ChunkPos chunkPos;
    private final Byte2ObjectMap<WindNode> nodes = new Byte2ObjectLinkedOpenHashMap();

    public WindChunk(ChunkPos chunkPos) {
        this.chunkPos = Objects.requireNonNull(chunkPos);
    }

    public WindChunk(FriendlyByteBuf buf) {
        this.chunkPos = new ChunkPos(buf.readInt(), buf.readInt());
        for (int i = buf.readUnsignedByte(); i > 0; --i) {
            this.putNode(new WindNode(buf, buf.readUnsignedByte()));
        }
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @Nullable
    public WindNode getNode(int x, int z) {
        return (WindNode)this.nodes.get(this.encode(x, z));
    }

    @Nullable
    public WindNode putNode(WindNode node) {
        return (WindNode)this.nodes.put(this.encode(node.x, node.z), (Object)node);
    }

    @Nullable
    public WindNode removeAllNodesInXZ(int x, int z) {
        return (WindNode)this.nodes.remove(this.encode(x, z));
    }

    public Collection<WindNode> getAllRootNodes() {
        return this.nodes.values();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    private byte encode(int x, int z) {
        return (byte)(x << 4 & 0xF0 | z & 0xF);
    }

    public boolean isInsideWind(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.chunkPos.m_45604_() > maxX || this.chunkPos.m_45608_() < minX || this.chunkPos.m_45605_() > maxZ || this.chunkPos.m_45609_() < minZ) {
            return false;
        }
        int xs = Math.max(this.chunkPos.m_45604_(), minX);
        int xe = Math.min(this.chunkPos.m_45608_(), maxX);
        int zs = Math.max(this.chunkPos.m_45605_(), minZ);
        int ze = Math.min(this.chunkPos.m_45609_(), maxZ);
        for (int x = xs; x <= xe; ++x) {
            for (int z = zs; z <= ze; ++z) {
                WindNode node = this.getNode(x, z);
                while (node != null) {
                    if (node.y < maxY && node.y + node.height > minY) {
                        return true;
                    }
                    node = node.next;
                }
            }
        }
        return false;
    }

    public boolean add(int x, int y, int z, int height, long gameTime) {
        WindNode node = this.getNode(x, z);
        if (node != null) {
            return node.overwrite(y, height, gameTime);
        }
        this.putNode(new WindNode(x, y, z, height, gameTime));
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.chunkPos.f_45578_);
        buf.writeInt(this.chunkPos.f_45579_);
        buf.m_130130_(this.nodes.size());
        for (Byte2ObjectMap.Entry e : this.nodes.byte2ObjectEntrySet()) {
            ((WindNode)e.getValue()).write(buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindChunk windChunk = (WindChunk)o;
        return this.chunkPos.equals((Object)windChunk.chunkPos);
    }

    public int hashCode() {
        return this.chunkPos.hashCode();
    }
}

