/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.lodBuilding.bufferBuilding;

import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.BufferMergeDirectionEnum;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.render.LodRenderer;

public final class BufferQuad {
    final short x;
    final short y;
    final short z;
    short widthEastWest;
    short widthNorthSouthOrUpDown;
    final int color;
    final byte skyLight;
    final byte blockLight;
    final LodDirection direction;
    boolean hasError = false;

    BufferQuad(short x, short y, short z, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte skylight, byte blocklight, LodDirection direction) {
        if (widthEastWest == 0 || widthNorthSouthOrUpDown == 0) {
            throw new IllegalArgumentException("Size 0 quad!");
        }
        if (widthEastWest < 0 || widthNorthSouthOrUpDown < 0) {
            throw new IllegalArgumentException("Negative sized quad!");
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.widthEastWest = widthEastWest;
        this.widthNorthSouthOrUpDown = widthNorthSouthOrUpDown;
        this.color = color;
        this.skyLight = skylight;
        this.blockLight = blocklight;
        this.direction = direction;
    }

    double calculateDistance(double relativeX, double relativeY, double relativeZ) {
        return Math.pow(relativeX - (double)this.x, 2.0) + Math.pow(relativeY - (double)this.y, 2.0) + Math.pow(relativeZ - (double)this.z, 2.0);
    }

    public int compare(BufferQuad quad, BufferMergeDirectionEnum compareDirection) {
        if (this.direction != quad.direction) {
            throw new IllegalArgumentException("The other quad is not in the same direction: " + (Object)((Object)quad.direction) + " vs " + (Object)((Object)this.direction));
        }
        if (compareDirection == BufferMergeDirectionEnum.EastWest) {
            switch (this.direction.getAxis()) {
                case X: {
                    return BufferQuad.threeDimensionalCompare(this.x, this.y, this.z, quad.x, quad.y, quad.z);
                }
                case Y: {
                    return BufferQuad.threeDimensionalCompare(this.y, this.z, this.x, quad.y, quad.z, quad.x);
                }
                case Z: {
                    return BufferQuad.threeDimensionalCompare(this.z, this.y, this.x, quad.z, quad.y, quad.x);
                }
            }
            throw new IllegalArgumentException("Invalid Axis enum: " + this.direction.getAxis());
        }
        switch (this.direction.getAxis()) {
            case X: {
                return BufferQuad.threeDimensionalCompare(this.x, this.z, this.y, quad.x, quad.z, quad.y);
            }
            case Y: {
                return BufferQuad.threeDimensionalCompare(this.y, this.x, this.z, quad.y, quad.x, quad.z);
            }
            case Z: {
                return BufferQuad.threeDimensionalCompare(this.z, this.x, this.y, quad.z, quad.x, quad.y);
            }
        }
        throw new IllegalArgumentException("Invalid Axis enum: " + this.direction.getAxis());
    }

    private static int threeDimensionalCompare(short a0, short a1, short a2, short b0, short b1, short b2) {
        long a = (long)a0 << 48 | (long)a1 << 32 | (long)a2 << 16;
        long b = (long)b0 << 48 | (long)b1 << 32 | (long)b2 << 16;
        return Long.compare(a, b);
    }

    public boolean tryMerge(BufferQuad quad, BufferMergeDirectionEnum mergeDirection) {
        short otherParallelCompareWidth;
        short thisParallelCompareWidth;
        short thisPerpendicularCompareWidth;
        short otherParallelCompareStartPos;
        short otherPerpendicularCompareStartPos;
        short thisParallelCompareStartPos;
        short thisPerpendicularCompareStartPos;
        if (quad.hasError || this.hasError) {
            return false;
        }
        if (this.direction != quad.direction) {
            return false;
        }
        if (mergeDirection == BufferMergeDirectionEnum.EastWest && this.y != quad.y || mergeDirection == BufferMergeDirectionEnum.NorthSouthOrUpDown && this.x != quad.x) {
            return false;
        }
        switch (this.direction.getAxis()) {
            default: {
                if (mergeDirection == BufferMergeDirectionEnum.EastWest) {
                    thisPerpendicularCompareStartPos = this.z;
                    thisParallelCompareStartPos = this.x;
                    otherPerpendicularCompareStartPos = quad.z;
                    otherParallelCompareStartPos = quad.x;
                    break;
                }
                thisPerpendicularCompareStartPos = this.y;
                thisParallelCompareStartPos = this.z;
                otherPerpendicularCompareStartPos = quad.y;
                otherParallelCompareStartPos = quad.z;
                break;
            }
            case Y: {
                if (mergeDirection == BufferMergeDirectionEnum.EastWest) {
                    thisPerpendicularCompareStartPos = this.x;
                    thisParallelCompareStartPos = this.z;
                    otherPerpendicularCompareStartPos = quad.x;
                    otherParallelCompareStartPos = quad.z;
                    break;
                }
                thisPerpendicularCompareStartPos = this.z;
                thisParallelCompareStartPos = this.y;
                otherPerpendicularCompareStartPos = quad.z;
                otherParallelCompareStartPos = quad.y;
                break;
            }
            case Z: {
                if (mergeDirection == BufferMergeDirectionEnum.EastWest) {
                    thisPerpendicularCompareStartPos = this.x;
                    thisParallelCompareStartPos = this.z;
                    otherPerpendicularCompareStartPos = quad.x;
                    otherParallelCompareStartPos = quad.z;
                    break;
                }
                thisPerpendicularCompareStartPos = this.y;
                thisParallelCompareStartPos = this.z;
                otherPerpendicularCompareStartPos = quad.y;
                otherParallelCompareStartPos = quad.z;
            }
        }
        if (mergeDirection == BufferMergeDirectionEnum.EastWest) {
            thisPerpendicularCompareWidth = this.widthEastWest;
            thisParallelCompareWidth = this.widthNorthSouthOrUpDown;
            otherParallelCompareWidth = quad.widthNorthSouthOrUpDown;
        } else {
            thisPerpendicularCompareWidth = this.widthNorthSouthOrUpDown;
            thisParallelCompareWidth = this.widthEastWest;
            otherParallelCompareWidth = quad.widthEastWest;
        }
        if (thisPerpendicularCompareWidth >= 16) {
            return false;
        }
        if (Math.floorDiv(otherPerpendicularCompareStartPos, 16) != Math.floorDiv(thisPerpendicularCompareStartPos, 16)) {
            return false;
        }
        if (thisPerpendicularCompareStartPos + thisPerpendicularCompareWidth < otherPerpendicularCompareStartPos || thisParallelCompareStartPos != otherParallelCompareStartPos) {
            return false;
        }
        if (thisPerpendicularCompareStartPos + thisPerpendicularCompareWidth > otherPerpendicularCompareStartPos) {
            LodRenderer.EVENT_LOGGER.warn("Overlapping quads detected!", new Object[0]);
            quad.hasError = true;
            this.hasError = true;
            return false;
        }
        if (thisParallelCompareWidth != otherParallelCompareWidth) {
            return false;
        }
        if (this.color != quad.color || this.skyLight != quad.skyLight || this.blockLight != quad.blockLight) {
            return false;
        }
        if (mergeDirection == BufferMergeDirectionEnum.NorthSouthOrUpDown) {
            this.widthNorthSouthOrUpDown = (short)(this.widthNorthSouthOrUpDown + quad.widthNorthSouthOrUpDown);
        } else {
            this.widthEastWest = (short)(this.widthEastWest + quad.widthEastWest);
        }
        return true;
    }
}

